<?php
/**
 * Consent Database - single form - cons - page.
 *
 * @package  Iubenda
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
// Including partial header.
require_once IUBENDA_PLUGIN_PATH . 'views/partials/header.php';

/**
 * Generate HTML for select options based on an array of form fields.
 *
 * @param   array $form_fields  The array of form fields.
 * @param   mixed $selected     The selected value.
 */
function generate_select_options( $form_fields, $selected ) {
	foreach ( $form_fields as $index => $form_field ) {
		$form_field_is_array = is_array( $form_field );
		$form_field_value    = $form_field_is_array ? $index : $form_field;
		$form_field_label    = $form_field_is_array ? $form_field['label'] . ' (' . $form_field['type'] . ')' : $form_field;
		$form_field_selected = $form_field_is_array ? $index : $form_field;

		?>
		<option value="<?php echo esc_html( $form_field_value ); ?>" <?php selected( $selected, $form_field_selected ); ?>>
			<?php echo esc_html( $form_field_label ); ?>
		</option>
		<?php
	}
}

?>
<div class="main-box">

	<?php
	// Including partial site-info.
	require_once IUBENDA_PLUGIN_PATH . 'views/partials/site-info.php';

	// Including partial breadcrumb.
	require_once IUBENDA_PLUGIN_PATH . 'views/partials/breadcrumb.php';
	?>

	<form id="postbox-container-2" action="options.php" method="post">
		<?php
		settings_fields( iubenda()->settings->tabs['cons']['key'] );
		do_settings_sections( iubenda()->settings->tabs['cons']['key'] );
		add_settings_section(
			'iubenda_consent_form',
			__( 'Field Mapping', 'iubenda' ),
			array(
				iubenda()->settings,
				'iubenda_consent_form',
			),
			'iubenda_consent_solution'
		);

		$form_id = (int) iub_get_request_parameter( 'form_id', 0 );
		$form    = ! empty( $form_id ) ? iubenda()->forms->get_form( $form_id ) : false;

		if ( ! $form ) {
			return;
		}

		$subject       = isset( $form->form_subject ) && is_array( $form->form_subject ) ? array_map( 'sanitize_text_field', $form->form_subject ) : array();
		$preferences   = isset( $form->form_preferences ) && is_array( $form->form_preferences ) ? array_map( 'sanitize_text_field', $form->form_preferences ) : array();
		$exclude       = isset( $form->form_exclude ) && is_array( $form->form_exclude ) ? array_map( 'sanitize_text_field', $form->form_exclude ) : array();
		$legal_notices = isset( $form->form_legal_notices ) && is_array( $form->form_legal_notices ) ? array_map( 'sanitize_text_field', $form->form_legal_notices ) : array();

		$available_fields = array();
		if ( ! empty( $form->form_fields ) && is_array( $form->form_fields ) ) {
			foreach ( $form->form_fields as $index => $form_field ) {
				if ( is_array( $form_field ) ) {
					$available_fields[] = $form_field['label'] . ' (' . $form_field['type'] . ')';
				} else {
					$available_fields[] = $form_field;
				}
			}
		}
		?>
		<input type="hidden" value="<?php echo esc_attr( $form_id ); ?>" name="form_id">
		<div class="px-4 px-lg-5">
			<div class="py-5">
				<div class="d-block d-lg-flex justify-content-between mb-4">
					<div class="d-block d-lg-flex align-items-center text-center text-lg-left">
						<h3 class="m-0 mb-4"><?php esc_html_e( 'Map fields', 'iubenda' ); ?></h3>
					</div>
					<div class="d-block d-lg-flex align-items-center text-center text-lg-right">
						<div class="misc-pub-section misc-pub-post-status p-0">
							<label for="status"><?php esc_html_e( 'Status', 'iubenda' ); ?>:</label>
							<div id="status-select" class="" style="margin: 3px 0 0;">
								<select id="status" name="status">
									<?php foreach ( iubenda()->forms->statuses as $name => $label ) : ?>
										<option value="<?php echo esc_html( $name ); ?>" <?php selected( $form->post_status, $name ); ?>><?php echo esc_html( $label ); ?></option>
									<?php endforeach; ?>
								</select>
							</div>
						</div>
					</div>
				</div>

				<h4 class="m-0 mb-2"><?php esc_html_e( 'Subject fields', 'iubenda' ); ?> <span class="required">(required)</span></h4>
				<p class="mb-3 description"><?php esc_html_e( 'Subject fields allow you to store a series of identifying values about your individual subjects/users. Please map the subject  field with the corresponding form fields where applicable.', 'iubenda' ); ?></p>
				<table class="widefat mb-4 subject-table">
					<thead>
					<td class="label"><?php esc_html_e( 'Subject field', 'iubenda' ); ?></td>
					<td class="label"><?php esc_html_e( 'Form field', 'iubenda' ); ?></td>
					</thead>
					<tbody>
					<?php
					foreach ( iubenda()->settings->subject_fields as $field_name => $field_label ) :
						$selected = isset( $subject[ $field_name ] ) ? $subject[ $field_name ] : '';
						$none     = 'id' === $field_name ? esc_html__( 'Autogenerated', 'iubenda' ) : esc_html__( 'None', 'iubenda' );
						?>
						<tr class="subject-field options-field">
							<td><?php echo esc_html( $field_name ) . '(' . esc_html( $field_label ) . ')'; ?> </td>
							<td>
								<select
										class="subject-fields-select select-<?php echo esc_html( $field_name ); ?>"
										name="subject[<?php echo esc_html( $field_name ); ?>]"
								>
									<option value="" <?php selected( $selected, '' ); ?>><?php echo esc_html( $none ); ?></option>
									<?php
									if ( ! empty( $form->form_fields ) ) {
										generate_select_options( $form->form_fields, $selected );
									}
									?>
								</select>
							</td>
						</tr>
					<?php endforeach; ?>
					</tbody>
				</table>
				<br>
				<h4 class="m-0 mb-2"><?php esc_html_e( 'Preferences fields', 'iubenda' ); ?></h4>
				<p class="mb-3 description"><?php esc_html_e( 'Preferences fields allow you to store a record of the various opt-ins points at which the user has agreed or given consent, such as fields for agreeing to terms and conditions, newsletter, profiling, etc.', 'iubenda' ); ?></p>
				<table class="widefat mb-4 preferences-table">
					<thead>
					<td class="label"><?php esc_html_e( 'Preferences field', 'iubenda' ); ?></td>
					<td class="label"><?php esc_html_e( 'Form field', 'iubenda' ); ?></td>
					</thead>
					<tbody>
					<tr id="preferences-field-template" class="template-field" style="display: none;">
						<td><input type="text" class="preferences-inputs regular-text" value="" name="preferences[__PREFERENCE_ID__][field]" placeholder="<?php esc_html_e( 'Enter field name', 'iubenda' ); ?>" disabled/></td>
						<td>
							<select class="preferences-inputs preferences-fields-select" name="preferences[__PREFERENCE_ID__][value]" disabled>
								<?php
								if ( ! empty( $form->form_fields ) ) {
									foreach ( $form->form_fields as $index => $form_field ) :
										// get field data.
										$form_field_value = is_array( $form_field ) ? $index : $form_field;
										$form_field_label = is_array( $form_field ) ? $form_field['label'] . ' (' . $form_field['type'] . ')' : $form_field;

										?>
										<option value="<?php echo esc_html( $form_field_value ); ?>"><?php echo esc_html( $form_field_label ); ?></option>
										<?php
									endforeach;
								}
								?>
							</select>
							<a href="javascript:void(0)" class="remove-preferences-field button-secondary" title="<?php esc_html_e( 'Remove', 'iubenda' ); ?>">-</a>
						</td>
					</tr>
					<?php
					if ( $preferences ) :
						$index = 0;
						foreach ( $preferences as $field_name => $field_value ) :
							$selected = isset( $field_value ) ? $field_value : '';

							?>
							<tr class="preferences-field options-field">
								<td><input type="text" class="regular-text" value="<?php echo esc_html( $field_name ); ?>" name="preferences[<?php echo esc_html( $index ); ?>][field]" placeholder="<?php esc_html_e( 'Enter field name', 'iubenda' ); ?>"/></td>
								<td>
									<select class="preferences-fields-select select-<?php echo esc_html( $field_name ); ?>" name="preferences[<?php echo esc_html( $index ); ?>][value]">
										<?php
										if ( ! empty( $form->form_fields ) ) {
											generate_select_options( $form->form_fields, $selected );
										}
										?>
									</select>
									<a href="javascript:void(0)" class="remove-preferences-field button-secondary" title="<?php esc_html_e( 'Remove', 'iubenda' ); ?>">-</a>
								</td>
							</tr>
							<?php
							++$index;
						endforeach;
					endif;
					?>
					<tr class="submit-field">
						<td colspan="2"><a href="javascript:void(0)" class="add-preferences-field button-secondary"><?php esc_html_e( 'Add New Preference', 'iubenda' ); ?></a></td>
					</tr>
					</tbody>
				</table>
				<br>
				<h4 class="m-0 mb-2"><?php esc_html_e( 'Exclude fields', 'iubenda' ); ?></h4>
				<p class="mb-3 description">
					<?php esc_html_e( 'Exclude fields allow you to create a list of fields that you would like to exclude from your Consent Database recorded proofs (for e.g. password or other fields not related to the consent).', 'iubenda' ); ?>
				</p>
				<table class="widefat mb-4 exclude-table">
					<thead>
					<td class="label"><?php esc_html_e( 'Exclude field', 'iubenda' ); ?></td>
					<td class="label"></td>
					</thead>
					<tbody>
					<tr id="exclude-field-template" class="template-field" style="display: none;">
						<td>
							<select class="exclude-fields-select" name="exclude[__EXCLUDE_ID__][field]" disabled>
								<?php
								if ( ! empty( $form->form_fields ) ) {
									foreach ( $form->form_fields as $index => $form_field ) :
										// get field data.
										$form_field_value = is_array( $form_field ) ? $index : $form_field;
										$form_field_label = is_array( $form_field ) ? $form_field['label'] . ' (' . $form_field['type'] . ')' : $form_field;

										?>
										<option value="<?php echo esc_html( $form_field_value ); ?>"><?php echo esc_html( $form_field_label ); ?></option>
										<?php
									endforeach;
								}
								?>
							</select>
							<a href="javascript:void(0)" class="remove-exclude-field button-secondary" title="<?php esc_html_e( 'Remove', 'iubenda' ); ?>">-</a>
						</td>
					</tr>
					<?php
					if ( $exclude ) {
						$index = 0;
						foreach ( $exclude as $index => $field_name ) :
							$selected = isset( $field_name ) ? $field_name : '';

							?>
							<tr class="exclude-field options-field">
								<td>
									<select class="exclude-fields-select select-<?php echo esc_html( $field_name ); ?>" name="exclude[<?php echo esc_html( $index ); ?>][field]">
										<?php
										if ( ! empty( $form->form_fields ) ) {
											generate_select_options( $form->form_fields, $selected );
										}
										?>
									</select>
									<a href="javascript:void(0)" class="remove-exclude-field button-secondary" title="<?php esc_html_e( 'Remove', 'iubenda' ); ?>">-</a>
								</td>
								<td></td>
							</tr>
							<?php
							++$index;
						endforeach;
					}
					?>
					<tr class="submit-field">
						<td colspan="2"><a href="javascript:void(0)" class="add-exclude-field button-secondary"><?php esc_html_e( 'Add New Exclude', 'iubenda' ); ?></a></td>
					</tr>
					</tbody>
				</table>

				<br>
				<h4 class="m-0 mb-2"><?php esc_html_e( 'Legal documents', 'iubenda' ); ?></h4>
				<p class="mb-3 description"><?php esc_html_e( 'In general, it\'s important that you declare which legal documents are being agreed upon when each consent is collected. However, if you use iubenda for your legal documents, it is *required*  that you identify the documents by selecting them here.', 'iubenda' ); ?></p>
				<table class="widefat mb-4 legal_notices-table">
					<thead>
					<td class="label"><?php esc_html_e( 'Identifier', 'iubenda' ); ?></td>
					<td class="label"></td>
					</thead>
					<tbody>
					<?php
					// default identifiers.
					foreach ( iubenda()->settings->legal_notices as $index => $field_name ) :
						?>
						<tr class="legal_notices-field default-field">
							<td>
								<?php if ( esc_html( $index ) === 0 ) : ?>
									<p class="description">
										<?php esc_html_e( 'Please select each legal document available on your site.', 'iubenda' ); ?>
									</p>
								<?php endif; ?>
								<label for="legal_notices-default-field=<?php echo esc_html( $index ); ?>">
									<input
											id="legal_notices-default-field=<?php echo esc_html( $index ); ?>"
											type="checkbox" value="<?php echo esc_html( $field_name ); ?>"
											name="legal_notices[<?php echo esc_html( $index ); ?>][field]"
										<?php checked( in_array( $field_name, $legal_notices, true ) ); ?>
											placeholder="<?php esc_html_e( 'Enter field name', 'iubenda' ); ?>"/>
									<?php echo esc_html( $field_name ); ?>
								</label>
							</td>
							<td></td>
						</tr>
						<?php
					endforeach;
					$next_legal_notice = count( iubenda()->settings->legal_notices ) + 1;
					?>
					<tr id="legal_notices-field-template" class="template-field" style="display: none;">
						<td>
							<input type="text" value="" name="legal_notices[__LEGAL_NOTICE_ID__][field]"
									placeholder="<?php esc_html_e( 'Enter field name', 'iubenda' ); ?>"
									class="regular-text legal-notices-inputs" disabled/>
							<a href="javascript:void(0)" class="remove-legal_notices-field button-secondary" title="<?php esc_html_e( 'Remove', 'iubenda' ); ?>">-</a>
						</td>
						<td></td>
					</tr>
					<tr>
						<td colspan="2">
							<p class="description" style="margin-bottom: 0;">
								<?php esc_html_e( 'Alternatively, you may add your own custom document identifiers.', 'iubenda' ); ?>
							</p>
						</td>
					</tr>
					<?php
					if ( $legal_notices ) :
						foreach ( $legal_notices as $field_name ) :
							if ( in_array( $field_name, iubenda()->settings->legal_notices, true ) ) {
								continue;
							}
							?>
							<tr class="legal_notices-field options-field">
								<td>
									<input type="text" class="regular-text" value="<?php echo esc_html( $field_name ); ?>"
											name="legal_notices[<?php echo esc_html( $next_legal_notice ); ?>][field]"
											placeholder="<?php esc_html_e( 'Enter field name', 'iubenda' ); ?>"/>
									<a href="javascript:void(0)" class="remove-legal_notices-field button-secondary" title="<?php esc_html_e( 'Remove', 'iubenda' ); ?>">-</a>
								</td>
								<td></td>
							</tr>
							<?php
							++$next_legal_notice;
						endforeach;
					endif;
					?>
					<tr class="submit-field">
						<td colspan="2">
							<a href="javascript:void(0)" class="add-legal_notices-field button-secondary">
								<?php esc_html_e( 'Add New Document', 'iubenda' ); ?>
							</a>
						</td>
					</tr>
					</tbody>
				</table>
			</div>
		</div>
		<hr>
		<div class="p-4 d-flex justify-content-end">
			<input class="btn btn-gray-lighter btn-sm mr-2" type="button" value="<?php esc_html_e( 'Cancel', 'iubenda' ); ?>" onclick="window.location.href = '<?php echo esc_url( add_query_arg( array( 'view' => 'cons-configuration' ), iubenda()->base_url ) ); ?>'"/>
			<button id="save-settings-btn" type="submit" class="btn btn-green-primary btn-sm"
					value="Save" name="save">
				<span class="button__text"><?php esc_html_e( 'Save settings', 'iubenda' ); ?></span>
			</button>
		</div>
	</form>
</div>

<?php
// Including partial footer.
require_once IUBENDA_PLUGIN_PATH . 'views/partials/footer.php';
?>
