<?php

if (! defined('ABSPATH')) exit;

//ここでSNS投稿エディタ用のJSをエンキュー
$script_path = ITMAR_SNS_PLUGIN_PATH . 'js/sns_login_render.js';
wp_enqueue_script('sns_login_render', ITMAR_SNS_PLUGIN_URL . 'js/sns_login_render.js', array('jquery'), filemtime($script_path), true);
// その後、このハンドルを使用してスクリプトの翻訳をセット
wp_set_script_translations('sns_login_render', 'itmaroon-social-post-sync', plugin_dir_path(__FILE__) . 'languages');

// 許可するHTML（管理画面用：input/label等を許可）
$allowed = array(
    'div'   => array('class' => true, 'id' => true),
    'img'   => array('src' => true, 'alt' => true, 'class' => true),
    'p'     => array('class' => true),
    'span'  => array('class' => true),
    'label' => array('for' => true, 'class' => true),
    'input' => array(
        'type'    => true,
        'name'    => true,
        'value'   => true,
        'checked' => true,
        'id'      => true,
        'class'   => true,
    ),
);
?>
<div class="wrap sns-relate-login">
    <div class="page_title">
        <?php esc_html_e('Posting destination settings', 'itmaroon-social-post-sync') ?>
    </div><!-- /.page_title -->
    <div class="condition_area">
        <div class="work_content_title">
            <?php esc_html_e('WordPress Post Types', 'itmaroon-social-post-sync') ?>
        </div><!-- /.work_content_title -->
        <div class="wp_buttons">
            <div class="inner_title">
                <?php esc_html_e('Select Post Type', 'itmaroon-social-post-sync') ?>
            </div><!-- /.inner_title -->
            <div class="post_select">
                <select name="post_type" class="nomal" id="id_postType" data-placeholder="<?php esc_html_e('Choose a post type', 'itmaroon-social-post-sync') ?>">

                    <?php
                    $post_types = itmar_get_post_types();
                    foreach ($post_types as $post_type) {
                        global $POST_GET_TYPE;
                        echo '<option class="post_item" value="';
                        //WordPressに既に登録されている投稿タイプがある場合
                        if ($post_type->name === $POST_GET_TYPE) {
                            echo esc_attr($post_type->name) . '" data-icon="' . esc_attr($post_type->menu_icon) . '" selected>';
                        } else {
                            echo esc_attr($post_type->name) . '" data-icon="' . esc_attr($post_type->menu_icon) . '">';
                        }
                        echo esc_html($post_type->labels->name) . '</option>';
                    }
                    ?>
                </select><!-- /#id_postType -->

            </div><!-- /.post_list -->
        </div><!-- /.wp_buttons -->
    </div><!-- /.condition_area -->


    <div class="condition_area">
        <div class="work_content_title">
            <?php esc_html_e('Setting up SNS connections', 'itmaroon-social-post-sync') ?>
        </div><!-- /.work_content_title -->
        <div class="tw_buttons">
            <div class="inner_title">
                <?php esc_html_e('X user link information', 'itmaroon-social-post-sync') ?>
            </div><!-- /.inner_title -->
            <div class="twitter_header menu">
                <?php
                //Twitterユーザー情報表示
                echo wp_kses(itmar_disp_login_info('tw'), $allowed);
                ?>
            </div><!-- /.twitter_header -->
            <div class="tw_btn">
                <?php
                $relay_base = ITMAR_RELAY_SERVER_PATH;
                $return_url = admin_url('admin.php?page=itmaroon-social-post-sync-login');

                // 通常
                $twlogin_url = add_query_arg('guest', $return_url, $relay_base . '/oauth/twitter/login');

                // 別アカウントで接続（←これを追加）
                $twlogin_url_switch = add_query_arg([
                    'guest'  => $return_url,
                    'switch' => 1,
                ], $relay_base . '/oauth/twitter/login');
                ?>

                <a href="<?php echo esc_url($twlogin_url_switch); ?>">
                    <?php echo esc_html__('Change Connection', 'itmaroon-social-post-sync'); ?>
                </a>
            </div><!-- /.tw_btn -->
        </div><!-- /.tw_buttons -->

        <div class="fb_buttons">
            <div class="inner_title">
                <?php esc_html_e('Facebook page link information', 'itmaroon-social-post-sync') ?>
            </div><!-- /.inner_title -->

            <div class="fb_content">
                <?php
                echo wp_kses(itmar_disp_login_info('fb'), $allowed);
                ?>

                <div class="fb_btn">
                    <?php
                    $return_url = admin_url('admin.php?page=itmaroon-social-post-sync-login');
                    $granted = get_option('itmar_facebook_granted', '[]');
                    // もし保存時に配列で保存してたら配列で返ってくるので、文字列に直す
                    if (is_array($granted)) {
                        $granted_json = json_encode($granted, JSON_UNESCAPED_UNICODE);
                    } else {
                        // すでにJSON文字列で保存してある場合はこちら
                        $granted_json = $granted;
                    }

                    $fblogin_url = ITMAR_RELAY_SERVER_PATH
                        . '/fblogin?guest=' . urlencode($return_url)
                        . '&granted=' . urlencode($granted_json);
                    ?>

                    <a href="<?php echo esc_url($fblogin_url); ?>">
                        <?php echo esc_html__('Change Connection', 'itmaroon-social-post-sync'); ?>
                    </a>
                </div><!-- /.fb_btn -->

            </div><!-- /.fb_buttons -->

            <div class="insta_info">
                <div class="inner_title">
                    <?php esc_html_e('Instagram integration information', 'itmaroon-social-post-sync') ?>
                </div><!-- /.inner_title -->
                <div class="instagram_header menu">
                    <?php
                    echo wp_kses(itmar_disp_login_info('ig'), $allowed);
                    ?>

                </div><!-- /.insta_header -->
            </div><!-- /.insta_info -->
        </div><!-- /.condition_area -->
    </div>
</div>