<?php

if (! defined('ABSPATH')) exit;

//ここでSNS投稿エディタ用のJSをエンキュー
$script_path = ITMAR_SNS_PLUGIN_PATH . 'js/sns_list_render.js';
wp_enqueue_script('sns_list_render', ITMAR_SNS_PLUGIN_URL . 'js/sns_list_render.js', array('jquery'), filemtime($script_path), true);
// その後、このハンドルを使用してスクリプトの翻訳をセット
wp_set_script_translations('sns_list_render', 'itmaroon-social-post-sync', plugin_dir_path(__FILE__) . 'languages');

?>
<div class="wrap sns-relate-list">
    <div class="page_title">
        <?php esc_html_e('SNS Post List', 'itmaroon-social-post-sync') ?>
        <div class="title_postType">
            <?php esc_html_e('Supported post types：', 'itmaroon-social-post-sync') ?><br class="sp_br">
            <span>
                <?php
                global $POST_GET_TYPE;
                $obj_postType = get_post_type_object($POST_GET_TYPE);
                echo '<span class="wp-menu-image dashicons-before ' . esc_attr($obj_postType->menu_icon) . '"></span>';
                echo '<span>' . esc_html($obj_postType->labels->name) . '</span>';
                ?>
            </span>
        </div><!-- /.title_postType -->
    </div><!-- /.page_title -->
    <div class="snslist_frame frame">
        <div class="snslist_inner inner">

            <div class="scroll_wrapper">
                <table>

                    <thead>
                        <th><?php esc_html_e('Operation', 'itmaroon-social-post-sync') ?></th>
                        <th><?php esc_html_e('Post date', 'itmaroon-social-post-sync') ?></th>
                        <th><?php esc_html_e('Status', 'itmaroon-social-post-sync') ?></th>
                        <th><?php esc_html_e('Title', 'itmaroon-social-post-sync') ?></th>
                    </thead>

                    <?php
                    //$paged = isset($_GET['paged']) ? intval($_GET['paged']) : 1;
                    $paged = (int) get_query_var('paged');
                    if ($paged < 1) {
                        // 管理画面などでquery varが立っていない場合のフォールバック
                        $paged = isset($_GET['paged'])
                            ? max(1, absint(wp_unslash($_GET['paged'])))
                            : 1; // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Read-only pagination parameter; no state change.
                    }

                    $args = array(
                        'post_type' => $obj_postType->name, // 投稿タイプ
                        'order' => 'desc',
                        'orderby' => 'post_date',
                        'paged' => $paged,
                        'posts_per_page' => 10,
                        'post_status' => array('publish', 'draft', 'future')
                    );
                    $subQuery = new WP_Query($args);
                    if ($subQuery->have_posts()) :
                        while ($subQuery->have_posts()):
                            $subQuery->the_post();

                            $post_id = get_the_ID();
                            $url = add_query_arg(
                                array(
                                    'page'       => 'itmaroon-social-post-sync-editor',
                                    'editpostID' => (int) $post_id,
                                ),
                                admin_url('admin.php')
                            );

                            // 第2引数: アクション名（IDを混ぜると堅牢）
                            // 第3引数: nonceのクエリ名（任意。ここでは itmar_nonce）
                            $url = wp_nonce_url($url, 'itmar_edit_post_' . $post_id, 'itmar_nonce');
                    ?>
                            <tbody>
                                <tr>
                                    <td rowspan="5" class="ctrl">
                                        <div class="tr_toggle">
                                            <img src="<?php echo esc_url(ITMAR_SNS_PLUGIN_URL . '/img/tr_toggle.png'); ?>" alt="">
                                        </div><!-- /.tr_open -->

                                        <a class="snslist_btn" rel="noopener" href="<?php echo esc_url($url); ?>">
                                            <?php esc_html_e('Edit', 'itmaroon-social-post-sync') ?>
                                        </a>

                                    </td>
                                    <td class="snslist_date">
                                        <time datetime="<?php echo get_the_date('c'); ?>">
                                            <span><?php echo get_the_date(get_option('date_format')); ?></span>
                                            <br class="sp_br">
                                            <span><?php echo get_the_date(get_option('time_format')); ?></span>
                                        </time>
                                        <br class="sp_br">
                                        <?php if (get_post_status() === 'draft' || get_post_status() === 'future'): ?>
                                            <span class="sp_br caution">
                                            <?php else: ?>
                                                <span class="sp_br">
                                                <?php endif; ?>

                                                <?php
                                                if (get_post_status() === 'draft') {
                                                    esc_html_e('(draft)', 'itmaroon-social-post-sync');
                                                } elseif (get_post_status() === 'future') {
                                                    esc_html_e('(Scheduled posts)', 'itmaroon-social-post-sync');
                                                } else {
                                                    esc_html_e('(Published)', 'itmaroon-social-post-sync');
                                                }
                                                ?>
                                                </span>
                                            </span>

                                            <?php if (get_post_status() === 'draft' || get_post_status() === 'future'): ?>
                                    <td class="status caution">
                                    <?php else: ?>
                                    <td class="status">
                                    <?php endif; ?>

                                    <?php
                                    if (get_post_status() === 'draft') {
                                        esc_html_e('(draft)', 'itmaroon-social-post-sync');
                                    } elseif (get_post_status() === 'future') {
                                        esc_html_e('(Scheduled posts)', 'itmaroon-social-post-sync');
                                    } else {
                                        esc_html_e('(Published)', 'itmaroon-social-post-sync');
                                    }
                                    ?>
                                    </td>

                                    <td class="snslist_title">
                                        <?php the_title() ?>
                                    </td><!-- /.snslist_title -->
                                </tr>

                                <tr class="hide_tr">
                                    <th>
                                        <div><?php esc_html_e('explanation', 'itmaroon-social-post-sync') ?></div>
                                    </th>
                                    <td colspan="2">
                                        <div>
                                            <?php
                                            the_excerpt();
                                            ?>
                                        </div>

                                    </td><!-- /.snslist_excerpt -->
                                </tr>

                                <tr class="hide_tr">
                                    <th>
                                        <div><?php esc_html_e('Posting to X', 'itmaroon-social-post-sync') ?></div>
                                    </th>
                                    <td colspan="2">
                                        <?php
                                        $sns_satus = get_post_meta(get_the_ID(), 'twitter_id', true);
                                        itmar_disp_sns_status($sns_satus);
                                        ?>

                                    </td>
                                </tr><!-- /.snslist_post -->
                                <tr class="hide_tr">
                                    <th>
                                        <div><?php esc_html_e('Posting to Facebook', 'itmaroon-social-post-sync') ?></div>
                                    </th>
                                    <td colspan="2">
                                        <?php
                                        $sns_satus = get_post_meta(get_the_ID(), 'facebook_id', true);
                                        itmar_disp_sns_status($sns_satus);
                                        ?>
                                    </td>
                                </tr><!-- /.snslist_post -->
                                <tr class="hide_tr">
                                    <th>
                                        <div><?php esc_html_e('Posting to Instagram', 'itmaroon-social-post-sync') ?></div>
                                    </th>
                                    <td colspan="2">
                                        <?php
                                        $wp_id = get_the_ID();
                                        $sns_status = get_post_meta($wp_id, 'instagram_id', true);
                                        itmar_disp_sns_status($sns_status);
                                        ?>

                                    </td>
                                </tr><!-- /.snslist_post -->
                            </tbody>

                        <?php endwhile; ?>
                    <?php endif;
                    wp_reset_postdata(); ?>

                </table>
            </div><!-- /.scroll_wrapper -->

            <?php
            $total = $subQuery->max_num_pages;
            itmar_sns_pagenation($total);
            ?>
        </div><!-- /.snslist_inner -->

    </div><!-- /.snslist_frame -->


</div>