<?php

if (! defined('ABSPATH')) exit;

//ここでSNS投稿エディタ用のJSをエンキュー
$script_path = ITMAR_SNS_PLUGIN_PATH . 'js/sns_import_render.js';
wp_enqueue_script('sns_import_render', ITMAR_SNS_PLUGIN_URL . 'js/sns_import_render.js', array('jquery'), filemtime($script_path), true);
// その後、このハンドルを使用してスクリプトの翻訳をセット
wp_set_script_translations('sns_import_render', 'itmaroon-social-post-sync', plugin_dir_path(__FILE__) . 'languages');

?>
<div class="wrap sns-relate-import">

    <div class="page_title">
        <?php esc_html_e('Importing posts from SNS', 'itmaroon-social-post-sync') ?>
        <div class="title_postType">
            <?php esc_html_e('Save the post to this post type:', 'itmaroon-social-post-sync') ?><br class="sp_br">
            <span>
                <?php
                global $POST_GET_TYPE;
                $obj_postType = get_post_type_object($POST_GET_TYPE);
                echo '<span class="wp-menu-image dashicons-before ' . esc_attr($obj_postType->menu_icon) . '"></span>';
                echo '<span>' . esc_attr($obj_postType->labels->name) . '</span>';
                ?>
            </span>

        </div><!-- /.title_postType -->
    </div><!-- /.page_title -->

    <div class="sns_contents">
        <div class="sns_inner">
            <div class="facebook_area">
                <?php
                //ユーザー、ページ情報の取得

                $api = new \Itmar\SNS\Facebook\ApiHelper();
                $user = $api->get_user_info();
                $pageInfo = $api->get_page_info();

                if (!is_null($user) && !is_null($pageInfo)) {
                    $user_id = $user['id'];
                    $user_avter_url = $user['avatar_url'];
                    $user_name = $user['name'];
                    $page_name = $pageInfo['name'];
                    $page_icon_url = $pageInfo['picture']['data']['url'];
                    $page_url = $pageInfo['link'];
                    $followers_count = $pageInfo['followers_count'];

                    echo '<div class="facebook_header sns_header" id="' . esc_attr($user_id) . '">';
                    echo '<div>';
                    echo '<div class="page_info">
                    <div class="image"><img src="' . esc_url($page_icon_url) . '"></div>
                    <div class="text"><a href="' . esc_url($page_url) . '" target="_blank">' . esc_html($page_name) . '</a></div>
                    </div><!-- /.page_info -->';
                    echo '<div class="user_info">
                    <div class="image"><img src="' . esc_url($user_avter_url) . '"></div>
                    <div class="text">' . esc_html($user_name) . '</div>
                    </div><!-- /.user_info -->';
                    echo '</div>';

                    echo '<div class="follow_wrapper">';
                    echo '<div class="follower white"><span>' . esc_html($followers_count) . '</span>' . esc_html_e('Followers', 'itmaroon-social-post-sync') . '</div>';
                    echo '</div><!-- /.follow_wrapper -->';
                } else {
                    echo '<div class="facebook_header sns_header">';
                    echo '<div class="user_info error"><div class="text">' . esc_html_e('We were unable to obtain your Facebook login information.', 'itmaroon-social-post-sync') . '</div></div><!-- /.user_info -->';
                }
                ?>

                <div class="header_logo">
                    <img src="<?php echo esc_url(ITMAR_SNS_PLUGIN_URL . '/img/facebook_w.png'); ?>" alt="">
                </div><!-- /.header_logo -->
            </div><!-- /.facebook_header -->

            <div class="sns_wrapper" data-sns-type="facebook" data-current-index="0" data-next-after="">
                <div class="sns_output_area"></div>
                <div class="facebook_footer">
                    <div class="load_more_btn">
                        <?php esc_html_e('Show more...', 'itmaroon-social-post-sync') ?>
                    </div><!-- /.load_more_btn -->
                </div><!-- /.facebook_footer -->
            </div><!-- /.sns_wrapper -->

        </div><!-- /.facebook_area -->
        <div class="instagram_area">
            <?php
            //ユーザー、ページ情報の取得

            $api = new \Itmar\SNS\Instagram\ApiHelper();
            $user = $api->get_user_info();

            if (!is_null($user)) {
                $user_id = $user['id'];
                $user_avter_url = $user['avatar_url'];
                $user_name = $user['name'];
                $website = $user['website'];
                $followers_count = $user['followers_count'];

                echo '<div class="instagram_header sns_header" id="' . esc_attr($user_id) . '">';

                echo '<div class="user_info">
                    <div class="image"><img src="' . esc_url($user_avter_url) . '"></div>
                    <div class="text">' . esc_html($user_name) . '</div>
                    </div><!-- /.user_info -->';

                echo '<div class="follow_wrapper">';
                echo '<div class="follower white"><span>' . esc_html($followers_count) . '</span>' . esc_html_e('Followers', 'itmaroon-social-post-sync') . '</div>';
                echo '</div><!-- /.follow_wrapper -->';
            } else {
                echo '<div class="instagram_header sns_header">';
                echo '<div class="user_info error"><div class="text">' . esc_html_e('We were unable to obtain your Facebook login information.', 'itmaroon-social-post-sync') . '</div></div><!-- /.user_info -->';
            }
            ?>

            <div class="header_logo">
                <img src="<?php echo esc_url(ITMAR_SNS_PLUGIN_URL . '/img/instagram_w.png'); ?>" alt="">
            </div><!-- /.header_logo -->
        </div><!-- /.instagram_header -->

        <div class="sns_wrapper" data-sns-type="instagram" data-current-index="0" data-next-after="">
            <div class="sns_output_area"></div>
            <div class="instagram_footer">
                <div class="load_more_btn">
                    <?php esc_html_e('Show more...', 'itmaroon-social-post-sync') ?>
                </div><!-- /.load_more_btn -->
            </div><!-- /.facebook_footer -->
        </div><!-- /.sns_wrapper -->
    </div><!-- /.instagram_area -->
</div><!-- /.sns_inner -->
</div><!-- /.sns_contents -->

<div class="modal_ctrl modal">

    <div class="ctrl_wrapper">
        <div class="select_wapper">
            <div class="option_title">
                <?php esc_html_e('Select categories, tags, etc', 'itmaroon-social-post-sync') ?>
            </div>
            <?php itmar_category_select(); ?>
            <div class="info_btn">
                <img src="<?php echo esc_url(ITMAR_SNS_PLUGIN_URL . '/img/info.png'); ?>" alt="">
                <div class="ballon left">
                    <span>
                        <?php esc_html_e('Select the WordPress categories, tags, and terms you want to set for your post.', 'itmaroon-social-post-sync') ?>
                        <br><?php esc_html_e('Only items that have already been registered can be set.', 'itmaroon-social-post-sync') ?>
                        <br><?php esc_html_e('Please register new ones from the management screen.', 'itmaroon-social-post-sync') ?>
                    </span>
                </div>
            </div><!-- /.info_btn -->
        </div><!-- /.select_wapper -->
        <div class="cmd_btn get_in"><?php esc_html_e('Import selected posts', 'itmaroon-social-post-sync') ?></div><!-- /.cmd_btn -->


    </div><!-- /.ctrl_wrapper -->

</div><!-- /.modal_ctrl -->

<div class="modal_bg">
</div><!-- /.modal_bg -->

<div class="modal_post modal">
    <div class="modal_close">
        <div class="drawer_icon_bars">
            <div class="drawer_icon_bar1"></div>
            <div class="drawer_icon_bar2"></div>
        </div><!-- drawer_icon_bars -->
    </div><!-- /.modal_close -->
    <div class="modalpost_message">
    </div><!-- /.modalpost_message -->
    <div class="modalpost_category">
        <div class="cat_title"><?php esc_html_e('Categories to register', 'itmaroon-social-post-sync') ?></div><!-- /.cat_title -->
    </div><!-- /.modalpost_category -->
    <progress id=progress> </progress>
    <div class="modalpost_count"></div><!-- /.modalpost_count -->
    <div class="post_exec">
        <?php esc_html_e('Import execution', 'itmaroon-social-post-sync') ?>
    </div><!-- /.post_exec -->
</div><!-- /.modal_post -->
</div><!-- /. sns-relate-import-->