jQuery(function ($) {
  const ajaxUrl = sns_relate_ajax_object.ajaxurl;

  nomalSelect_init();

  //ページネーション用カーソル
  let next_after = null;
  //インデックス
  let currentIndex = 0;
  //選択されている対象の投稿タイプ
  const get_post_type = sns_relate_ajax_object.targetPostType;
  //取込のためのストックオブジェクト
  const stok_elm = [];

  //SNSデータの取得リクエスト
  async function get_sns_ajax(wrapper, limit = 9) {
    const sns_type = wrapper.data("sns-type");
    let next_after = wrapper.data("next-after") || null;
    let currentIndex = parseInt(wrapper.data("current-index")) || 0;
    const outputArea = wrapper.find(".sns_output_area");
    // 処理前に Loading 画像を表示
    dispLoading("", wrapper);

    //取込済みSNSのID配列を取得する
    const id_arr = await new Promise((resolve) => {
      $.ajax({
        type: "POST",
        url: ajaxUrl,
        data: {
          action: "itmar_get_ids",
          sns_name: sns_type + "_id",
          post_type: get_post_type,
          nonce: sns_relate_ajax_object.nonce,
        },
        dataType: "json",
      })
        .done(function (response) {
          resolve(response);
        })
        .fail(function (jqXHR) {
          alert("ID取得に失敗しました: " + jqXHR.status);
          resolve([]);
        });
    });

    $.ajax({
      type: "POST",
      url: ajaxUrl,
      data: {
        action: "itmar_get_sns",
        nonce: sns_relate_ajax_object.nonce,
        sns_type: sns_type,
        limit: limit,
        after: next_after,
      },
      dataType: "json",
    })
      .done(function (res) {
        if (res.items && res.items.length > 0) {
          res.items.forEach(function (item, i) {
            const dom = disp_sns_js(item, currentIndex + i, id_arr);
            outputArea.append(dom);
          });

          currentIndex += res.items.length;
          wrapper.data("current-index", currentIndex);
          wrapper.data("next-after", res.next_after || "");

          if (!res.next_after) {
            wrapper.find(".load_more_btn").hide();
          }
        } else {
          wrapper.find(".load_more_btn").hide();
        }
      })
      .always(function () {
        removeLoading("", $(`.${sns_type}_area`));
      });
  }

  //取込チェックのDOM生成関数
  function disp_check(check_id, sns_id_arr) {
    let check_str = `<div class="wp_post_check"><label><input type="checkbox" name="entry_wp"><span></span><p rel="${wp.i18n.__(
      "Import to homepage",
      "itmaroon-social-post-sync"
    )}">${wp.i18n.__(
      "Import to homepage",
      "itmaroon-social-post-sync"
    )}</p></label></div><!-- /.wp_post_check -->`;

    if ($.inArray(check_id, sns_id_arr) != -1) {
      let include_str = `<div class="wp_entry_info">${wp.i18n.__(
        "※Already imported",
        "itmaroon-social-post-sync"
      )}</div>`;
      check_str += include_str;
    }
    let check_elm = $(check_str);
    return check_elm;
  }

  //取得したSNSデータをDOM要素に変換
  function disp_sns_js(elm, index, id_arr) {
    //itemの入れ物を生成
    const obj = elm.sns_obj;
    const sns_kind = elm.sns_kind;
    const item = $('<div class="sns_item" id="' + obj.id + '"/>');

    //チェックボックスと取込済みの有無の表示
    let check_elm = disp_check(obj.id, id_arr);
    item.prepend(check_elm);
    //indexを表示
    item.prepend($('<div class="num">' + (index + 1) + "</div>"));

    // 日付フォーマット
    const formatter = new Intl.DateTimeFormat("ja-JP", {
      timeZone: "Asia/Tokyo",
      year: "numeric",
      month: "2-digit",
      day: "2-digit",
      hour: "2-digit",
      minute: "2-digit",
    });

    const dateStr = formatter.format(new Date(elm.date));
    $(
      '<div class="post_date"><time datetime="' +
        dateStr +
        '">' +
        dateStr +
        "</time></div>"
    ).appendTo(item);

    // メインリンク
    if (obj.permalink) {
      var a_item = $(
        '<a href="' +
          obj.permalink +
          '" target="_blank" rel="noopener noreferrer">'
      );
    } else if (obj.permalink_url) {
      var a_item = $(
        '<a href="' +
          obj.permalink_url +
          '" target="_blank" rel="noopener noreferrer">'
      );
    } else {
      var a_item = $("<div>"); // リンクなしの場合の安全処理
    }

    // Instagram or Facebook本文
    let text_block = "";
    if (sns_kind === "facebook") {
      if (obj.message) {
        text_block +=
          '<div class="post_text">' +
          obj.message.replace(/\n/g, "<br>") +
          "</div>";
      }
      if (obj.story) {
        text_block +=
          '<div class="post_text">' +
          obj.story.replace(/\n/g, "<br>") +
          "</div>";
      }
    } else if (sns_kind === "instagram") {
      if (obj.caption) {
        text_block +=
          '<div class="post_text">' +
          obj.caption.replace(/\n/g, "<br>") +
          "</div>";
      }
    }
    $(text_block).appendTo(a_item);

    // メディア処理
    if (sns_kind === "facebook") {
      if (obj.attachments) {
        let attachment = obj.attachments.data[0];

        if (attachment.subattachments && attachment.subattachments.data) {
          const uniqueId = obj.id.replace(/[^a-zA-Z0-9]/g, ""); // スライダー識別用クラス
          const swiperClass = "swiper-" + uniqueId;

          const swiper_container = $(
            '<div class="post_image"><div class="swiper ' +
              swiperClass +
              '"></div></div>'
          );
          const swiper = swiper_container.find(".swiper");
          const swiper_wrapper = $('<div class="swiper-wrapper"></div>');

          attachment.subattachments.data.forEach(function (media) {
            const slide = $('<div class="swiper-slide" />');
            const media_obj = sns_media_js(media);
            if (media_obj) {
              slide.append($(media_obj));
              swiper_wrapper.append(slide);
            }
          });

          swiper.append(swiper_wrapper);
          swiper.append('<div class="swiper-button-prev"></div>');
          swiper.append('<div class="swiper-button-next"></div>');
          swiper.append('<div class="swiper-pagination"></div>');

          a_item.append(swiper_container);

          // Swiper初期化（共通関数を呼ぶ）
          initSwiper("." + swiperClass);
        } else {
          let media_item = $('<div class="post_image" />');
          let media_obj = sns_media_js(attachment);
          if (media_obj) {
            media_item.append($(media_obj));
            media_item.appendTo(a_item);
          }
        }
      }
    } else if (sns_kind === "instagram") {
      let media_item = $('<div class="post_image" />');

      // 通常の投稿（IMAGE / VIDEO）
      if (obj.media_type === "IMAGE" || obj.media_type === "VIDEO") {
        let media = {
          media_type: obj.media_type,
          media_url: obj.media_url,
          thumbnail_url: obj.thumbnail_url || null,
        };
        let media_obj = sns_media_js(media);
        if (media_obj) {
          media_item.append($(media_obj));
          media_item.appendTo(a_item);
        }
      }

      // カルーセル（複数画像）
      if (
        obj.media_type === "CAROUSEL_ALBUM" &&
        obj.children &&
        obj.children.data
      ) {
        const uniqueId = obj.id.replace(/[^a-zA-Z0-9]/g, "");
        const swiperClass = "swiper-" + uniqueId;

        const swiper_container = $(
          '<div class="post_image"><div class="swiper ' +
            swiperClass +
            '"></div></div>'
        );
        const swiper = swiper_container.find(".swiper");
        const swiper_wrapper = $('<div class="swiper-wrapper"></div>');

        obj.children.data.forEach(function (child) {
          const slide = $('<div class="swiper-slide" />');
          const media_obj = sns_media_js({
            media_type: child.media_type,
            media_url: child.media_url,
          });
          if (media_obj) {
            slide.append($(media_obj));
            swiper_wrapper.append(slide);
          }
        });

        swiper.append(swiper_wrapper);
        swiper.append('<div class="swiper-button-prev"></div>');
        swiper.append('<div class="swiper-button-next"></div>');
        swiper.append('<div class="swiper-pagination"></div>');

        a_item.append(swiper_container);

        // Swiper初期化（共通関数を呼ぶ）
        initSwiper("." + swiperClass);
      }
    }

    item.append(a_item);

    // フッター：いいね数
    if (sns_kind === "facebook") {
      let item_footer = $('<div class="snsItem_footer"/>');
      let fav = $(
        '<div class="favorite item"><div class="mark"></div><div class="count">' +
          elm.favarit +
          "</div></div>"
      );
      item_footer.append(fav);
      item.append(item_footer);
    } else if (sns_kind === "instagram") {
      let item_footer = $('<div class="snsItem_footer"/>');

      if (typeof obj.like_count !== "undefined") {
        let fav = $(
          '<div class="favorite item"><div class="mark"></div><div class="count">' +
            obj.like_count +
            "</div></div>"
        );
        item_footer.append(fav);
      }

      item.append(item_footer);
    }

    //elmをストック
    stok_elm.push(elm);
    //変換したDOMを返す
    return item;
  }

  //SNSデータ内メディアの処理
  function sns_media_js(media) {
    let elm_media = "";

    // Instagram形式
    if (media.media_type && media.media_url) {
      if (media.media_type === "IMAGE") {
        elm_media = '<img src="' + media.media_url + '" loading="lazy">';
      } else if (media.media_type === "VIDEO") {
        const thumb = media.thumbnail_url || "";
        elm_media =
          '<video controls preload="metadata"><source src="' +
          media.media_url +
          '"></video>';
      }
      return elm_media;
    }

    // Facebook形式
    switch (media.type) {
      case "photo":
      case "cover_photo":
      case "profile_media":
        elm_media =
          '<img src="' +
          media.media.image.src +
          '" width="' +
          media.media.image.width +
          '" height="' +
          media.media.image.height +
          '">';
        break;

      case "album":
        if (media.subattachments && media.subattachments.data) {
          media.subattachments.data.forEach((sub) => {
            elm_media +=
              '<img src="' +
              sub.media.image.src +
              '" width="' +
              sub.media.image.width +
              '" height="' +
              sub.media.image.height +
              '">';
          });
        }
        break;

      case "video_inline":
      case "video_autoplay":
        elm_media =
          '<video controls preload="metadata"><source src="' +
          media.media.source +
          '"></video>';
        break;

      case "share":
        if (media.url) {
          elm_media = '<div class="ogp_area">';
          elm_media +=
            '<a href="' +
            media.url +
            '" target="_blank" rel="noopener noreferrer">';

          if (media.media && media.media.image) {
            elm_media += '<div class="ogp_image"><div class="img_frame">';
            elm_media +=
              '<img src="' +
              media.media.image.src +
              '" width="' +
              media.media.image.width +
              '" height="' +
              media.media.image.height +
              '">';
            elm_media += "</div></div>";
          }

          if (media.title) {
            elm_media += '<div class="ogp_title">' + media.title + "</div>";
          }
          if (media.description) {
            elm_media +=
              '<div class="ogp_description">' + media.description + "</div>";
          }

          elm_media += "</a></div>";
        }
        break;

      case "native_templates":
      default:
        elm_media = null;
        break;
    }

    return elm_media;
  }

  //最初の取込
  get_sns_ajax($('.sns_wrapper[data-sns-type="facebook"]'), 9);
  get_sns_ajax($('.sns_wrapper[data-sns-type="instagram"]'), 9);

  //取り込みボタン
  $(".cmd_btn").click(function () {
    //$('.modal_ctrl').fadeOut();
    //選択されたSNS
    let sel_sns = $("[name=entry_wp]:checked");
    let sel_count = sel_sns.length;
    if (sel_count == 0) {
      ctrlMsg(
        wp.i18n.__(
          "No articles have been selected to import.",
          "itmaroon-social-post-sync"
        )
      );
      $(".modal_bg").fadeOut();
      return;
    }
    //カテゴリーの取得

    let term_list = $("<ul />");

    $("#id_category option:selected").each(function () {
      term_list.append(
        $(
          '<li class="' +
            $(this).attr("class") +
            '" data-value="' +
            $(this).val() +
            '"/>'
        ).html($(this).text())
      );
    });

    let post_count =
      "<span>" +
      sel_count +
      wp.i18n.__("subject", "itmaroon-social-post-sync") +
      "</span>";
    let post_text = `${wp.i18n.__(
      "The article is selected.",
      "itmaroon-social-post-sync"
    )}<br class="sp_br">${wp.i18n.__(
      "Click the button below to be taken to the site.",
      "itmaroon-social-post-sync"
    )}`;
    //一旦クリア
    $(".modalpost_message").empty();
    $(".modalpost_category >ul").remove();
    //データ追加
    $(".modalpost_message").append(post_count);
    $(".modalpost_message").append(post_text);
    if ($("#id_category option:selected").length == 0) {
      $(".modalpost_category").addClass("empty");
    } else {
      $(".modalpost_category").removeClass("empty");
      $(".modalpost_category").append(term_list);
    }

    $("#progress").attr("max", sel_count);
    $("#progress").attr("value", 0);

    $(".modal_bg").fadeIn();
    $(".modal_post").fadeIn();
    $(".modal_ctrl").fadeOut();
  });
  //実行ボタン
  $(".post_exec").click(function () {
    if ($(this).hasClass("ignore")) return; //既に押していれば処理しない
    else $(this).addClass("ignore"); //２回押せないようにする。
    //returnクラス編集者メニューに戻る
    if ($(this).hasClass("return")) {
      window.location.href =
        sns_relate_ajax_object.redirectUrl +
        "?page=itmaroon-social-post-sync-post-list";
      return;
    }
    //プログレスバーを出す
    $("#progress").addClass("visible");

    //選択されたSNSオブジェクトの集積、総数計算
    let sel_sns = $("[name=entry_wp]:checked");
    let sel_count = sel_sns.length;

    $(".modalpost_count").text(
      "0 /" +
        sel_count +
        wp.i18n.__(" Items processed", "itmaroon-social-post-sync")
    );
    $(".modalpost_count").addClass("pre");

    let entry_count = sel_count; //エントリするカウント

    $.map(sel_sns, async function (element, index) {
      //選択されたDOM要素のid
      let item_id = $(element).parent().parent().parent().attr("id");
      //ストックされたSNSエレメントから抽出
      const matchedItem = stok_elm.find((el) => el.sns_obj.id === item_id);
      //SNSオブジェクトからWPの基本データを抜き出す
      const sns_obj = matchedItem.sns_obj;
      const sns_type = matchedItem.sns_kind; // 'facebook' または 'instagram'

      //タイトルと抜粋（Facebookはmessage,Instagramは caption を使用）
      let rawText = sns_obj.message || sns_obj.caption || "";
      rawText = rawText.trim();

      let title = "";
      let excerpt = "";

      // 1. まず【】付きかどうかを判定して title / excerpt を分割
      //    [\s\S]* にすることで改行を含めて全文をキャプチャします
      const titleMatch = rawText.match(/^【(.+?)】\s*([\s\S]*)$/u);

      if (titleMatch) {
        // 【】の中身
        title = titleMatch[1].trim();
        // それ以外全部（改行含めてOK）
        excerpt = titleMatch[2].trim();
      } else {
        // 2. 【】がない場合は従来どおり「1行目=title, 2行目以降=excerpt」
        const lines = rawText.split(/\r?\n/);
        title = (lines[0] || "").trim();
        excerpt = lines.slice(1).join("\n").trim();
      }
      //基本データのセット
      const post_data = {
        title: title,
        excerpt: excerpt,
        post_type: sns_relate_ajax_object.targetPostType,
        date: sns_obj.timestamp || sns_obj.created_time,
        post_status: "publish",
        terms: tax_map(), // 選択されたカテゴリー・タグ・カスタムタクソノミーを taxonomy => [slug, ...] の形式で取得
        custom_fields: {
          [`${sns_type}_id`]: item_id,
        },
      };

      //FormData生成
      const formData = new FormData();
      formData.append("action", "itmar_post_ajax");
      formData.append("nonce", sns_relate_ajax_object.nonce);

      // メディア処理開始
      let imageCount = 0;

      // Instagram：アイキャッチ
      if (sns_type === "instagram") {
        const mediaType = sns_obj.media_type;

        // 初期化
        let featuredUrl = null;
        let galleryUrls = [];

        // 単体画像/動画投稿
        if (mediaType === "IMAGE" || mediaType === "VIDEO") {
          featuredUrl = sns_obj.media_url;

          // 画像であればアイキャッチにも使う
          if (mediaType === "IMAGE") {
            const blob = await fetch(featuredUrl).then((res) => res.blob());
            const path = new URL(featuredUrl).pathname;
            const name =
              path.split("/").pop().split("?")[0] || "insta_feature.jpg";

            // featured_image に設定
            const featuredFile = new File([blob], name, {
              type: blob.type,
            });
            formData.append("featured_image", featuredFile);
            post_data.thumbnail_path = path;

            // ACF用にも media_files[0] に送る（重要）
            //formData.append("media_files[0]", featuredFile);
          } else {
            // VIDEO の場合は featured_image に設定しない。media_files[] のみで送信
            const blob = await fetch(featuredUrl).then((res) => res.blob());
            const path = new URL(featuredUrl).pathname;
            const name =
              path.split("/").pop().split("?")[0] || "insta_video.mp4";
            const file = new File([blob], name, {
              type: blob.type,
            });
            formData.append("media_files[0]", file);
          }
        }

        // 複数画像投稿（CAROUSEL）
        else if (mediaType === "CAROUSEL_ALBUM" && sns_obj.children?.data) {
          const children = sns_obj.children.data;

          for (let i = 0; i < children.length; i++) {
            const url = children[i].media_url;
            const blob = await fetch(url).then((res) => res.blob());
            const path = new URL(url).pathname;
            const name =
              path.split("/").pop().split("?")[0] || `insta_carousel_${i}.jpg`;
            const file = new File([blob], name, {
              type: blob.type,
            });

            // 1枚目 → アイキャッチ
            if (i === 0) {
              formData.append("featured_image", file);
              post_data.thumbnail_path = path;
            } else {
              // media_files[] に他のメディア追加（1枚目除く）
              formData.append(`media_files[${i - 1}]`, file);
            }
          }
        }
      }

      // Facebook：アイキャッチ
      if (sns_type === "facebook" && sns_obj.full_picture) {
        const url = sns_obj.full_picture;
        const blob = await fetch(url).then((res) => res.blob());
        const path = new URL(url).pathname;
        const name =
          path.split("/").pop().split("?")[0] || `fb_${imageCount++}.jpg`;

        const file = new File([blob], name, {
          type: blob.type,
        });
        formData.append("featured_image", file);
        post_data.thumbnail_path = path;
      }

      // Facebook：ACF画像（動画の場合は動画取得）
      if (sns_type === "facebook" && sns_obj.attachments?.data?.[0]) {
        const images = sns_obj.attachments.data[0]?.subattachments?.data
          ? sns_obj.attachments.data[0].subattachments.data
          : sns_obj.attachments.data;
        for (let i = 1; i < images.length; i++) {
          //一枚目は除く
          const url =
            images[i].type.startsWith("video") && images[i].media?.source
              ? images[i].media.source
              : images[i].media?.image?.src;

          if (url) {
            const blob = await fetch(url).then((res) => res.blob());
            const path = new URL(url).pathname;
            const name =
              path.split("/").pop().split("?")[0] || `fb_${imageCount++}.jpg`;
            const file = new File([blob], name, {
              type: blob.type,
            });
            formData.append(`media_files[${i - 1}]`, file);
          }
        }
      }
      //メディア処理でアイキャッチ画像の情報を基本データに入れてから送信
      formData.append("post_data", JSON.stringify(post_data)); // JSON化して送信

      // サーバーに送信
      try {
        const response = await fetch(ajaxUrl, {
          method: "POST",
          body: formData,
        });

        if (!response.ok) {
          throw new Error(`HTTP error! status: ${response.status}`);
        }
        const data = await response.json(); // ✅ **PHP からの戻り値を受け取る**
        entry_count--; //処理数をデクリメント
        $("#progress").attr("value", sel_count - entry_count);

        if (entry_count === 0) {
          $(".modalpost_count").text(
            wp.i18n.__("Processing complete", "itmaroon-social-post-sync")
          );
          $(".modalpost_count").removeClass("pre");
          $(".modalpost_count").addClass("conp");

          $(".post_exec").text(
            wp.i18n.__(
              "View all eligible posts...",
              "itmaroon-social-post-sync"
            )
          );
          $(".post_exec").addClass("return");
          $(".post_exec").removeClass("ignore");
        } else {
          $(".modalpost_count").text(
            sel_count -
              entry_count +
              " /" +
              sel_count +
              wp.i18n.__("Items processed", "itmaroon-social-post-sync")
          );
        }
      } catch (error) {
        console.error("Fetch error:", error);
      }
    });
  });
  //　もっと見る処理
  $(".load_more_btn").click(function () {
    const wrapper = $(this).closest(".sns_wrapper");
    get_sns_ajax(wrapper, 9);
  });
});
