jQuery(function ($) {
  const ajaxUrl = sns_relate_ajax_object.ajaxurl;
  //編集画面スクリプト
  //カスタムフィールド
  let field_arr = sns_edit_option.field_arr;

  //投稿ID
  const post_id = sns_edit_option.editID;

  //更新フラグ
  let modify_flg = false;
  //保存フラグ
  let saved_flg = false;
  //現在のステータス
  let post_status = sns_edit_option.post_status;

  /****メディアの表示******/
  //クローズボタン
  let btn_close = $(
    '<div class="img_close "><div class="drawer_icon_bars"><div class="drawer_icon_bar1"></div><div class="drawer_icon_bar2"></div></div></div>'
  );
  //snsセレクタ
  let sns_selecter = $(
    `<select name="target_sns" class="radio" multiple ><option class="sns_sel" value="Twitter" selected>${sns_relate_ajax_object.plugin_uri}img/x-black.png</option><option class="sns_sel" value="Facebook" selected>${sns_relate_ajax_object.plugin_uri}img/facebook_b.png</option><option class="sns_sel" value="Instagram" selected>${sns_relate_ajax_object.plugin_uri}img/instagram_logo.png</option></select>`
  );

  //データ保存関連変数初期化
  let ajax_count = 0; //Ajax呼び出しのカウンター
  let save_cansel_flg = false; //sns投稿のフラグ
  let post_sns = []; //投稿対象sns
  let tw_text = ""; //Twitterのテキスト
  let fb_text = ""; //facebookのテキスト
  let ig_text = ""; //Instagramのテキスト
  let arr_urlimg = []; //画像の配列
  let arr_urlvideo = []; //動画の配列
  let arr_img_info = []; //選択されたメディア
  let max_char = 140; //Twitterの最大投稿文字数

  function image_insert(images) {
    images.each(function (file, index) {
      let sel_id = file.toJSON().id; //IDを取得
      let width = file.toJSON().width;
      let height = file.toJSON().height;
      //イメージエレメントを生成
      let sel_img;
      if (!file.get("type") === "video") {
        sel_img = $('<img src="' + file.toJSON().url + '" alt="">');
      } else {
        sel_img = $(
          '<video autoplay loop muted  src="' +
            file.toJSON().url +
            '" playsinline></video>'
        );
      }
      sel_img.attr("width", width);
      sel_img.attr("height", height);
      $(".input_image_erea .img_frame").each(function (index) {
        if ($(this).hasClass("fill") == false) {
          set_insert_img($(this), sel_id, sel_img, index);
          return false;
        }
      });
    });
  }

  function set_insert_img(media_item, sel_id, sel_img, index) {
    const media_field_name =
      index === 0 && sel_img.is("img") ? "featured" : "gallery";
    media_item
      .addClass("fill")
      .attr("data-field", media_field_name)
      .attr("data-val", sel_id)
      .html(sel_img);
    media_item.parents(".media_item").removeClass("empty");

    //クローズボタン（クローンを作る）
    let btn_clone = btn_close.clone();
    media_item.parent().append(btn_clone);
    //セレクタ（クローンを作る）
    let select_clone = sns_selecter.clone();
    media_item.parent().append(select_clone);
    radioSelect_init(select_clone);
  }

  //イメージ領域の初期化
  function set_image_init(media_fields) {
    media_fields.forEach(function (field_name, index) {
      let img_id = field_arr[field_name];

      if (img_id != undefined && img_id != "" && parseInt(img_id) != 0) {
        //SNSセレクタの取得
        let sel_arr = [];
        let target_sns = `${field_name}_target`;
        let sel_elm = field_arr[target_sns];
        if (sel_elm != undefined) {
          sel_arr = sel_elm;
        }

        let insert_target = $(".input_image_erea .img_frame").eq(index); //イメージの挿入先;

        //クローズボタン
        let btn_clone = btn_close.clone();
        insert_target.parent().append(btn_clone);
        //snsセレクタ
        let select_clone = sns_selecter.clone();
        if (sel_arr.length) {
          //セレクト指定がある場合
          select_clone.val(sel_arr); //データセット
        }

        insert_target.parent().append(select_clone);
        radioSelect_init(select_clone);
      }
    });
  }
  //SNSへのログイン情報を投稿対象SNSセレクトに付加
  function set_sns_info(snsPost_select) {
    let selBtn_list = snsPost_select.parent().parent().find(".radio_btn");
    $.map(selBtn_list, function (element, index) {
      switch ($(element).data("value")) {
        case "Twitter":
          disp_element = $(sns_relate_ajax_object.snippets["Twitter"]);
          break;
        case "Facebook":
          disp_element = $(sns_relate_ajax_object.snippets["Facebook"]);
          break;
        case "Instagram":
          disp_element = $(sns_relate_ajax_object.snippets["Instagram"]);
          break;
      }

      $(element).append(disp_element);
      //付加した要素がエラーを含んでいるとき
      if ($(element).find(".user_info").hasClass("error")) {
      }
    });
  }

  //初期設定
  $(document).ready(function () {
    //SNSの選択要素
    let snsPost_select = $(".snsSel_wrapper select");

    const media_fields = sns_edit_option.media_fields;

    //Wordpress投稿情報の反映
    if (post_id != 0) {
      //カテゴリセレクトボックスのオプション
      let category_option = $("select#id_category").find("option");
      //タームタグの収集
      let term_arr = sns_edit_option.term_arr;

      $.each(term_arr, function (index, value) {
        let cat_item = value;

        category_option.each(function () {
          //セレクトボックスのオプション値と一致するものを探す。
          if (
            $(this).hasClass(cat_item["kind"]) &&
            $(this).val() === cat_item["slug"]
          ) {
            $(this).prop("selected", true);
          }
        });
      });

      //セレクトボックスの初期化
      nomalSelect_init();

      //field_arrに登録
      field_arr["category"] = term_arr;

      //画像エリアの初期化
      set_image_init(media_fields);

      //投稿対象SNSセレクトの初期化
      let sel_elm = field_arr["post_sns"];
      if (sel_elm != undefined) {
        snsPost_select.val(sel_elm);
      }

      //入力文字数、Twitter上限のセット
      $(".char_count .input_count").text(
        $('textarea[name="content"]').val().length
      );
      $(".char_count .tw_limit").text(max_char - $("#title").val().length - 3);
    } else {
      //セレクトボックスの初期化
      nomalSelect_init();
    }

    //テキストボックスの初期化
    textbox_init();

    //投稿対象SNSセレクトの初期化
    radioSelect_init(snsPost_select);
    set_sns_info(snsPost_select);
    //ラジオボタンの初期化
    radio_init();
  });

  // 離脱警告（変更あり・未保存時）
  window.addEventListener("beforeunload", function (event) {
    if (modify_flg && !saved_flg) {
      event.preventDefault();
      event.returnValue = "";
    }
  });

  // 本当に離脱されるときに削除実行
  window.addEventListener("unload", function () {
    if (modify_flg && !saved_flg) {
      const data = new FormData();
      data.append("action", "itmar_del_pending");
      data.append("del_id", sns_edit_option.editID);
      data.append("nonce", sns_relate_ajax_object.nonce);

      navigator.sendBeacon(ajaxUrl, data);
    } else if (!modify_flg && !saved_flg) {
      // 変更なし・未保存でも削除（←このルールなら残してもいいかも）
      const data = new FormData();
      data.append("action", "itmar_del_pending");
      data.append("del_id", sns_edit_option.editID);
      data.append("nonce", sns_relate_ajax_object.nonce);

      navigator.sendBeacon(ajaxUrl, data);
    }
  });

  //入力項目更新時
  $(document).on(
    "change",
    "input,textarea,option,.img_close,.media_item",
    function () {
      modify_flg = true;
    }
  );

  //Wordpressアップローダーからの入力
  $(".media_item").on("click", ".img_frame", function () {
    if ($(this).hasClass("fill")) {
      //メディア表示
      let media_elm = $(this).find("img, video").clone();
      $(".modal_media .media_frame").html(media_elm);
      $(".modal_media .media_frame").find("video").attr("controls", "controls"); //video要素にはコントロールを付ける
      //アスペクト比によるクラス分け
      let width = media_elm.attr("width");
      let height = media_elm.attr("height");

      if (height / width > 1) {
        $(".modal_media").addClass("port");
        $(".modal_media").removeClass("land");
      } else {
        $(".modal_media").addClass("land");
        $(".modal_media").removeClass("port");
      }
      //モーダル表示
      $(".modal_bg").addClass("white").fadeIn();
      $(".modal_media").fadeIn();
    } else {
      //changeイベントの登録
      $(this).trigger("change");
      //メディア選択
      let loader_arr = {
        title: wp.i18n.__("Media Selection", "itmaroon-social-post-sync"),
        library: {
          type: "image,video",
        },
        button: {
          text: wp.i18n.__("Select Media", "itmaroon-social-post-sync"),
        },
        multiple: true,
      };
      let custom_uploader = wp.media(loader_arr);
      custom_uploader.open();
      let media_area = $(this).parent();
      //選択したファイル名を返す
      custom_uploader.on("select", function () {
        let images = custom_uploader.state().get("selection");
        image_insert(images);
      });
    }
  });

  //クローズボタンを押したとき
  $(document).on("click", ".img_close", function (e) {
    //changeイベントの登録
    $(this).trigger("change");

    let media_area = $(this).parents(".input_image").parent();
    let media_list = $(this).parents(".input_image").find(".media_wrapper");
    //押されたボタンについている画像枠の番号
    let close_num = media_list.index($(this).parent());
    let count = close_num;
    while (count < media_list.length) {
      if (media_list.eq(count).find(".img_frame").hasClass("fill")) {
        //画像があるとき

        let move_frame = media_list.eq(count).html(); //アニメーション用フレーム
        let move_wrapper = $('<div class="move_wrapper" />');
        if (count == close_num) {
          move_wrapper.addClass("target"); //消去対象の画像にクラスを付加
        }
        $(move_frame).appendTo(move_wrapper);

        media_list.eq(count).parent().append(move_wrapper);
        media_list.eq(count).parent().find(".media_wrapper").addClass("hide"); //元の画像を隠す

        setTimeout(function () {
          //処理対象のメディア番号
          let cur_element = move_wrapper.parent().find(".media_wrapper");
          let num = media_list.index(cur_element);
          //データの確保
          let media_id = cur_element.find(".img_frame").data("val");
          let acf_field = cur_element.find(".img_frame").data("field");
          let sel_val = cur_element.find("select").val();

          move_wrapper.addClass("move");
          if (
            !move_wrapper
              .parent()
              .next()
              .find(".media_wrapper .img_frame")
              .hasClass("fill")
          ) {
            //次の要素に画像がないとき

            let url = sns_relate_ajax_object.plugin_uri;

            let num_element = $(
              '<div class="img_frame" data-field="' +
                acf_field +
                '"><img src="' +
                url +
                '/img/placeholder.png" alt=""></div><!-- /.img_frame -->'
            );
            cur_element.html(num_element).removeClass("hide");
            cur_element.parents(".media_item").addClass("empty");
            cur_element
              .find(".img_frame")
              .data("field", "empty")
              .attr("data-field", "empty");
          }
          if (move_wrapper.hasClass("target")) {
            move_wrapper.slideUp(1000, function () {
              $(this).remove();
            }); //消去対象の要素は消去
          } else {
            //その他の要素は場所移動
            let source_pos = move_wrapper.parent().position();
            let dest_pos = move_wrapper.parent().prev().position();

            let move_x = dest_pos.left - source_pos.left;
            let move_y = dest_pos.top - source_pos.top;
            move_wrapper.animate(
              {
                top: move_y,
                left: move_x,
              },
              {
                duration: 1000,
                complete: function () {
                  $(this).removeClass("move"); //移動モードを消す
                  const $wrapper = $(this)
                    .parent()
                    .prev()
                    .find(".media_wrapper");
                  //元のフィールド情報を確保
                  const originalField = $wrapper
                    .find(".img_frame")
                    .attr("data-field");
                  //データの差し替え
                  $wrapper.html($(this).html()).removeClass("hide");
                  // 差し替えた中の img_frame に元の data-field を戻す
                  $wrapper.find(".img_frame").attr("data-field", originalField);
                  //SNSのセレクト情報を差し替え
                  $(this)
                    .parent()
                    .prev()
                    .find(".media_wrapper")
                    .find("select")
                    .val(sel_val); //選択されていた値を入れる

                  $(this).fadeOut(600, function () {
                    $(this).remove(); //アニメーション用の要素は削除
                  });
                },
              }
            );
          }
        }, 300);
      }
      count++;
    }
  });

  //カテゴリーセレクトの変更時
  $(document).on("change", "select#id_category", function () {
    let json_arr = [];

    $(this)
      .find("option:selected")
      .each(function () {
        let elm = {
          slug: $(this).val(),
          kind: $(this).attr("class"),
        };
        json_arr.push(elm);
      });

    field_arr["category"] = json_arr;
  });

  //本文の選択
  let tw_start = 0;
  let tw_end = 0;
  const objTextArea = document.getElementById("id_comment");
  if (objTextArea !== null) {
    document.addEventListener("selectionchange", () => {
      tw_start = objTextArea.selectionStart;
      tw_end = objTextArea.selectionEnd;
      //let selection=window.getSelection();
      $(".ballon.twArea").find("p").remove();
      //タイトルの文字数
      let count_title = $("#title").val().length + 3; //【】と改行を加える
      let char_count = tw_end - tw_start;

      $(".ballon.twArea > div").prepend(
        `<p>${wp.i18n.__(
          "Number of selected characters:",
          "itmaroon-social-post-sync"
        )}${char_count}${wp.i18n.__(
          "characters",
          "itmaroon-social-post-sync"
        )}</p>`
      );
      if (char_count + count_title > max_char - 3) {
        $(".tw_icon").removeClass("select");
        $(".ballon.twArea > div").prepend(
          `<p class="over">${
            char_count + count_title - (max_char - 3)
          }${wp.i18n.__("Character over", "itmaroon-social-post-sync")}</p>`
        );
      } else {
        $(".tw_icon").addClass("select");
      }
      //選択範囲がないとき
      if (
        char_count == 0 &&
        $(".tw_check input[type=checkbox]").prop("checked")
      ) {
        field_arr["post_comment_tw_start"] = 0;
        field_arr["post_comment_tw_end"] = 0;
      }
    });
  }

  //選択の終了時
  if ($("#id_comment").length) {
    $("#id_comment").on("select", function () {
      console.log("select finish!!!");
      if ($(".tw_check input[type=checkbox]").prop("checked")) {
        //タイトルの文字数
        let count_title = $("#title").val().length + 3; //【】と改行を加える
        //本文の選択範囲
        let start = $("#id_comment")[0].selectionStart;
        let end = $("#id_comment")[0].selectionEnd;
        field_arr["post_comment_tw_start"] = start;
        if (end - start + count_title <= max_char - 3) {
          //
          field_arr["post_comment_tw_end"] = end;
          $("#id_comment").focus();
          $("#id_comment")[0].setSelectionRange(start, end);
        } else {
          ctrlMsg(
            wp.i18n.__(
              "Failed to set posting scope.",
              "itmaroon-social-post-sync"
            )
          );
        }
      }
    });

    //Twitter投稿範囲チェックボックスクリック時
    $(".tw_check input[type=checkbox]").change(function () {
      if ($(this).prop("checked")) {
        //ツールチップを出す
        $(".ballon.twArea").addClass("display");

        let start = field_arr["post_comment_tw_start"];
        let end = field_arr["post_comment_tw_end"];
        $("#id_comment").focus();
        $("#id_comment")[0].setSelectionRange(start, end);

        //タイトルの文字数
        let count_title = $("#title").val().length + 3; //【】と改行を加える
        $(".ballon.twArea > div").prepend(
          `<p>${wp.i18n.__(
            "Number of selected characters:",
            "itmaroon-social-post-sync"
          )}${end - start}${wp.i18n.__(
            "characters",
            "itmaroon-social-post-sync"
          )}</p>`
        );
        //アイコンのOK表示
        if (end - start + count_title <= max_char - 3) {
          $(".tw_icon").addClass("select");
        }
      } else {
        //$("#id_comment").focus();
        //ツールチップを消す
        $(".ballon.twArea").find("p").remove();
        $(".ballon.twArea").removeClass("display");
      }
    });
  }

  //入力画面の切替
  let fieldset_objs = $("fieldset");
  let fieldset_inx = 0;
  let current_fs, next_fs, previous_fs; //fieldsets
  let left, opacity, scale; //fieldset properties which we will animate
  let animating; //flag to prevent quick multi-click glitches
  $(".btn_next").click(function () {
    if (animating) return false;
    animating = true;

    //ページのセット
    current_fs = fieldset_objs.eq(fieldset_inx);
    next_fs = fieldset_objs.eq(fieldset_inx + 1);
    //インデックスインクリメント
    fieldset_inx++;

    //ボタンの表示
    if (fieldset_inx == 0) {
      $(".btn_next").addClass("appear");
      $(".btn_prev").removeClass("appear");
    } else if (fieldset_inx == fieldset_objs.length - 1) {
      $(".btn_next").removeClass("appear");
      $(".btn_prev").addClass("appear");
    } else {
      $(".btn_next").addClass("appear");
      $(".btn_prev").addClass("appear");
    }

    //activate next step on progressbar using the index of next_fs
    $("#progressbar li").eq($("fieldset").index(next_fs)).addClass("active");

    //show the next fieldset
    next_fs.show();
    next_fs.css({
      position: "absolute",
    });
    //プログレスバーの高さ
    let progress_height = $("#progressbar").outerHeight(true);
    //hide the current fieldset with style
    current_fs.animate(
      {
        opacity: 0,
      },
      {
        step: function (now, mx) {
          //as the opacity of current_fs reduces to 0 - stored in "now"
          //1. scale current_fs down to 80%
          scale = 1 - (1 - now) * 0.2;
          //2. bring next_fs from the right(50%)
          left = now * 50 + "%";
          //3. increase opacity of next_fs to 1 as it moves in
          opacity = 1 - now;
          current_fs.css({
            transform: "scale(" + scale + ")",
          });
          next_fs.css({
            top: progress_height,
            left: left,
            opacity: opacity,
          });
        },
        duration: 800,
        complete: function () {
          current_fs.hide();
          animating = false;
          next_fs.css({
            position: "static",
          });
        },
        //this comes from the custom easing plugin
        easing: "easeInOutBack",
      }
    );
  });

  $(".btn_prev").click(function () {
    if (animating) return false;
    animating = true;
    //ページのセット
    current_fs = fieldset_objs.eq(fieldset_inx);
    previous_fs = fieldset_objs.eq(fieldset_inx - 1);
    //インデックスデクリメント
    fieldset_inx--;

    //ボタンの表示
    if (fieldset_inx == 0) {
      $(".btn_next").addClass("appear");
      $(".btn_prev").removeClass("appear");
    } else if (fieldset_inx == fieldset_objs.length - 1) {
      $(".btn_next").removeClass("appear");
      $(".btn_prev").addClass("appear");
    } else {
      $(".btn_next").addClass("appear");
      $(".btn_prev").addClass("appear");
    }

    //de-activate current step on progressbar
    $("#progressbar li")
      .eq($("fieldset").index(current_fs))
      .removeClass("active");

    //show the previous fieldset
    previous_fs.show();
    current_fs.css({
      position: "absolute",
    });
    //プログレスバーの高さ
    let progress_height = $("#progressbar").outerHeight(true);
    //hide the current fieldset with style
    current_fs.animate(
      {
        opacity: 0,
      },
      {
        step: function (now, mx) {
          //as the opacity of current_fs reduces to 0 - stored in "now"
          //1. scale previous_fs from 80% to 100%
          scale = 0.8 + (1 - now) * 0.2;
          //2. take current_fs to the right(50%) - from 0%
          left = (1 - now) * 50 + "%";
          //3. increase opacity of previous_fs to 1 as it moves in
          opacity = 1 - now;
          current_fs.css({
            top: progress_height,
            left: left,
          });
          previous_fs.css({
            transform: "scale(" + scale + ")",
            opacity: opacity,
          });
        },
        duration: 800,
        complete: function () {
          current_fs.hide();
          animating = false;
          previous_fs.css({
            position: "static",
          });
        },
        //this comes from the custom easing plugin
        easing: "easeInOutBack",
      }
    );
  });

  //削除処理
  $(".sns_delete").click(function () {
    $(".modal_ctrl").fadeOut();
    //初期化
    let del_count = 0;
    $(".del_check").each(function () {
      let key_id = $(this).attr("rel");

      if (field_arr[key_id] === "" || field_arr[key_id] === undefined) {
        $(this).find(".info").text("連携して投稿したSNSの情報がありません。");
        $(this).addClass("ignore");
        $(this).find("input").prop("disabled", true);
      } else {
        let status = field_arr[key_id].split(",");
        if (
          status[0] === "ERROR" ||
          status[0] === "RESERVE" ||
          status[0] === "WAIT"
        ) {
          $(this).find(".info").text("連携して投稿したSNSの情報がありません。");
          $(this).addClass("ignore");
          $(this).find("input").prop("disabled", true);
        } else {
          $(this)
            .find(".info")
            .text(
              "削除する場合は左のチェックボックスにチェックを入れてください。"
            );
          del_count++; //カウンターをインクリメント
        }
      }
    });
    if (del_count == 0) {
      //削除できるSNSがない
      $(".del_msg").text("ホームページの投稿だけが削除されます。");
    }
    //ダイアログ表示
    $(".modal_bg").fadeIn();
    $(".modal_delete").fadeIn();
  });

  $("#btn_delete").click(function () {
    if ($(this).hasClass("ignore")) {
      return; //既に押していれば処理しない
    } else {
      $(this).addClass("ignore"); //２回押せないようにする。
      $(".modal_delete .modal_close").addClass("ignore"); //クローズボタンも押せないようにする
      $(".modal_bg").addClass("ignore"); //背景のクリックも無効にする
    }
    //returnクラスがついていたら一覧に戻る
    if ($(this).hasClass("return")) {
      window.location.href =
        sns_relate_ajax_object.redirectUrl +
        "?page=itmaroon-social-post-sync-post-list";
      return;
    }

    let del_count = 0; //処理数
    let del_id = post_id;
    $.map($(".del_check"), function (element, index) {
      if ($(element).find('[name="del_sns"]').prop("checked")) {
        del_count++; //処理数をインクリメント
        $(element).find(".info").text("処理中...");
        $(element).addClass("pre");
        $.ajax({
          type: "POST",
          url: ajaxUrl,
          data: {
            action: "itmar_del_sns",
            del_id: del_id,
            del_sns: $(element).attr("rel"),
            nonce: sns_relate_ajax_object.nonce,
          },
        })
          .done(function (data) {
            const arr = data.split(",");
            $(element).find(".info").text(arr[1]);
            $(element).removeClass("pre");
            if (arr[0] === "ERROR") {
              $(element).addClass("error");
            } else {
              $(element).addClass("conp");
            }
          })
          .fail(function (XMLHttpRequest, textStatus, errorThrown) {
            console.log(XMLHttpRequest.status);
            console.log(textStatus);
            console.log(errorThrown.message);
          })
          .always(function () {
            del_count--; //処理数をデクリメント
            if (del_count === 0) {
              wp_delete();
            }
          });
      }
    });
    //SNS削除対象がなければ本体削除のみ
    if (del_count === 0) {
      wp_delete();
    }
  });

  function wp_delete() {
    let del_id = post_id;
    $.ajax({
      type: "POST",
      url: ajaxUrl,
      data: {
        action: "itmar_del_sns",
        del_id: del_id,
        del_sns: "wp_id",
        nonce: sns_relate_ajax_object.nonce,
      },
    })
      .done(function (data) {
        modify_flg = false; //更新フラグはおろす
        ctrlMsg("処理が終了しました。");
        const arr = data.split(",");
        if (arr[0] === "ERROR") {
          alert(data);
        }
      })
      .fail(function (XMLHttpRequest, textStatus, errorThrown) {
        console.log(XMLHttpRequest.status);
        console.log(textStatus);
        console.log(errorThrown.message);
      })
      .always(function () {
        $("#btn_delete").text("一覧に戻る");
        $("#btn_delete").addClass("return");
        $("#btn_delete").removeClass("ignore");
      });
  }

  //確認ダイアログ表示までの処理
  $(".sns_exec").click(function (event) {
    //タイトルが入っていない場合は戻す
    if ($("#title").val().length == 0) {
      ctrlMsg("タイトルは必須項目です。");
      return;
    }
    //コントロールモーダルを消す
    $(".modal_ctrl").fadeOut();

    //予約投稿の場合は公開させない
    $(".draft_radio .reserve_date").remove(); //予約投稿日一旦削除
    let dlg_date = new Date($("#postdate_id").val());
    let now_date = new Date();
    if (post_status === "pending" && now_date < dlg_date) {
      $(".draft_radio input:radio[name=post_radio]:eq(1)").prop(
        "checked",
        true
      );
      $(".draft_radio input:radio[name=post_radio]:eq(0)").prop(
        "disabled",
        true
      );
      $(".draft_radio input:radio[name=post_radio]:eq(0)")
        .parent()
        .addClass("ignore");
      $(".draft_radio").append(
        '<div class="reserve_date">' +
          $("#postdate_id").val() +
          "予約投稿</div>"
      );
    } else {
      $(".draft_radio input:radio[name=post_radio]:eq(0)").prop(
        "disabled",
        false
      );
      $(".draft_radio input:radio[name=post_radio]:eq(0)")
        .parent()
        .removeClass("ignore");
    }
    radio_init(); //初期化

    //投稿対象
    post_sns = $(".snsSel_wrapper").find("select").val();

    //入力データ表示ダイアログ用データの確保
    let post_text = "";
    //テキストデータ
    post_text = $("#id_comment").val();
    //Facebookとinstagramのテキスト
    //タイトルの付加
    if ($("#title").val().length) {
      fb_text = "【" + $("#title").val() + "】" + "\n" + post_text;
      ig_text = "【" + $("#title").val() + "】" + "\n" + post_text;
    } else {
      fb_text = post_text;
      ig_text = post_text;
    }
    //パーマリンクの付加
    let home_str = $(".home_url").text().replace(/\s+/g, "");
    let permalink_txt = encodeURI(home_str + $("#url_id").val());
    if ($(".url_check").find("input:checkbox").prop("checked")) {
      fb_text += "\n" + permalink_txt;
      ig_text += "\n" + permalink_txt;
    }

    //Twitterのテキスト
    let st_point =
      field_arr["post_comment_tw_start"] === undefined
        ? 0
        : field_arr["post_comment_tw_start"];
    let ed_point =
      field_arr["post_comment_tw_end"] === undefined
        ? 0
        : field_arr["post_comment_tw_end"];

    if (st_point == 0 && ed_point == 0) {
      //選択範囲がない
      //タイトルの付加
      if ($("#title").val().length) {
        post_text = "【" + $("#title").val() + "】" + "\n" + post_text;
      }

      if (post_text.length > max_char) {
        //Twitterの文字列制限
        tw_text = post_text.substring(0, max_char - 3) + "...";
      } else {
        tw_text = post_text;
      }

      //URLを付加する
      if ($(".url_check").find("input:checkbox").prop("checked")) {
        tw_text += "\n" + permalink_txt;
      }
    } else {
      post_text = post_text.substring(st_point, ed_point) + "...";
      //タイトルの付加
      if ($("#title").val().length) {
        post_text = "【" + $("#title").val() + "】" + "\n" + post_text;
      }
      tw_text = post_text;
      //URLを付加する
      if ($(".url_check").find("input:checkbox").prop("checked")) {
        tw_text += "\n" + permalink_txt;
      }
    }

    //ダイアログに値を入れる
    dispLoading(); //ローディング表示

    //各種初期化
    $(".sns_image").html(
      '<div class="empty_msg">投稿する画像が選択されていません。</div><!-- /.empty_msg -->'
    );

    $(".sns_section").removeClass("select");
    $(".post_prg").addClass("ignore");
    $(".err_msg").remove();
    $('[name="save_cansel"]').prop("checked", false);
    $('[name="post_radio"]').val(["publish"]);
    radio_init();

    arr_urlimg = []; //画像の配列初期化
    arr_urlvideo = []; //動画の配列初期化

    //進捗状況リストの処理
    $.map(post_sns, function (element, index) {
      let sns_class = "." + element;
      $(".post_prg" + sns_class).removeClass("ignore");
    });

    //投稿対象に指定しているSNSにクラスを付加
    $.map(post_sns, function (element, index) {
      let sns_class = "." + element;
      $(".sns_section" + sns_class).addClass("select");
    });

    let section = $(".sns_section");
    section.each(function () {
      //テキスト部分
      if ($(this).hasClass("Twitter")) {
        $(this).find(".text_description").html(tw_text.replace(/\n/g, "<br>"));
      } else if ($(this).hasClass("Facebook")) {
        $(this).find(".text_description").html(fb_text.replace(/\n/g, "<br>"));
      } else if ($(this).hasClass("Instagram")) {
        $(this).find(".text_caption").html(ig_text.replace(/\n/g, "<br>"));
      }
    });

    //メディア部分
    let img_groups = $(".input_image").find(".media_item");
    let arr_img = []; //メディアの配列

    //メディアIDと選択したSNS情報の取得
    img_groups.each(function () {
      const $imgFrame = $(this).find(".img_frame");
      const val = $imgFrame.attr("data-val");
      if (val !== undefined) {
        const img_id = val;
        const field_name = $imgFrame.attr("data-field");
        const sns_select = $(this).find(".radio_select select").val();

        const media_item = {
          id: img_id,
          field_name: field_name,
          target_sns: sns_select,
        };
        arr_img.push(media_item);
      }
    });
    //メディア情報の取得
    arr_img_info = new Array(arr_img.length);
    $.map(arr_img, function (element, index) {
      $.ajax({
        type: "POST",
        url: ajaxUrl,
        data: {
          action: "itmar_get_imgUrl",
          index: index,
          img_id: element["id"],
          nonce: sns_relate_ajax_object.nonce,
        },
      })
        .done(function (res) {
          if (res.success) {
            const ret_data = res.data; // そのままオブジェクト
            let inx = ret_data["index"];
            let img_item = {
              url: ret_data["url"],
              kind: ret_data["kind"],
              type: ret_data["type"],
              width: ret_data["width"],
              height: ret_data["height"],
              id: element["id"],
              field_name: element["field_name"],
              target: element["target_sns"],
            };
            arr_img_info[inx] = img_item;
          } else {
            console.error(res.data?.message || "エラー");
          }
        })
        .fail(function (jqXHR, textStatus, errorThrown) {
          console.log(XMLHttpRequest.status);
          console.log(textStatus);
          console.log(errorThrown.message);
        })
        .always(function () {
          ajax_count--;
          if (ajax_count == 0) {
            modal_disp(arr_img_info);
          }
        });
      //ajaxで送信した数をインクリメント
      ajax_count++;
    });
    //画像等がない場合のモーダル表示
    modal_disp(); //この関数はajax_countが0でなければ機能しないのでメディア投稿があるときはこの命令は機能しない。
  });

  //ダイアログ表示時の関数
  function modal_disp(arr_info) {
    if (ajax_count == 0) {
      //カウント０以外では処理しない
      if (arr_info != undefined) {
        $.map(arr_info, function (element, index) {
          $.map(element["target"], function (element) {
            let modal_img;
            let err_list = $('<div class="err_list"/>');
            let img_info = arr_info[index];
            let err_range;
            //urlアイテムを生成（sns投稿用）
            let url_itm = {
              url: img_info["url"],
              target: element,
            };
            //ダイアログ表示用DOM要素生成
            if (img_info["kind"] === "image") {
              modal_img = $(
                '<div class="img_item"><div class="img_frame"><img src="' +
                  img_info["url"] +
                  '" alt=""></div></div>'
              );
              if (element === "Instagram") {
                //インスタグラム画像の規格外
                if (
                  img_info["width"] / img_info["height"] < 0.8 ||
                  img_info["width"] / img_info["height"] > 1.91
                ) {
                  // err_range=$('<div class="err_range"><img src=`"${sns_relate_ajax_object.plugin_uri}/img/asp_batu.png"` alt=""></div>');
                  // err_list.append(err_range);
                }
                if (img_info["type"] != "image/jpeg") {
                  //err_range=$('<div class="err_range"><img src=`"${sns_relate_ajax_object.plugin_uri}/img/png_batu.png"` alt=""></div>');
                  //err_list.append(err_range);
                }
              }
              modal_img.append(err_list); //エラーリストを付加
              arr_urlimg.push(url_itm); //url配列につめる
            } else {
              modal_img = $(
                '<div class="img_item"><div class="img_frame"><video autoplay loop muted src="' +
                  img_info["url"] +
                  '" playsinline=""></video></div></div>'
              );
              if (element === "Instagram") {
                //インスタグラム動画の規格外
                // if(img_info['width']/img_info['height']<0.8 || img_info['width']/img_info['height']>=1.78){
                //   err_range=$('<div class="err_range"><img src=`"${sns_relate_ajax_object.plugin_uri}/img/asp_batu.png"` alt=""></div>');
                //   err_list.append(err_range);
                // }
                if (img_info["type"] != "video/mp4") {
                  err_range = $(
                    `<div class="err_range"><img src="${sns_relate_ajax_object.plugin_uri}/img/png_batu.png" alt=""></div>`
                  );
                  err_list.append(err_range);
                }
              }
              modal_img.append(err_list); //エラーリストを付加
              arr_urlvideo.push(url_itm); //url配列につめる
            }
            let sns_class = "." + element;
            let erea = $(".sns_section" + sns_class);
            //空であることのメッセージは消す
            erea.find(".sns_image").find(".empty_msg").remove();
            //イメージを追加
            erea.find(".sns_image").append(modal_img);
          });
        });
      }

      //Twitter投稿のエラー
      let twitter_image = $(".sns_section" + ".Twitter").find(".image_erea");
      //投稿除外はエラー対象としない
      if ($.inArray("Twitter", post_sns) != -1) {
        let tw_image_count = twitter_image.find("img").length;
        let tw_video_count = twitter_image.find("video").length;
        if (tw_image_count > 4) {
          $(".sns_section" + ".Twitter")
            .find(".image_erea")
            .append(
              '<div class="err_msg over_count">Twitterに投稿できる画像は４枚までです。</div><!-- /.err_msg -->'
            );
        }
        if (tw_image_count > 0 && tw_video_count > 0) {
          $(".sns_section" + ".Twitter")
            .find(".image_erea")
            .append(
              '<div class="err_msg over_count">Twitterには画像と動画は同時投稿できません。</div><!-- /.err_msg -->'
            );
        }
        if (tw_video_count > 1) {
          $(".sns_section" + ".Twitter")
            .find(".image_erea")
            .append(
              '<div class="err_msg over_count">Twitterには複数の動画を同時投稿できません。</div><!-- /.err_msg -->'
            );
        }
      }

      //Facebook投稿のエラー
      let facebook_image = $(".sns_section" + ".Twitter").find(".image_erea");
      //投稿除外はエラー対象としない
      if ($.inArray("Facebook", post_sns) != -1) {
        let fb_image_count = facebook_image.find("img").length;
        let fb_video_count = facebook_image.find("video").length;
        if (fb_image_count > 0 && fb_video_count > 0) {
          $(".sns_section" + ".Facebook")
            .find(".image_erea")
            .append(
              '<div class="err_msg over_count">Facebookには画像と動画は同時投稿できません。</div><!-- /.err_msg -->'
            );
        }
        if (fb_video_count > 1) {
          $(".sns_section" + ".Facebook")
            .find(".image_erea")
            .append(
              '<div class="err_msg over_count">Facebookには複数の動画を同時投稿できません。</div><!-- /.err_msg -->'
            );
        }
      }

      //インスタ投稿のエラー
      let insta_image = $(".sns_section" + ".Instagram").find(".image_erea");

      //投稿除外はエラー対象としない
      if ($.inArray("Instagram", post_sns) != -1) {
        if (insta_image.find(".empty_msg").length) {
          insta_image.append(
            '<div class="err_msg">Instagram投稿には画像か動画が必要です。</div><!-- /.err_msg -->'
          );
        }
        if (insta_image.find(".err_range").length) {
          insta_image.append(
            '<div class="err_msg">規格外のメディアが選択されています。</div><!-- /.err_msg -->'
          );
        }
      }

      if ($(".modal_frame").find(".err_msg").length) {
        //エラーの有無をチェック
        $("#sns_entry").addClass("ignore");
        $(".modal_message").text(
          "エラーが検出されています。再設定してください。"
        );
        $(".modal_message").addClass("ignore");
      } else {
        $("#sns_entry").removeClass("ignore");
        $(".modal_message").text(
          wp.i18n.__(
            "The following content will be posted to social media. Please check the content.",
            "itmaroon-social-post-sync"
          )
        );
        $(".modal_message").removeClass("ignore");
      }
      $(".modal_bg").fadeIn();
      $(".modal_frame").fadeIn();
      removeLoading(); //全ての非同期処理が終わったらローディングを消す
    }
  }

  //投稿の実行
  $("#sns_entry").click(function (event) {
    if ($(this).hasClass("ignore")) return; //エラーがあれば先の処理はしない
    else $(this).addClass("ignore"); //２回押せないようにする。

    $(".modal_frame .modal_close").addClass("ignore"); //クローズボタンも押せないようにする

    //Wordpress投稿
    wp_post();
  });

  //下書きはSNS投稿しない
  $('[name="post_radio"]').change(function () {
    let flg = $(this).val() === "draft" ? true : false;
    flg = $('[name="save_cansel"]').prop("checked") ? true : flg; //投稿しないチェックがオンならflgはtrue
    checked_sns_post(flg);
  });

  //SNS投稿しないチェック
  $('[name="save_cansel"]').change(function () {
    let flg = $(this).prop("checked") ? true : false;
    flg = $('[name="post_radio"]:checked').val() === "draft" ? true : flg; //下書きならflgはtrue
    checked_sns_post(flg);
  });

  //SNS投稿するかしないかの処理
  function checked_sns_post(flg) {
    if (flg) {
      save_cansel_flg = true;
      //投稿ボタンの処理
      $("#sns_entry").removeClass("ignore");
      //進捗リストの処理
      $(".post_prg" + ".Twitter").addClass("ignore");
      $(".post_prg" + ".Facebook").addClass("ignore");
      $(".post_prg" + ".Instagram").addClass("ignore");
      //メッセージの処理
      $(".modal_message").text(
        wp.i18n.__(
          "Please check the contents (we will not post on social media).",
          "itmaroon-social-post-sync"
        )
      );
      $(".modal_message").removeClass("ignore");
    } else {
      save_cansel_flg = false;
      //進捗リストの処理
      $.map(post_sns, function (element, index) {
        let sns_class = "." + element;
        $(".post_prg" + sns_class).removeClass("ignore");
      });
      //投稿ボタンの処理
      if ($(".modal_frame").find(".err_msg").length) {
        //エラーの有無をチェック
        $("#sns_entry").addClass("ignore");
        //メッセージの処理
        $(".modal_message").text(
          "エラーが検出されています。再設定してください。"
        );
        $(".modal_message").addClass("ignore");
      } else {
        $(".modal_message").text(
          wp.i18n.__(
            "The following content will be posted to social media. Please check the content.",
            "itmaroon-social-post-sync"
          )
        );
      }
    }
  }

  //WordPress投稿
  async function wp_post() {
    try {
      dispLoading();

      let entry_postDate = $("#postdate_id").val();
      let sel_radio = $(".draft_radio input:checked");

      const acfFieldsObject = arr_img_info.reduce((acc, acf_img) => {
        const key = acf_img.field_name;
        const id = acf_img.id;

        // ★ featured はスキップ
        if (key === "featured") {
          return acc;
        }

        if (!(key in acc)) {
          // 初登場 → スカラー(int)
          acc[key] = id;
        } else if (Array.isArray(acc[key])) {
          // すでに配列
          acc[key].push(id);
        } else {
          // 2回目 → 配列に昇格
          acc[key] = [acc[key], id];
        }

        return acc;
      }, {});

      const post_data = {
        ID: post_id,
        title: $("#title").val(),
        excerpt: $("#id_comment").val(),
        post_type: sns_relate_ajax_object.targetPostType,
        date: $("#postdate_id").val(),
        post_status: sel_radio.val(),
        post_name: $("#url_id").val(),
        terms: tax_map(), // 選択されたカテゴリー・タグ・カスタムタクソノミーを taxonomy => [slug, ...] の形式で取得
        custom_fields: {
          post_comment_tw_start: field_arr["post_comment_tw_start"],
          post_comment_tw_end: field_arr["post_comment_tw_end"],
          post_sns: $(".snsSel_wrapper").find("select").val(),
        },
      };

      // acfFieldsObject が空でないなら acfFieldsObjectとthumbnail_id を追加
      if (Object.keys(acfFieldsObject).length > 0) {
        post_data.thumbnail_id = arr_img_info[0].id;
        post_data.acf_fields = acfFieldsObject;
      } else if (arr_img_info.length > 0) {
        post_data.thumbnail_id = arr_img_info[0].id;
        post_data.acf_fields = { gallery: [] };
      } else {
        post_data.thumbnail_id = null;
        post_data.acf_fields = { gallery: [] };
      }

      await $.ajax({
        type: "POST",
        url: ajaxUrl,
        data: {
          action: "itmar_post_ajax",
          post_data: JSON.stringify(post_data),
          mode: post_id === 0 ? "create" : "update",
          nonce: sns_relate_ajax_object.nonce,
        },
      });

      //更新中フラグとセーブフラグの処理
      modify_flg = false;
      saved_flg = true;

      //将来日付のものはSNS投稿しない
      const post_date = new Date(entry_postDate);
      const now_date = new Date();
      if (post_date > now_date) return;
      //SNS投稿処理
      if (!save_cansel_flg && post_sns.length > 0) {
        post_sns.map((element) => {
          let entry_text = "";
          switch (element) {
            case "Twitter":
              entry_text = tw_text;
              break;
            case "Facebook":
              entry_text = fb_text;
              break;
            case "Instagram":
              entry_text = ig_text;
              break;
          }

          try {
            $.ajax({
              type: "POST",
              url: ajaxUrl,
              data: {
                action: "itmar_entry_sns",
                entry_ID: post_id,
                entry_text,
                entry_img: arr_urlimg,
                entry_sns: element,
                entry_video: arr_urlvideo,
                nonce: sns_relate_ajax_object.nonce,
              },
            });
            $(".post_prg." + element)
              .find("span")
              .text("投稿依頼完了");
            $(".post_prg." + element).addClass("conp");
          } catch (snsErr) {
            console.error(`${element} error`, snsErr);
          }
        });
      }
    } catch (err) {
      console.error("Wp error", err);
      error(err.responseText || err.message);
    } finally {
      removeLoading();
      $(".return_box").addClass("appear");
    }
  }

  //終了ボタン
  $("#btn_end").click(function () {
    window.location.href = `${sns_relate_ajax_object.redirectUrl}?page=itmaroon-social-post-sync-post-list`;
  });

  //タイトル変更時の処理
  $("#title").on("change", function () {
    dispLoading();
    //絵文字の処理
    let org_text = document.getElementById("title").value;
    document.getElementById("title").value = org_text;
    //選択範囲のクリア
    field_arr["post_comment_tw_start"] =
      field_arr["post_comment_tw_start"] != undefined
        ? field_arr["post_comment_tw_start"]
        : 0;
    field_arr["post_comment_tw_end"] =
      field_arr["post_comment_tw_end"] != undefined
        ? field_arr["post_comment_tw_end"]
        : 0;

    if (
      !(
        Number(field_arr["post_comment_tw_start"]) == 0 &&
        Number(field_arr["post_comment_tw_end"]) == 0
      )
    ) {
      ctrlMsg("Twitter投稿文書の選択範囲はクリアされます。");
      field_arr["post_comment_tw_start"] = 0;
      field_arr["post_comment_tw_end"] = 0;
    }
    //TWitter文字列上限の表示
    $(".char_count .tw_limit").text(max_char - $(this).val().length - 3);

    //翻訳処理
    let input_elm = $(this);
    $.ajax({
      type: "POST",
      url: ajaxUrl,
      data: {
        action: "itmar_url_trans",
        input_data: input_elm.val(),
        post_id: post_id,
        nonce: sns_relate_ajax_object.nonce,
      },
    })
      .done(function (res) {
        if (res.success) {
          const ret_data = res.data; // そのままオブジェクト
          if (ret_data["code"] != 0) {
            //空のデータしか返らないときは日本語のまま
            ctrlMsg("翻訳エラー：" + ret_data["text"]);
            $("#url_id").val(input_elm.val());
          } else {
            $("#url_id").val(ret_data["text"]);
          }
        } else {
          console.error(res.data?.message || "エラー");
        }
      })
      .fail(function (XMLHttpRequest, textStatus, errorThrown) {
        console.log(XMLHttpRequest.status);
        console.log(textStatus);
        console.log(errorThrown.message);
      })
      .always(function () {
        removeLoading();
      });
  });

  //Datepickerの処理
  $.datetimepicker.setLocale("ja");

  //祝日の処理
  $.get(
    "https://holidays-jp.github.io/api/v1/date.json",
    function (holidaysData) {
      $("#postdate_id").datetimepicker({
        step: 10, //１０分刻み
        beforeShowDay: function (date) {
          var holidays = Object.keys(holidaysData);
          for (var i = 0; i < holidays.length; i++) {
            var holiday = new Date(Date.parse(holidays[i]));
            if (
              holiday.getYear() == date.getYear() &&
              holiday.getMonth() == date.getMonth() &&
              holiday.getDate() == date.getDate()
            ) {
              return [true, "day-holiday", null];
            }
          }

          //土曜日曜
          if (date.getDay() == 0) {
            return [true, "day-sunday", null];
          } else if (date.getDay() == 6) {
            return [true, "day-saturday", null];
          }

          return [true, "day-weekday", null];
        },
      });
    }
  );

  //投稿日の制御
  let pre_date;
  $("#postdate_id").on("focusin", function () {
    //フォーカスが当たった時、入力前の値を確保
    pre_date = $(this).val();
  });
  $("#postdate_id").on("change", function () {
    let now_date_val = new Date();
    let change_date_val = new Date($(this).val());
    if (
      !(post_status === "pending" || post_status === "future") &&
      now_date_val < change_date_val
    ) {
      ctrlMsg("新規投稿又は予約投稿以外は将来の日付を設定できません。");
      $(this).val(pre_date);
    }
  });
});
