//減算用の関数(Twitterのmax_id減算)
function decStrNum(n) {
  n = n.toString();
  var result = n;
  var i = n.length - 1;
  while (i > -1) {
    if (n[i] === "0") {
      result = result.substring(0, i) + "9" + result.substring(i + 1);
      i--;
    } else {
      result =
        result.substring(0, i) +
        (parseInt(n[i], 10) - 1).toString() +
        result.substring(i + 1);
      return result;
    }
  }
  return result;
}

/* ------------------------------
Loading イメージ表示関数
引数： msg 画面に表示する文言
------------------------------ */
function dispLoading(msg, target) {
  // 引数なし（メッセージなし）を許容
  if (msg == undefined) {
    msg = "";
  }
  // 画面表示メッセージ
  let dispMsg =
    "<div class='loadingMsg'><div class='loading_icon'></div><p>" +
    msg +
    "</p></div>";
  // ローディング画像が表示されていない場合のみ出力
  if (target == undefined) {
    //ターゲット指定がないときはbodyにつける
    target = jQuery("body");

    if (target.find(".itmar_loading").length == 0) {
      target.append("<div class='itmar_loading body'>" + dispMsg + "</div>");
    }
  } else {
    if (target.find(".itmar_loading").length == 0) {
      target.append("<div class='itmar_loading'>" + dispMsg + "</div>");
    }
  }
}

/* ------------------------------
Loading イメージ削除関数
------------------------------ */
function removeLoading(dispMsg, target) {
  if (target == undefined) {
    //ターゲット指定がないときはbodyにつける
    target = jQuery("body");
  }
  target.find(".itmar_loading").fadeOut(300, function () {
    jQuery(this).remove();
    if (dispMsg != undefined && dispMsg.length > 0) {
      // 引数ありのとき
      jQuery("body").append("<div id='result_msg' >" + dispMsg + "</div>");
      jQuery("#result_msg").slideDown(300, function () {
        setTimeout(function () {
          jQuery("#result_msg").slideUp(300, function () {
            jQuery(this).remove();
          });
        }, 2000);
      });
    }
  });
}
/* ------------------------------
メッセージ表示関数
------------------------------ */
function ctrlMsg(dispMsg) {
  jQuery("body").append("<div id='result_msg' >" + dispMsg + "</div>");
  jQuery("#result_msg").slideDown(300, function () {
    setTimeout(function () {
      jQuery("#result_msg").slideUp(300, function () {
        jQuery(this).remove();
      });
    }, 2000);
  });
}

//オバーフローした要素にクラスをつける
function add_overflow(card_item) {
  card_item.find(".post_text").each(function () {
    let scrollHeight = jQuery(this).get(0).scrollHeight;
    let clientHeight = jQuery(this).get(0).clientHeight;
    if (scrollHeight > clientHeight) {
      jQuery(this).addClass("overflow");
      if (jQuery(this).find(".more").length == 0) {
        let more = jQuery('<div class="more">もっと見る</div><!-- /.more -->');
        jQuery(this).append(more);
      }
    } else {
      jQuery(this).removeClass("overflow");
      jQuery(this)
        .find(".more")
        .each(function () {
          jQuery(this).remove();
        });
    }
  });
}

//ラジオボタンの初期化
function radio_init() {
  let radios = jQuery("input:radio");
  radios.each(function () {
    if (jQuery(this).is(":checked")) {
      jQuery(this).parent().addClass("ready");
      jQuery(this).parent().addClass("checked");
      jQuery(this).parent().prevAll("label").addClass("check_prev");
      jQuery(this).parent().nextAll("label").addClass("check_next");
    }
  });
}

//セレクト要素の初期化
function radioSelect_init(sns_selecter) {
  //ラジオ型セレクトボックス

  let div = jQuery('<div class="radio_select"/>');

  //単数選択か複数選択か
  if (sns_selecter.attr("multiple")) {
    div = div.addClass("selectMultiple");
  } else {
    div = div.addClass("selectSingle");
  }
  let active = jQuery("<div />");
  div.append(active);
  //オプションの処理
  let options = sns_selecter.find("option");

  let list = jQuery('<div class="radio_list" />');

  options.each(function (index) {
    let text = jQuery(this).text();
    let slug = jQuery(this).val();
    let item = jQuery('<div class="radio_btn" data-value="' + slug + '"/>');
    let icon = jQuery(
      '<div class="img_wrapper"><img src="' + text + '" alt=""></div>'
    );
    let bullet = jQuery(
      '<div class="bullet"><div class="line zero"></div><div class="line one"></div><div class="line two"></div><div class="line three"></div><div class="line four"></div><div class="line five"></div><div class="line six"></div><div class="line seven"></div></div>'
    );
    icon.append(bullet);
    item.append(icon);

    if (jQuery(this).is(":selected")) {
      item.addClass("select");
    }
    list.append(item);
  });

  div.append(list);
  sns_selecter.wrap(div);
}

//テキストボックスの処理
function textbox_init() {
  const target = jQuery("#focus"); // focus element
  jQuery(".input_box > input,.input_box > textarea").each(function () {
    if (this.value) {
      jQuery(this).parent().children("label").addClass("active");
      //テキストエリアの高さを拡大
      let clientHeight = jQuery(this).height();
      //textareaの入力内容の高さを取得
      let scrollHeight = jQuery(this).get(0).scrollHeight;
      //textareaの高さに入力内容の高さを設定
      jQuery(this).css("height", scrollHeight + "px");
      target.css("height", scrollHeight + "px");
    }
  });

  jQuery(".input_box > input,.input_box > textarea").on("focusin", function () {
    jQuery(this).parent().children("label").addClass("active");
    let props = {
      top: jQuery(this).parent().offset().top,
      left: jQuery(this).parent().offset().left,
      width: jQuery(this).parent().outerWidth(),
      height: jQuery(this).parent().outerHeight(),
      radius: parseInt(jQuery(this).parent().css("border-radius")),
    };
    //console.log(props);
    // set position

    target.fadeIn(100, function () {
      target.offset({ top: props.top, left: props.left });
      target.css({
        //top: props.top,
        //left: props.left,
        width: props.width,
        height: props.height,
        "border-radius": props.radius,
      });
    });
  });

  jQuery(".input_box > input,.input_box > textarea").on(
    "focusout",
    function () {
      if (!jQuery(this).parent().hasClass("url_box")) {
        //url_boxははずさない
        if (!this.value) {
          //データが入っていなければactiveをはずす
          jQuery(this).parent().children("label").removeClass("active");
        }
      }

      target.fadeOut(100);
    }
  );

  //テキストエリアの高さ伸長・文字数表示
  jQuery(".input_box > textarea").on("input", function () {
    jQuery(this).css("height", "auto");
    //textareaの入力内容の高さを取得
    let scrollHeight = jQuery(this).get(0).scrollHeight;
    //textareaの高さに入力内容の高さを設定
    jQuery(this).css("height", scrollHeight + "px");
    target.css("height", scrollHeight + "px");
    //文字数表示
    let char_count = jQuery(this).val().length;
    jQuery(".char_count .input_count").text(char_count);
  });
}

function nomalSelect_init() {
  //ノーマルセレクトボックス
  let select = jQuery("select.nomal");
  select.each(function () {
    let div = jQuery('<div class="custom_select"/>');
    //単数選択か複数選択か
    if (jQuery(this).attr("multiple")) {
      div = div.addClass("selectMultiple");
    } else {
      div = div.addClass("selectSingle");
    }

    //オプションの処理
    let options = jQuery(this).find("option");

    let active = jQuery("<div />");
    let list = jQuery("<ul />");
    let placeholder = jQuery(this).data("placeholder");
    let span = jQuery("<span />").text(placeholder).appendTo(active);
    options.each(function (index) {
      let text = jQuery(this).text();
      let slug = jQuery(this).val();
      let kind = jQuery(this).attr("class");
      let icon = jQuery(this).data("icon");

      if (jQuery(this).is(":selected")) {
        let active_item = jQuery('<a data-value="' + slug + '"/>').html(
          '<em class="' + kind + '">' + text + "</em><i></i>"
        );
        if (kind === "post_item") {
          //post_itemのときはアイコンをつける
          active_item.attr("data-icon", icon);
          active_item.prepend(
            jQuery(
              '<span class="wp-menu-image dashicons-before ' +
                icon +
                '"></span>'
            )
          );
        }
        active.append(active_item);
        span.addClass("hide");
      } else {
        let list_item = jQuery(
          '<li class="' + kind + '" data-value="' + slug + '"/>'
        ).html(text);
        if (kind === "post_item") {
          //post_itemのときはアイコンをつける
          list_item.attr("data-icon", icon);
          list_item.prepend(
            jQuery(
              '<span class="wp-menu-image dashicons-before ' +
                icon +
                '"></span>'
            )
          );
        }
        list.append(list_item);
      }
    });
    active.append(jQuery("<div />").addClass("arrow"));
    div.append(active).append(list);
    jQuery(this).wrap(div);
  });
}

//Swiper 初期化関数（外出し）
function initSwiper(selector) {
  setTimeout(() => {
    new Swiper(selector, {
      loop: true,
      slidesPerView: 1,
      spaceBetween: 10,
      pagination: {
        el: selector + " .swiper-pagination",
        clickable: true,
      },
      navigation: {
        nextEl: selector + " .swiper-button-next",
        prevEl: selector + " .swiper-button-prev",
      },
    });
  }, 0);
}

//Swiper設定（カバーフロー）
const coverflow_parm = {
  //init: false,
  loop: true,
  speed: 800,
  slidesPerView: 1.3,
  spaceBetween: 0,
  centeredSlides: true,
  effect: "coverflow",
  coverflowEffect: {
    rotate: 50, // Slide rotate in degrees
    stretch: 5, // Stretch space between slides (in px)
    depth: 200, // Depth offset in px (slides translate in Z axis)
    modifier: 1, // Effect multipler
    slideShadows: true, // Enables slides shadows
  },
  parallax: true,
  pagination: {
    el: ".swiper_dots",
    clickable: true,
  },
  navigation: {
    nextEl: ".swiper-button-next",
    prevEl: ".swiper-button-prev",
  },

  //スライダー遷移時（ドキュメント内の全動画を一時停止にする）
  on: {
    transitionStart: function () {
      let videos = document.querySelectorAll(".insta_swiper video");
      Array.prototype.forEach.call(videos, function (video) {
        video.pause();
        video.muted = true;
      });
    },
  },
};

// Swiper設定（キューブ）
let isMove = false;
const cube_parm = {
  init: false,
  loop: true,
  speed: 800,
  autoplay: {
    delay: 3000,
  },
  effect: "cube", // 'cube', 'fade', 'coverflow',
  cubeEffect: {
    shadow: true,
    slideShadows: true,
    shadowOffset: 40,
    shadowScale: 0.94,
  },
  grabCursor: true,
  pagination: {
    el: ".swiper-pagination",
    clickable: true,
  },
  navigation: {
    nextEl: ".swiper-button-next",
    prevEl: ".swiper-button-prev",
  },
  // Events
  on: {
    init: function () {
      this.autoplay.stop();
    },
    imagesReady: function () {
      this.el.classList.remove("loading");
      set_imagScale($(".swiper-wrapper"));
      change_swiper_scale(this);
      this.autoplay.start();
    },
    touchMove: function (event) {
      if (!isMove) {
        this.el.classList.remove("scale-in");
        this.el.classList.add("scale-out");
        isMove = true;
      }
    },
    touchEnd: function (event) {
      this.el.classList.remove("scale-out");
      this.el.classList.add("scale-in");
      setTimeout(function () {
        isMove = false;
      }, 300);
    },
    slideChangeTransitionStart: function () {
      if (!isMove) {
        this.el.classList.remove("scale-in");
        this.el.classList.add("scale-out");
      }
    },
    slideChangeTransitionEnd: function () {
      if (!isMove) {
        this.el.classList.remove("scale-out");
        this.el.classList.add("scale-in");
      }
    },

    slideChange: function () {
      change_swiper_scale(this);
      console.log("slideChange " + this.activeIndex);
      console.log(this);
    },
  },
};

//各イベントの処理
jQuery(function ($) {
  //ヘッダーがある場合はマージンを設定
  if ($("header").length) {
    let header_height = $("header").innerHeight();
    $(".header_space").css({ height: header_height + "px" });
  }

  //select要素のクリック時(複数選択)
  $(document).on("click", ".selectMultiple ul li", function (e) {
    let select = $(this).parent().parent();
    let li = $(this);
    let slug = li.data("value");
    let kind = li.attr("class");

    if (!select.hasClass("clicked")) {
      select.addClass("clicked");
      li.prev().addClass("beforeRemove");
      li.next().addClass("afterRemove");
      li.addClass("remove");
      let a = $('<a data-value="' + slug + '"/>')
        .addClass("notShown")
        .html('<em class="' + kind + '">' + li.text() + "</em><i></i>")
        .hide()
        .appendTo(select.children("div"));
      a.slideDown(400, function () {
        setTimeout(function () {
          a.addClass("shown");
          select.children("div").children("span").addClass("hide");
          let option_slug = select.find('option[value="' + slug + '"]');
          option_slug.each(function () {
            if ($(this).hasClass(kind)) $(this).prop("selected", true).change();
          });
        }, 500);
      });
      setTimeout(function () {
        if (li.prev().is(":last-child")) {
          li.prev().removeClass("beforeRemove");
        }
        if (li.next().is(":first-child")) {
          li.next().removeClass("afterRemove");
        }
        setTimeout(function () {
          li.prev().removeClass("beforeRemove");
          li.next().removeClass("afterRemove");
        }, 200);
        li.slideUp(400, function () {
          li.remove();
          select.removeClass("clicked");
        });
      }, 600);
    }
  });

  //select要素のクリック時(単数選択)
  $(document).on("click", ".selectSingle ul li", function (e) {
    let select = $(this).parent().parent();
    let li = $(this);
    let new_slug = li.data("value");
    let new_kind = li.attr("class");
    let new_icon = li.data("icon");
    //選択肢をリストに戻す
    let sel_item = select.children("div").find("a");
    let old_slug = sel_item.data("value");
    let old_kind = sel_item.find("em").attr("class");
    let old_icon = sel_item.data("icon");

    if (sel_item.length != 0) {
      let ret_li = $(
        '<li class="' + old_kind + '" data-value="' + old_slug + '"/>'
      ).text(sel_item.text());
      if (new_kind === "post_item") {
        //post_itemのときはアイコンをつける
        ret_li.attr("data-icon", old_icon);
        ret_li.prepend(
          jQuery(
            '<span class="wp-menu-image dashicons-before ' +
              old_icon +
              '"></span>'
          )
        );
      }
      ret_li.appendTo(select.find("ul"));
    }
    //選択肢を消す
    sel_item.remove();
    //選択した項目をセット
    let a = $('<a data-value="' + new_slug + '"/>')
      .addClass("notShown")
      .html('<em class="' + new_kind + '">' + li.text() + "</em><i></i>")
      .hide();
    if (new_kind === "post_item") {
      //post_itemのときはアイコンをつける
      a.attr("data-icon", new_icon);
      a.prepend(
        jQuery(
          '<span class="wp-menu-image dashicons-before ' +
            new_icon +
            '"></span>'
        )
      );
    }
    a.appendTo(select.children("div"));

    //リストから消す
    li.remove();

    a.slideDown(400, function () {
      //プルダウンを消す
      select.removeClass("open");
      //選択肢を表示
      setTimeout(function () {
        a.addClass("shown");
        select.children("div").children("span").addClass("hide");
        select
          .find('option[value="' + new_slug + '"]')
          .prop("selected", true)
          .change();
      }, 500);
    });
  });

  //選択済みの要素を押したとき
  $(document).on("click", ".selectMultiple > div a", function (e) {
    let select = $(this).parent().parent();
    let self = $(this);
    let slug = self.data("value");
    let kind = self.find("em").attr("class");

    self.removeClass().addClass("remove");
    select.addClass("open");
    setTimeout(function () {
      self.addClass("disappear");
      setTimeout(function () {
        self.animate(
          {
            width: 0,
            height: 0,
            padding: 0,
            margin: 0,
          },
          300,
          function () {
            let li = $('<li data-value="' + slug + '"/>')
              .text(self.children("em").text())
              .addClass("notShown")
              .appendTo(select.find("ul"));

            li.slideDown(400, function () {
              li.addClass("show");
              setTimeout(function () {
                select
                  .find('option[value="' + slug + '"]')
                  .prop("selected", false)
                  .change();

                if (!select.find("option:selected").length) {
                  select.children("div").children("span").removeClass("hide");
                }
                li.removeClass();
                li.addClass(kind);
              }, 400);
            });
            self.remove();
          }
        );
      }, 300);
    }, 400);
  });
  //矢印かセレクトボックスを押したとき
  $(document).on(
    "click",
    ".custom_select > div .arrow, .custom_select > div span",
    function (e) {
      $(this).parent().parent().toggleClass("open");
    }
  );

  //セレクトボックスからマウスが外れた時
  $(document).on("mouseleave", ".custom_select", function (e) {
    $(this).removeClass("open");
  });

  //select要素のクリック時(ラジオ型選択)
  $(document).on("click", ".radio_list > .radio_btn", function (e) {
    let select = $(this).parent().parent();
    let slug = $(this).data("value");
    //クリックされた要素と同じvalueをもつoption
    let option_slug = select.find('option[value="' + slug + '"]');
    //オプション値の変更
    option_slug
      .prop("selected", function (index, prop) {
        return !prop;
      })
      .change();

    //ボタンの変更
    $(this).toggleClass("select");
    //データをセット
    let media_area = $(this).parents(".input_image").parent(); //エリア抽出
    if (media_area.length > 0) {
      //メディアリスト
      let media = $(this).parents(".media_item"); //選択されたメディア
      let media_list = media_area.find(".media_item");
      let mediaNum = media_list.index(media);

      let data_group = $(
        '.acf-field-group[data-name="pict_' + (mediaNum + 1) + '"]'
      );
      let image_select = data_group
        .find('[data-name="target_sns"]')
        .find("input");
      image_select.val(select.find("select").val()); //セレクトの配列
    }
    let sns_area = $(this).parents(".snsSel_wrapper"); //エリア抽出
    if (sns_area.length > 0) {
      //SNS選択
      let acf_data = $('.acf-field[data-name="post_sns"]');
      let sns_select = acf_data.find("input");
      sns_select.val(select.find("select").val()); //セレクトの配列
    }
  });

  //ラジオボタンの変更時
  $(document).on("change", "input:radio", function () {
    let radio_list = $(this).parent().parent().find("label");
    radio_list.each(function () {
      if ($(this).find("input").is(":checked")) {
        radio_list.removeClass("checked check_prev check_next");
        $(this).addClass("checked ready");
        $(this).prevAll("label").addClass("check_prev");
        $(this).nextAll("label").addClass("check_next");
        $("input:radio").on(
          "webkitTransitionEnd mozTransitionEnd oTransitionEnd transitionend",
          function () {
            // 処理
            $(this).parents("label").addClass("ready");
          }
        );
      }
    });
  });

  //モーダルを閉じる
  $(".modal_close,.modal_bg").click(function () {
    if ($(this).hasClass("ignore")) {
      return; //ignoreクラスがついていたら処理しない。
    }
    $(".modal_bg").removeClass("white");
    $(".modal_bg").fadeOut();
    $(".modal_post").fadeOut();
    $(".modal_media").fadeOut();
    $(".modal_frame").fadeOut();
    $(".modal_delete").fadeOut();
    $(".modal_ctrl").fadeIn();
  });

  //動画再生ボタン
  $(document).on("click", ".movie_button", function (event) {
    event.preventDefault();
    event.stopPropagation();
    $(this).toggleClass("pause");
    let video_obj = $(this).parent().find("video");
    if (video_obj.get(0).paused) {
      //video_obj.get(0).muted=false;
      video_obj.get(0).play();
      $(this).text("PAUSE");
    } else {
      video_obj.get(0).pause();
      $(this).text("PLAY");
    }
  });

  $("video").on("ended", function () {
    let movie_btn = $(this).parent().find(".movie_button");
    movie_btn.removeClass("pause");
    movie_btn.text("PLAY");
  });

  //ミュートボタン
  $(document).on("click", ".vol_button", function (event) {
    event.preventDefault();
    event.stopPropagation();
    $(this).toggleClass("on");
    let video_obj = $(this).parent().find("video");
    if (video_obj.get(0).muted) {
      video_obj.get(0).muted = false;
    } else {
      video_obj.get(0).muted = true;
    }
  });

  //infobtnの処理
  jQuery(document).on("click", ".info_btn", function () {
    jQuery(this).find(".ballon").toggleClass("display");
  });

  //masonryの実行
  //masonry_exec();
});

//masonry配置
// function masonry_exec() {
//   let sp = 768; //SPのサイズを設定
//   if (jQuery("html").width() < sp) {
//     jQuery(".masonry_list").masonry();
//     jQuery(".masonry_list").masonry("destroy");
//   } else {
//     let img_count = jQuery(".masonry_list").find("img").length;
//     let video_count = jQuery(".masonry_list").find("video").length;

//     //imagesLoadedによる画像の読込状態監視
//     var imgLoad = imagesLoaded(".masonry_list");
//     imgLoad.on("progress", function () {
//       img_count--;
//       if (img_count == 0) {
//         //全てのメディアが読み込まれた段階でMasonryの関数を実行させる
//         jQuery(".masonry_list").masonry({
//           itemSelector: ".masonry_item",
//           columnWidth: 205,
//           fitWidth: true, //コンテンツ数に合わせ親の幅を自動調整
//         });
//       }
//     });
//     jQuery(".masonry_list")
//       .find("video")
//       .on("loadeddata", function () {
//         video_count--;
//         if (video_count == 0) {
//           //全てのメディアが読み込まれた段階でMasonryの関数を実行させる
//           jQuery(".masonry_list").masonry({
//             itemSelector: ".masonry_item",
//             columnWidth: 205, //カラム幅を設定
//             fitWidth: true, //コンテンツ数に合わせ親の幅を自動調整
//           });
//         }
//       });
//   }
// }

jQuery(window).resize(function () {
  //ウィンドウがリサイズされたら、再度masonry_execute関数を実行
  //masonry_exec();
  jQuery(".intro_report_item").each(function () {
    add_overflow(jQuery(this));
  });
});

// 選択されたカテゴリー・タグ・カスタムタクソノミーを taxonomy => [slug, ...] の形式で取得
const tax_map = () => {
  const taxMap = {}; // { taxonomy: [term_slugs...] }

  jQuery("#id_category option:selected").each(function () {
    const val = jQuery(this).val();
    const className = jQuery(this).attr("class");

    if (className === "catg_item") {
      taxMap["category"] = taxMap["category"] || [];
      taxMap["category"].push(val);
    } else if (className === "tag_item") {
      taxMap["post_tag"] = taxMap["post_tag"] || [];
      taxMap["post_tag"].push(val);
    } else if (className === "term_item") {
      const [termSlug, taxonomy] = val.split(",");
      if (taxonomy && termSlug) {
        taxMap[taxonomy] = taxMap[taxonomy] || [];
        taxMap[taxonomy].push(termSlug);
      }
    }
  });
  return taxMap;
};
