<?php
namespace ILJ\Core\Options;

use ILJ\Helper\Options as OptionsHelper;

/**
 * Option: Respect existing links
 *
 * @package ILJ\Core\Options
 * @since   1.1.3
 */
class RespectExistingLinks extends AbstractOption {
	
	/**
	 * Get the unique identifier for the option
	 *
	 * @return string
	 */
	public static function getKey() {
		return self::ILJ_OPTIONS_PREFIX . 'link_output_respect_existing_links';
	}
	
	/**
	 * Get the default value of the option
	 *
	 * @return mixed
	 */
	public static function getDefault() {
		return false;
	}
	
	/**
	 * Identifies if the current option is pro only
	 *
	 * @return bool
	 */
	public static function isPro() {
		return true;
	}

	/**
	 * Adds the option to an option group
	 *
	 * @param  string $option_group The option group to which the option gets connected
	 * @return void
	 */
	public function register($option_group) {
		
	}
	
	/**
	 * Get the frontend label for the option
	 *
	 * @return string
	 */
	public function getTitle() {
		return __('Consideration of existing or manually created links', 'internal-links');
	}
	
	/**
	 * Get the frontend description for the option
	 *
	 * @return string
	 */
	public function getDescription() {
		return __('Do not link already manually built link targets', 'internal-links') . '<br>' . __('Prevents links to URLs that are already linked in the content', 'internal-links');
	}
	
	/**
	 * Outputs the options form element for backend administration
	 *
	 * @param  mixed $value
	 * @return mixed
	 */
	public function renderField($value) {
		{
      $value = false;
  }
		OptionsHelper::renderToggle($this, $value);
	}

	/**
	 * Checks if a value is a valid value for option
	 *
	 * @param  mixed $value The value that gets validated
	 * @return bool
	 */
	public function isValidValue($value) {
		

		return false;
	}
}
