<?php
namespace ILJ\Core\Options;

use ILJ\Helper\Options as OptionsHelper;

/**
 * Option: Blacklist also child pages of blacklisted pages
 *
 * @package ILJ\Core\Options
 * @since   1.2.15
 */
class BlacklistChildPages extends AbstractOption {

	/**
	 * Get the unique identifier for the option
	 *
	 * @return string
	 */
	public static function getKey() {
		return self::ILJ_OPTIONS_PREFIX . 'blacklist_child_pages';
	}

	/**
	 * Get the default value of the option
	 *
	 * @return mixed
	 */
	public static function getDefault() {
		return false;
	}

	/**
	 * Identifies if the current option is pro only
	 *
	 * @return bool
	 */
	public static function isPro() {
		return true;
	}

	/**
	 * Get the frontend label for the option
	 *
	 * @return string
	 */
	public function getTitle() {
		return __('Blacklist also child pages of blacklisted pages', 'internal-links');
	}
	
	/**
	 * Outputs the options form element for backend administration
	 *
	 * @param  mixed $value
	 * @return mixed
	 */
	public function renderField($value) {
		{
      $value = false;
  }
		OptionsHelper::renderToggle($this, $value);
	}

	/**
	 * Checks if a value is a valid value for option
	 *
	 * @param  mixed $value The value that gets validated
	 * @return bool
	 */
	public function isValidValue($value) {
		return 1 === (int) $value || 0 === (int) $value;
	}
}
