<?php
namespace IntentDeep\VirtualFiles\Bootstrap;

use IntentDeep\VirtualFiles\Bootstrap\Settings;
use IntentDeep\VirtualFiles\Bootstrap\PluginManager;
use IntentDeep\VirtualFiles\Bootstrap\FreemiusManager;
use IntentDeep\VirtualFiles\Controllers\FrontendController;

class Bootstrap {
    /**
     * Plugin configuration
     */
    private const PLUGIN_CONFIG = [
        // Basic plugin info
        'id' => 'XXXX', // Replace with your Freemius plugin ID
        'slug' => 'virtual-files',
        'public_key' => 'pk_your_public_key_here', // Replace with your public key
        'error_prefix' => 'Virtual Files',

        // Freemius messages
        'messages' => [
            'connect' => [
                'title' => 'Hey %1$s, %2$s Click on Allow & Continue to start creating virtual files. %2$s Never miss an important update -- opt-in to our security and feature updates notifications. %2$s See you on the other side.'
            ]
        ]
    ];

    /**
     * @var FreemiusManager
     */
    private static FreemiusManager $freemiusManager;

    /**
     * @var PluginManager
     */
    private static PluginManager $pluginManager;

    /**
     * Initialize the plugin
     */
    public static function init(): void {
        try {
            self::defineConstants();
            self::initializePlugin();
        } catch (\Exception $e) {
            intentdeep_vf_log(sprintf("%s Bootstrap Error: %s", self::PLUGIN_CONFIG['error_prefix'], $e->getMessage()));
        }
    }

    /**
     * Define plugin constants
     */
    private static function defineConstants(): void {
        $constants = [
            'VIRTUAL_FILES_PLUGIN_BASE' => plugin_basename(INTENTDEEP_VF_PLUGIN_ROOT . 'virtual-files.php'),
            'VIRTUAL_FILES_PLUGIN_DIR' => plugins_url('', INTENTDEEP_VF_PLUGIN_ROOT),
        ];

        foreach ($constants as $name => $value) {
            if (!defined($name)) {
                define($name, $value);
            }
        }
    }

    /**
     * Initialize plugin managers
     */
    private static function initializePlugin(): void {
        // Initialize Freemius customization
        self::$freemiusManager = new FreemiusManager(
            self::PLUGIN_CONFIG['id'],
            self::PLUGIN_CONFIG['slug'],
            self::PLUGIN_CONFIG['messages']
        );
        self::$freemiusManager->init();

        // Initialize plugin manager (without activation hooks)
        self::$pluginManager = new PluginManager(self::PLUGIN_CONFIG['slug']);
        self::$pluginManager->init();

        // Initialize admin functionality
        if (is_admin()) {
            new Settings();
        }

        // Initialize frontend functionality
        new FrontendController();
    }

    /**
     * Get plugin configuration
     */
    public static function getConfig(string $key): string {
        return self::PLUGIN_CONFIG[$key] ?? '';
    }
}