<?php
/**
 * Analytics Dashboard View
 *
 * @var bool $is_pro Whether user has Pro license
 * @var array $data Analytics data (only for Pro users)
 */

defined('ABSPATH') || exit;

$upgrade_url = function_exists('intentdeep_vf_fs')
    ? intentdeep_vf_fs()->get_upgrade_url()
    : admin_url('edit.php?post_type=idep_virtual_file&page=intentdeep_vf_settings-pricing');
?>

<div class="wrap vf-analytics-wrap">
    <h1 class="vf-analytics-title">
        <span class="dashicons dashicons-chart-line"></span>
        <?php esc_html_e('File Analytics', 'intentdeep-virtual-files'); ?>
    </h1>

    <?php if (!$is_pro): ?>
        <!-- Pro Upgrade Banner for Free Users -->
        <div class="vf-pro-banner">
            <div class="vf-pro-banner-content">
                <div class="vf-pro-banner-icon">
                    <span class="dashicons dashicons-lock"></span>
                </div>
                <div class="vf-pro-banner-text">
                    <h2><?php esc_html_e('Unlock Powerful Analytics', 'intentdeep-virtual-files'); ?></h2>
                    <p><?php esc_html_e('Get detailed insights into your virtual files performance with Pro analytics features:', 'intentdeep-virtual-files'); ?></p>
                    <ul class="vf-pro-features-list">
                        <li><span class="dashicons dashicons-yes"></span> <?php esc_html_e('Real-time views tracking', 'intentdeep-virtual-files'); ?></li>
                        <li><span class="dashicons dashicons-yes"></span> <?php esc_html_e('Historical trends (30/60/90 days)', 'intentdeep-virtual-files'); ?></li>
                        <li><span class="dashicons dashicons-yes"></span> <?php esc_html_e('Top performing files', 'intentdeep-virtual-files'); ?></li>
                        <li><span class="dashicons dashicons-yes"></span> <?php esc_html_e('File type distribution', 'intentdeep-virtual-files'); ?></li>
                        <li><span class="dashicons dashicons-yes"></span> <?php esc_html_e('Hourly views breakdown', 'intentdeep-virtual-files'); ?></li>
                        <li><span class="dashicons dashicons-yes"></span> <?php esc_html_e('Beautiful interactive charts', 'intentdeep-virtual-files'); ?></li>
                    </ul>
                </div>
            </div>
            <div class="vf-pro-banner-cta">
                <a href="<?php echo esc_url($upgrade_url); ?>" class="button button-primary button-hero">
                    <?php esc_html_e('Upgrade to Pro', 'intentdeep-virtual-files'); ?>
                </a>
                <p class="vf-pro-banner-pricing">
                    <?php esc_html_e('Starting at $3.99/month', 'intentdeep-virtual-files'); ?>
                </p>
            </div>
        </div>

        <!-- Preview Screenshot (Blurred) -->
        <div class="vf-analytics-preview">
            <div class="vf-analytics-blur-overlay">
                <div class="vf-analytics-blur-message">
                    <span class="dashicons dashicons-lock"></span>
                    <h3><?php esc_html_e('Pro Feature', 'intentdeep-virtual-files'); ?></h3>
                    <p><?php esc_html_e('Upgrade to unlock analytics', 'intentdeep-virtual-files'); ?></p>
                    <a href="<?php echo esc_url($upgrade_url); ?>" class="button button-primary">
                        <?php esc_html_e('Get Pro', 'intentdeep-virtual-files'); ?>
                    </a>
                </div>

                <!-- Placeholder content (blurred) -->
                <div class="vf-analytics-placeholder">
                    <div class="vf-stats-grid">
                        <div class="vf-stat-card">
                            <div class="vf-stat-icon"><span class="dashicons dashicons-visibility"></span></div>
                            <div class="vf-stat-content">
                                <div class="vf-stat-value">12,345</div>
                                <div class="vf-stat-label"><?php esc_html_e('Total Views', 'intentdeep-virtual-files'); ?></div>
                            </div>
                        </div>
                        <div class="vf-stat-card">
                            <div class="vf-stat-icon"><span class="dashicons dashicons-chart-line"></span></div>
                            <div class="vf-stat-content">
                                <div class="vf-stat-value">+25%</div>
                                <div class="vf-stat-label"><?php esc_html_e('This Week', 'intentdeep-virtual-files'); ?></div>
                            </div>
                        </div>
                        <div class="vf-stat-card">
                            <div class="vf-stat-icon"><span class="dashicons dashicons-media-document"></span></div>
                            <div class="vf-stat-content">
                                <div class="vf-stat-value">8</div>
                                <div class="vf-stat-label"><?php esc_html_e('Active Files', 'intentdeep-virtual-files'); ?></div>
                            </div>
                        </div>
                        <div class="vf-stat-card">
                            <div class="vf-stat-icon"><span class="dashicons dashicons-star-filled"></span></div>
                            <div class="vf-stat-content">
                                <div class="vf-stat-value">1,542</div>
                                <div class="vf-stat-label"><?php esc_html_e('Avg Views/File', 'intentdeep-virtual-files'); ?></div>
                            </div>
                        </div>
                    </div>

                    <div class="vf-chart-card">
                        <div class="vf-chart-header">
                            <h3><?php esc_html_e('Views Over Time', 'intentdeep-virtual-files'); ?></h3>
                        </div>
                        <div class="vf-chart-placeholder"></div>
                    </div>
                </div>
            </div>
        </div>

    <?php else: ?>
        <!-- Pro User: Full Analytics Dashboard -->

        <!-- Date Range Filter -->
        <div class="vf-analytics-controls">
            <div class="vf-date-filter">
                <label for="vf-date-range"><?php esc_html_e('Date Range:', 'intentdeep-virtual-files'); ?></label>
                <select id="vf-date-range" class="vf-date-range-select">
                    <option value="7"><?php esc_html_e('Last 7 Days', 'intentdeep-virtual-files'); ?></option>
                    <option value="30" selected><?php esc_html_e('Last 30 Days', 'intentdeep-virtual-files'); ?></option>
                    <option value="60"><?php esc_html_e('Last 60 Days', 'intentdeep-virtual-files'); ?></option>
                    <option value="90"><?php esc_html_e('Last 90 Days', 'intentdeep-virtual-files'); ?></option>
                </select>
            </div>
            <div class="vf-analytics-refresh">
                <button type="button" id="vf-refresh-analytics" class="button">
                    <span class="dashicons dashicons-update"></span>
                    <span class="vf-button-text"><?php esc_html_e('Refresh', 'intentdeep-virtual-files'); ?></span>
                </button>
            </div>
        </div>

        <!-- Stats Grid -->
        <div class="vf-stats-grid">
            <div class="vf-stat-card">
                <div class="vf-stat-icon vf-stat-icon-primary">
                    <span class="dashicons dashicons-visibility"></span>
                </div>
                <div class="vf-stat-content">
                    <div class="vf-stat-value" id="vf-stat-total-views">
                        <?php echo isset($data['summary']['total_views']) ? esc_html(number_format_i18n($data['summary']['total_views'])) : '0'; ?>
                    </div>
                    <div class="vf-stat-label"><?php esc_html_e('Total Views', 'intentdeep-virtual-files'); ?></div>
                    <div class="vf-stat-meta">
                        <?php
                        if (isset($data['summary']['views_today'])) {
                            /* translators: %s: number of views today */
                            echo esc_html(sprintf(__('%s today', 'intentdeep-virtual-files'), number_format_i18n($data['summary']['views_today'])));
                        }
                        ?>
                    </div>
                </div>
            </div>

            <div class="vf-stat-card">
                <div class="vf-stat-icon vf-stat-icon-success">
                    <span class="dashicons dashicons-chart-line"></span>
                </div>
                <div class="vf-stat-content">
                    <div class="vf-stat-value" id="vf-stat-trend">
                        <?php
                        if (isset($data['summary']['trend_percentage'])) {
                            $trend = $data['summary']['trend_percentage'];
                            $trend_class = $trend >= 0 ? 'vf-trend-up' : 'vf-trend-down';
                            $trend_icon = $trend >= 0 ? '↑' : '↓';
                            echo '<span class="' . esc_attr($trend_class) . '">' . esc_html($trend_icon . abs($trend) . '%') . '</span>';
                        } else {
                            echo '0%';
                        }
                        ?>
                    </div>
                    <div class="vf-stat-label"><?php esc_html_e('7-Day Trend', 'intentdeep-virtual-files'); ?></div>
                    <div class="vf-stat-meta"><?php esc_html_e('vs previous period', 'intentdeep-virtual-files'); ?></div>
                </div>
            </div>

            <div class="vf-stat-card">
                <div class="vf-stat-icon vf-stat-icon-info">
                    <span class="dashicons dashicons-media-document"></span>
                </div>
                <div class="vf-stat-content">
                    <div class="vf-stat-value" id="vf-stat-active-files">
                        <?php echo isset($data['summary']['active_files']) ? esc_html($data['summary']['active_files']) : '0'; ?>
                    </div>
                    <div class="vf-stat-label"><?php esc_html_e('Active Files', 'intentdeep-virtual-files'); ?></div>
                    <div class="vf-stat-meta"><?php esc_html_e('serving content', 'intentdeep-virtual-files'); ?></div>
                </div>
            </div>

            <div class="vf-stat-card">
                <div class="vf-stat-icon vf-stat-icon-warning">
                    <span class="dashicons dashicons-star-filled"></span>
                </div>
                <div class="vf-stat-content">
                    <div class="vf-stat-value" id="vf-stat-avg-views">
                        <?php echo isset($data['summary']['average_views_per_file']) ? esc_html(number_format_i18n($data['summary']['average_views_per_file'], 1)) : '0'; ?>
                    </div>
                    <div class="vf-stat-label"><?php esc_html_e('Avg Views/File', 'intentdeep-virtual-files'); ?></div>
                    <div class="vf-stat-meta">
                        <?php
                        if (isset($data['summary']['most_viewed_file']['filename'])) {
                            /* translators: %s: filename */
                            echo esc_html(sprintf(__('Top: %s', 'intentdeep-virtual-files'), $data['summary']['most_viewed_file']['filename']));
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Views Timeline Chart -->
        <div class="vf-chart-card">
            <div class="vf-chart-header">
                <h3><?php esc_html_e('Views Over Time', 'intentdeep-virtual-files'); ?></h3>
                <div class="vf-chart-legend" id="vf-timeline-legend"></div>
            </div>
            <div id="vf-timeline-chart" class="vf-chart-container"></div>
        </div>

        <!-- Two Column Layout -->
        <div class="vf-analytics-row">
            <!-- Top Files Table -->
            <div class="vf-chart-card vf-chart-card-half">
                <div class="vf-chart-header">
                    <h3><?php esc_html_e('Top 5 Files', 'intentdeep-virtual-files'); ?></h3>
                </div>
                <div class="vf-top-files-table">
                    <table class="wp-list-table widefat fixed striped">
                        <thead>
                            <tr>
                                <th><?php esc_html_e('Rank', 'intentdeep-virtual-files'); ?></th>
                                <th><?php esc_html_e('Filename', 'intentdeep-virtual-files'); ?></th>
                                <th><?php esc_html_e('Views', 'intentdeep-virtual-files'); ?></th>
                                <th><?php esc_html_e('Last Accessed', 'intentdeep-virtual-files'); ?></th>
                            </tr>
                        </thead>
                        <tbody id="vf-top-files-tbody">
                            <?php if (isset($data['topFiles']) && !empty($data['topFiles'])): ?>
                                <?php foreach ($data['topFiles'] as $index => $file): ?>
                                    <tr>
                                        <td class="vf-rank">
                                            <span class="vf-rank-badge vf-rank-<?php echo esc_attr($index + 1); ?>">
                                                #<?php echo esc_html($index + 1); ?>
                                            </span>
                                        </td>
                                        <td class="vf-filename">
                                            <a href="<?php echo esc_url(admin_url('post.php?post=' . $file['id'] . '&action=edit')); ?>">
                                                <?php echo esc_html($file['filename']); ?>
                                            </a>
                                            <div class="vf-file-meta">
                                                <span class="vf-mime-type"><?php echo esc_html($file['mime_type']); ?></span>
                                            </div>
                                        </td>
                                        <td class="vf-views">
                                            <strong><?php echo esc_html(number_format_i18n($file['views'])); ?></strong>
                                        </td>
                                        <td class="vf-last-accessed">
                                            <?php
                                            if (!empty($file['last_accessed'])) {
                                                echo esc_html(human_time_diff(strtotime($file['last_accessed']), current_time('timestamp'))) . ' ' . esc_html__('ago', 'intentdeep-virtual-files');
                                            } else {
                                                echo esc_html__('Never', 'intentdeep-virtual-files');
                                            }
                                            ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="4" class="vf-no-data">
                                        <?php esc_html_e('No data available. Views will appear here once your files are accessed.', 'intentdeep-virtual-files'); ?>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- File Type Distribution Chart -->
            <div class="vf-chart-card vf-chart-card-half">
                <div class="vf-chart-header">
                    <h3><?php esc_html_e('File Type Distribution', 'intentdeep-virtual-files'); ?></h3>
                </div>
                <div id="vf-filetype-chart" class="vf-chart-container vf-chart-donut"></div>
            </div>
        </div>

        <!-- Hourly Views Chart -->
        <div class="vf-chart-card">
            <div class="vf-chart-header">
                <h3><?php esc_html_e('Today\'s Hourly Views', 'intentdeep-virtual-files'); ?></h3>
                <div class="vf-chart-meta"><?php echo esc_html(date_i18n(get_option('date_format'), current_time('timestamp'))); ?></div>
            </div>
            <div id="vf-hourly-chart" class="vf-chart-container"></div>
        </div>

    <?php endif; ?>
</div>
