<?php
namespace IntentDeep\VirtualFiles\Traits;

/**
 * Helper trait for file statistics and counting
 */
trait FileStatsHelper {

    /**
     * Get total file count (active and inactive)
     */
    private function getTotalFileCount(): int {
        $files = get_posts([
            'post_type' => 'idep_virtual_file',
            'posts_per_page' => -1,
            'post_status' => 'any',
        ]);

        return count($files);
    }

    /**
     * Get maximum allowed files based on user license
     * Returns a display string ("Unlimited" or number) for UI display
     */
    private function getMaxFilesDisplay() {
        // If user is pro, return unlimited
        if (function_exists('intentdeep_vf_fs') && intentdeep_vf_fs()->can_use_premium_code__premium_only()) {
            return __('∞', 'intentdeep-virtual-files');
        }

        // Free users always have a fixed limit of 5 files
        return 5;
    }
}
