<?php

/**
 * Event Lists Template
 */

if (defined('REST_REQUEST') && REST_REQUEST) {
    $imgurl = ITSP_INTEGRATION__PLUGIN_URL . '/assets/placeholders/event.png';
    echo '<img src=' . $imgurl . '  width="100%">';
} else {
    $evtdata = '';
    $lstupmillisec = '';
    $start = round(microtime(true) * 1000);

    $ids = implode(",", $selectdeals);
    $results = Itsp_Utility::static_products($ids);
    //    $results->data[1] = $results->data[0];
    //    $results->data[2] = $results->data[0];
    //    $results->data[3] = $results->data[0];
    //    $results->data[4] = $results->data[0];

    $redofcolumn = isset($instance['redofcolumn']) ? $instance['redofcolumn'] : 'popup';
    $uid = isset($args['widget_id']) ? $args['widget_id'] : '';
?>
    <div class="itsp_is_events_list <?php echo esc_attr($uid); ?>">
        <div class="itsp_list_main_block <?php echo esc_attr($uid); ?>-row">
            <?php
            if (!isset($results->code) && count($results->data)) {
                $ij = 0;
                foreach ($results->data as $key => $value) {
                    $ij++;
                    if ($ij > $lytlimit)
                        break;
                    $lstupmillisec = isset($value->lastUpdated->millisec) ? $value->lastUpdated->millisec : "";
                    $dsc = isset($value->body_html) ? $value->body_html : "unknown Desc";
                    $title = (isset($value->title) && $value->title != '') ? $value->title : "unknown title";
                    $minimumInvestmentByInvestor = (isset($value->custom_data->offer_data->minimumInvestmentByInvestor) && $value->custom_data->offer_data->minimumInvestmentByInvestor != '') ? $value->custom_data->offer_data->minimumInvestmentByInvestor : "unknown Investment";
                    $currency = (isset($value->custom_data->entity->currency) && $value->custom_data->entity->currency != '') ? $value->custom_data->entity->currency : "unknown currency";
                    $sponsor_name = (isset($value->custom_data->sponsor->name) && $value->custom_data->sponsor->name != '') ? $value->custom_data->sponsor->name : "sponsor Name";
                    $entity_location = (isset($value->custom_data->entity->city) && $value->custom_data->entity->city != '') ? $value->custom_data->entity->city : "city Name";
                    $investment_sum = (isset($value->custom_data->investment_sum) && $value->custom_data->investment_sum != '') ? $value->custom_data->investment_sum : 0;
                    $investment_count = (isset($value->custom_data->investment_count) && $value->custom_data->investment_count != '') ? $value->custom_data->investment_count : 0;
                    $fundraisingCloseDate = (isset($value->custom_data->offer_data->fundraisingCloseDate) && $value->custom_data->offer_data->fundraisingCloseDate != '') ? $value->custom_data->offer_data->fundraisingCloseDate : 0;
                    $cclayout = (isset($instance['cclayout'])) ? $instance['cclayout'] : '';
                    $name = (isset($value->custom_data->offer_data->name) && $value->custom_data->offer_data->name != '') ? $value->custom_data->offer_data->name : "unknown name";
                    $minimumTargetIRR = (isset($value->custom_data->offer_data->minimumTargetIRR) && $value->custom_data->offer_data->minimumTargetIRR != '') ? $value->custom_data->offer_data->minimumTargetIRR : "unknown name";
                    $maximumTargetIRR = (isset($value->custom_data->offer_data->maximumTargetIRR) && $value->custom_data->offer_data->maximumTargetIRR != '') ? $value->custom_data->offer_data->maximumTargetIRR : "unknown name";
                    $imgurl = isset($value->image->src) ? preg_replace("(^https?://)", "", $value->image->src) : "";
                    $url = isset($value->permalink) ? preg_replace("(^http?://)", "", $value->permalink) : "";
                    $amount = (isset($value->custom_data->offer_data->amount) && $value->custom_data->offer_data->amount != '') ? $value->custom_data->offer_data->amount : "unknown name";
                    $dealStructure = (isset($value->custom_data->offer_data->dealStructure) && $value->custom_data->offer_data->dealStructure != '') ? $value->custom_data->offer_data->dealStructure : "unknown dealStructures";
                    $investmentModel = (isset($value->custom_data->offer_data->investmentModel) && $value->custom_data->offer_data->investmentModel != '') ? $value->custom_data->offer_data->investmentModel : "unknown investmentModel";
                    $type = (isset($value->custom_data->assets->type) && $value->custom_data->assets->type != '') ? $value->custom_data->assets->type : "unknown investmentModel";
                    $USRegion = (isset($value->custom_data->assets->USRegion) && $value->custom_data->assets->USRegion != '') ? $value->custom_data->assets->USRegion : "unknown investmentModel";

                    $percentageRaised = ($investment_sum / $amount) * 100;
                    $sold_out = "Keep Going!";
                    if ($percentageRaised >= 90) {
                        $sold_out = "Almost Sold Out!";
                    }

                    $currentDate = new DateTime();

                    // Create a DateTime object from the fundraising close date
                    $closeDate = new DateTime($fundraisingCloseDate);

                    // Calculate the difference between the two dates
                    $interval = $currentDate->diff($closeDate);

                    // Get the number of days remaining
                    $daysLeft = $interval->days;

                    // Check if the fundraising close date is in the future and set the message in one variable
                    $fundayleft_message = ($currentDate < $closeDate) ? "$daysLeft Days Left" : "Fundraising Closed";
            ?>
                    <div class="itsp_is_engage_list itsp_event_list" style="border-width: <?php echo esc_attr($brandkit_colorpalette['borderWidth']); ?>;border-color: <?php echo esc_attr($brandkit_colorpalette['borderColor']); ?>;">
                        <div class="itsp_is_list_img">
                            <?php
                            if (isset($redofcolumn) && ($redofcolumn == "redirect")) { ?>
                                <a target="_blank" class="<?php print $uniq_pop; ?>" href=<?php echo esc_url($url); ?> style="font-family:<?php echo esc_attr($brandkit_fontinfo['fontFamily']); ?>;">
                                    <img src="//<?php print $imgurl; ?>" alt="">
                                </a>
                            <?php } else { ?>
                                <a class="itsp_events_pop <?php print $uniq_pop; ?>" href=<?php echo esc_url($url); ?> style="font-family:<?php echo esc_attr($brandkit_fontinfo['fontFamily']); ?>;">
                                    <img src="//<?php print $imgurl; ?>" alt="">
                                </a>
                            <?php } ?>
                            <div class="itsp_product_offer_label">
                                <span class="itsp_product_offer_symbol">New</span>
                            </div>
                            <div class="progressBarSection" style="display: flex; flex-direction: column; align-items: center; justify-content: center; padding: 15px 0px;">
                                <div style="display: flex; flex-direction: row; width: 90%; justify-content: space-between; align-items: center;">
                                        <!-- <p class="itsp_format_currency"><?php echo $currency . ' ' . $investment_sum; ?></p>
                                        <p class="itsp_bar_investment_status"><?php echo $sold_out; ?></p> -->
                                        <p style="color: #000000; font-size: <?php echo esc_attr($brandkit_fontinfo['p']); ?>">Goal: $5000</p>
                                </div>
                                <div style="width: 95%; padding: 5px 10px; background: <?php echo esc_attr($brandkit_colorpalette['secondaryBackgroundColor']); ?>; border-radius: 13px; ">
                                        <progress id="file" value="<?php echo $percentageRaised; ?>" max="100" style="width: 100%;"> <?php echo $percentageRaised; ?>% </progress>
                                        <div style="display: flex; flex-direction: row; width: 100%; justify-content: space-between; align-items: center;">
                                            <!-- <p style="color:#000000; margin-bottom: 0 !important; font-size: <?php echo esc_attr($brandkit_fontinfo['p']); ?>"><?php echo $investment_count; ?> Investors</p>
                                            <p style="color:#000000; margin-bottom: 0 !importants; font-size: <?php echo esc_attr($brandkit_fontinfo['p']); ?>"><?php echo $fundayleft_message; ?></p> -->
                                            <p style="color:<?php echo esc_attr($brandkit_colorpalette['primaeyColor']); ?>; margin-bottom: 0 !important; font-size: <?php echo esc_attr($brandkit_fontinfo['p']); ?>">Invested- $0 (0%)</p>
                                            <p style="color:<?php echo esc_attr($brandkit_colorpalette['secondaryColor']); ?>; margin-bottom: 0 !importants; font-size: <?php echo esc_attr($brandkit_fontinfo['p']); ?>">Committed- $0 (0%)</p>
                                        </div>
                                </div>
                            </div>

                        </div>
                        <div class="itsp_is_list_description itsp_caption">
                            <div class="itsp_contant_section">

                                <h2 style="font-size: <?php echo esc_attr($brandkit_fontinfo['h2']); ?>;">
                                    <?php echo sanitize_text_field($title); ?>
                                </h2>
                                <div>
                                    <p class="itsp_offer_description"><?php echo strip_tags(html_entity_decode($dsc)); ?></p>
                                </div>
                                <div class="offerDetaisSection" style="margin-bottom: 20px;">
                                    <div style="display: flex; flex-direction: row; flex-wrap: nowrap; width: 100%;">
                                        <span style="width: 50%; font-weight: 800; padding-top: 15px; color: #000000; font-size: <?php echo esc_attr($brandkit_fontinfo['h3']); ?>;">Property Name</span>
                                        <span style="width: 50%; padding-top: 15px; color: #000000; font-size: <?php echo esc_attr($brandkit_fontinfo['h3']); ?>;"><?php echo $name; ?></span>
                                    </div>
                                    <div style="display: flex; flex-direction: row; flex-wrap: nowrap; width: 100%;">
                                        <span style="width: 50%; font-weight: 800; padding-top: 15px; color: #000000; font-size: <?php echo esc_attr($brandkit_fontinfo['h3']); ?>;">Sponsor</span>
                                        <span style="width: 50%; padding-top: 15px; color: #000000; font-size: <?php echo esc_attr($brandkit_fontinfo['h3']); ?>;"><?php echo $sponsor_name; ?></span>
                                    </div>
                                    <div style="display: flex; flex-direction: row; flex-wrap: nowrap; width: 100%;">
                                        <span style="width: 50%; font-weight: 800; padding-top: 15px; color: #000000; font-size: <?php echo esc_attr($brandkit_fontinfo['h3']); ?>;">Location</span>
                                        <span style="width: 50%; padding-top: 15px; color: #000000; font-size: <?php echo esc_attr($brandkit_fontinfo['h3']); ?>;"><?php echo $entity_location; ?></span>
                                    </div>
                                    <div style="display: flex; flex-direction: row; flex-wrap: nowrap; width: 100%;">
                                        <span style="width: 50%; font-weight: 800; padding-top: 15px; color: #000000; font-size: <?php echo esc_attr($brandkit_fontinfo['h3']); ?>;">Target IRR</span>
                                        <span style="width: 50%; padding-top: 15px; color: #000000; font-size: <?php echo esc_attr($brandkit_fontinfo['h3']); ?>;"><?php echo $minimumTargetIRR . '% - ' . $maximumTargetIRR . '%'; ?></span>
                                    </div>
                                    <div style="display: flex; flex-direction: row; flex-wrap: nowrap; width: 100%;">
                                        <span style="width: 50%; font-weight: 800; padding-top: 15px; color: #000000; font-size: <?php echo esc_attr($brandkit_fontinfo['h3']); ?>;"> Min Investment </span>
                                        <span style="width: 50%; padding-top: 15px; color: #000000; font-size: <?php echo esc_attr($brandkit_fontinfo['h3']); ?>;"><?php echo $currency . '' . $minimumInvestmentByInvestor; ?> </span>
                                    </div>
                                    <div class="itsp_card_tags">
                                        <p><?php echo $dealStructure; ?></p>
                                        <p><?php echo $investmentModel; ?></p>
                                        <p><?php echo $type; ?> </p>
                                        <p><?php echo $USRegion; ?> </p>
                                    </div>
                                </div>

                                <h4 class="itsp_address itsp_cta" style="color:<?php echo esc_attr($brandkit_colorpalette['secondaryTextColor']); ?>;background:<?php echo esc_attr($brandkit_colorpalette['buttonBackgroundColor']); ?>; font-size: <?php echo esc_attr($brandkit_fontinfo['p']); ?>; font-family: <?php echo esc_attr($brandkit_fontinfo['fontFamily']); ?>;line-height: <?php echo esc_attr($brandkit_fontinfo['lineHeight']); ?>;">
                                    <?php if (isset($redofcolumn) && ($redofcolumn == "redirect")) { ?>
                                        <a class="<?php echo esc_attr($uniq_pop); ?>" target="_blank" href=<?php echo esc_url($url); ?> style="color:<?php echo esc_attr($brandkit_colorpalette['buttonTextColor']); ?>;font-family: <?php echo esc_attr($brandkit_fontinfo['fontFamily']); ?>;"> View Details</a>
                                    <?php } else { ?>
                                        <a class="itsp_events_pop <?php echo esc_attr($uniq_pop); ?> trackablebtn" href=<?php echo esc_url($url); ?> style="color:<?php echo esc_attr($brandkit_colorpalette['buttonTextColor']); ?>;font-family: <?php echo esc_attr($brandkit_fontinfo['fontFamily']); ?>;"> View Details </a>
                                    <?php } ?>
                                </h4>
                                <!-- CALCULATE BUTTON   -->
                                <?php if (isset($cclayout) && $cclayout == "yes") { ?>
                                    <h4 class="itsp_address itsp_cta" style="margin-top: 10px !important;color:<?php echo esc_attr($brandkit_colorpalette['secondaryTextColor']); ?>;background:<?php echo esc_attr($brandkit_colorpalette['secondaryButtonBackgroundColor']); ?>; font-size: <?php echo esc_attr($brandkit_fontinfo['p']); ?>; font-family: <?php echo esc_attr($brandkit_fontinfo['fontFamily']); ?>;line-height: <?php echo esc_attr($brandkit_fontinfo['lineHeight']); ?>;">

                                        <a class="itsp_calculator_pop trackablebtn" style="color:<?php echo esc_attr($brandkit_colorpalette['buttonTextColor']); ?>;font-family: <?php echo esc_attr($brandkit_fontinfo['fontFamily']); ?>; cursor: pointer;" total_investment="<?php echo $minimumInvestmentByInvestor; ?>" total_irr="<?php echo $minimumTargetIRR; ?>" font-size-p="<?php echo esc_attr($brandkit_fontinfo['p']); ?>;" font-size-h2="<?php echo esc_attr($brandkit_fontinfo['h2']); ?>;" primaryColor="<?php echo esc_attr($brandkit_colorpalette['primaryColor']); ?>" secondaryColor="<?php echo esc_attr($brandkit_colorpalette['secondaryColor']); ?>" currency="<?php echo $currency; ?>" fontinfoh2="<?php echo esc_attr($brandkit_fontinfo['h2']); ?>">Calculate</a>
                                    </h4>
                                <?Php } ?>

                            </div>
                        </div>
                    </div>
                <?php
                }
            }
            if (!isset($results->code) && count($results->data)) {
                ?>
                <div class="itsp_is_events_list_id <?php echo esc_attr($uid); ?>-id" data-last-update="<?php echo esc_attr($lstupmillisec); ?>" data-lytlimit="<?php echo esc_attr($lytlimit); ?>" data-load="<?php echo esc_attr($ij); ?>"> </div>
            <?php } ?>
        </div>
    </div>

<?php } ?>

<style>
    .itsp_is_engage_list {
        border: none;
        background: none;
        box-shadow: 0px 2.83px 16.96px 0px #0000001A;
    }

    .itsp_is_list_description {
        margin-left: 5rem;
        margin-right: 3rem;
        text-align: start;
        display: flex;
        align-items: center;
    }

    .itsp_product_offer_label {
        position: absolute;
        top: 0px;
        clip-path: polygon(0 0, 0 100%, 100% 0);
        width: 100px;
        height: 100px;
        background-color: <?php echo esc_attr($brandkit_colorpalette['secondaryColor']); ?>;
    }

    .itsp_format_currency {
        color: <?php echo esc_attr($brandkit_colorpalette['primaryColor']); ?>;
        font-size: <?php echo esc_attr($brandkit_fontinfo['h3']); ?>;
        margin-top: 3px;
        margin-bottom: 0px !important;
    }

    .itsp_bar_investment_status {
        color: #ffffff;
        background: <?php echo esc_attr($brandkit_colorpalette['warningColor']); ?>;
        padding: 5px;
        font-size: <?php echo esc_attr($brandkit_fontinfo['p']); ?>;
        border-radius: 5px;
        margin-top: 3px;
        margin-bottom: 0px !important;
    }

    .itsp_product_offer_symbol {
        rotate: 314deg;
        position: absolute;
        top: 15px;
        bottom: 10px;
        left: 30px;
        color: #FFFFFF;
        max-width: 200px;
        font-size: <?php echo esc_attr($brandkit_fontinfo['p']); ?>;
    }

    .itsp_offer_description {
        font-size: <?php echo esc_attr($brandkit_fontinfo['p']); ?>;
        color: #000000;
        text-align: left;
        overflow: hidden;
        text-overflow: ellipsis;
        display: -webkit-box;
        -webkit-line-clamp: 3;
        line-clamp: 3;
        -webkit-box-orient: vertical;
    }

    .itsp_is_list_img {
        position: relative;
        display: flex;
        flex-direction: column;
    }

    .itsp_is_list_img img {
        height: 100%;
    }

    .itsp_cta {
        min-height: auto;
    }

    .itsp_contant_section h4 {
        margin: auto !important;
        width: 100%;
        border-radius: 10px;
    }

    .itsp_card_tags {
        display: flex;
        flex-wrap: wrap;
    }

    .itsp_card_tags p {
        padding: 5px;
        font-size: <?php echo esc_attr($brandkit_fontinfo['p']); ?>;
        color: #000000;
        background: <?php echo esc_attr($brandkit_colorpalette['secondaryBackgroundColor']); ?>;
        margin: 5px;
        border-radius: 5px;
    }

    /* calculater Range bar */
    .itsp_prise_range {
        -webkit-appearance: none;
        /* Required for custom styling */
        appearance: none;
        /* For standardization */
        width: 100% !important;
        background: #DEB4B5;
        border-radius: 5px;
        outline: none;
    }

    .itsp_prise_range::-webkit-slider-thumb {
        -webkit-appearance: none;
        /* Required for thumb customization */
        width: 15px;
        height: 15px;
        background: #aa3c3e;
        /* Replace with PHP output if needed */
        border-radius: 50%;
        cursor: pointer;
        box-shadow: 0 0 5px rgba(0, 0, 0, 0.5);
    }

    .itsp_prise_range::-moz-range-thumb {
        width: 15px;
        height: 15px;
        background: #aa3c3e;
        border-radius: 50%;
        cursor: pointer;
        box-shadow: 0 0 5px rgba(0, 0, 0, 0.5);
    }

    .itsp_prise_range::-ms-thumb {
        width: 15px;
        height: 15px;
        background: #aa3c3e;
        border-radius: 50%;
        cursor: pointer;
        box-shadow: 0 0 5px rgba(0, 0, 0, 0.5);
    }

    @media (max-width: 767px) {
        .itsp_is_list_description {
            margin-left: 10px;
            margin-right: 10px;
        }
    }

    .progressBarSection p {
        margin-bottom: 5px !important;
    }
</style>
