<?php

/**
 * Product Grids
 */
if (defined('REST_REQUEST') && REST_REQUEST) {
    $imgurl = ITSP_INTEGRATION__PLUGIN_URL . '/assets/placeholders/event.png';
    echo '<img src=' . $imgurl . '  width="100%">';
} else {
    $start = round(microtime(true) * 1000);

    $ids = implode(",", $selectdeals);
    $results = Itsp_Utility::static_products($ids);
    //    $results->data[1] = $results->data[0];
    //    $results->data[2] = $results->data[0];
    //    $results->data[3] = $results->data[0];
    //    $results->data[4] = $results->data[0];

    #$total_offers_count = count($results->data);
    $evtdata = '';
    $nbrofcolumn = isset($instance['nbrofcolumn']) ? $instance['nbrofcolumn'] : '';
    $redofcolumn = isset($instance['redofcolumn']) ? $instance['redofcolumn'] : 'popup';
    $lytlimit = (isset($instance['lytlimit'])) ? $instance['lytlimit'] : '';
    $cclayout = (isset($instance['cclayout'])) ? $instance['cclayout'] : '';
    if (!isset($results->code) && isset($results->data) && count($results->data)) {
        $wgtid = isset($args['widget_id']) ? $args['widget_id'] : '';
?>
        <div class="itsp_is_events_grid itsp_event-grid  <?php echo esc_attr($wgtid); ?>  ">
            <div class="itsp_is_events_grid_row <?php echo esc_attr($wgtid); ?>-row">
                <?php
                $lstupmillisec = '';
                $i = 0;
                foreach ($results->data as $key => $value) {
                    $i++;
                    if ($i > $lytlimit)
                        break;
                    $side_by_side = '';
                    if ($nbrofcolumn == 100) {
                        $side_by_side = "itsp_side_by_side_event";
                    }
                    if ($nbrofcolumn == 25) {
                        $side_by_side = "itsp_fourSection_blocks";
                    }

                    $lstupmillisec = round(microtime(true) * 1000);
                    $dsc = isset($value->body_html) ? $value->body_html : "unknown Desc";
                    $title = (isset($value->title) && $value->title != '') ? $value->title : "unknown title";
                    $minimumInvestmentByInvestor = (isset($value->custom_data->offer_data->minimumInvestmentByInvestor) && $value->custom_data->offer_data->minimumInvestmentByInvestor != '') ? $value->custom_data->offer_data->minimumInvestmentByInvestor : "unknown Investment";
                    $currency = (isset($value->custom_data->entity->currency) && $value->custom_data->entity->currency != '') ? $value->custom_data->entity->currency : "unknown currency";
                    $currency = ($currency == 'USD') ? '$' : $currency;
                    $sponsor_name = (isset($value->custom_data->sponsor->name) && $value->custom_data->sponsor->name != '') ? $value->custom_data->sponsor->name : "sponsor Name";
                    $entity_location = (isset($value->custom_data->entity->city) && $value->custom_data->entity->city != '') ? $value->custom_data->entity->city : "city Name";
                    $investment_sum = (isset($value->custom_data->investment_sum) && $value->custom_data->investment_sum != '') ? $value->custom_data->investment_sum : 0;
                    $upfront_sum = (isset($value->custom_data->upfront_sum) && $value->custom_data->upfront_sum != '') ? $value->custom_data->upfront_sum : $investment_sum;
                    
                    $investment_count = (isset($value->custom_data->investment_count) && $value->custom_data->investment_count != '') ? $value->custom_data->investment_count : 0;
                    $fundraisingCloseDate = (isset($value->custom_data->offer_data->fundraisingCloseDate) && $value->custom_data->offer_data->fundraisingCloseDate != '') ? $value->custom_data->offer_data->fundraisingCloseDate : 0;

                    $name = (isset($value->custom_data->offer_data->name) && $value->custom_data->offer_data->name != '') ? $value->custom_data->offer_data->name : "unknown name";
                    $invested_capital = (isset($value->custom_data->offer_data->investedCapital) && $value->custom_data->offer_data->investedCapital != '') ? $value->custom_data->offer_data->investedCapital : 0;
                    $total_committed_capital = (isset($value->custom_data->offer_data->totalCommittedCapital) && $value->custom_data->offer_data->totalCommittedCapital != '') ? $value->custom_data->offer_data->totalCommittedCapital : 0;
                    #var_dump($total_committed_capital);
                    #var_dump($value->custom_data->offer_data->invested_capital);
                    $minimumTargetIRR = (isset($value->custom_data->offer_data->minimumTargetIRR) && $value->custom_data->offer_data->minimumTargetIRR != '') ? $value->custom_data->offer_data->minimumTargetIRR : "unknown name";
                    $maximumTargetIRR = (isset($value->custom_data->offer_data->maximumTargetIRR) && $value->custom_data->offer_data->maximumTargetIRR != '') ? $value->custom_data->offer_data->maximumTargetIRR : "unknown name";
                    $imgurl = isset($value->image->src) ? preg_replace("(^https?://)", "", $value->image->src) : "";
                    $url = isset($value->permalink) ? preg_replace("(^http?://)", "", $value->permalink) : "";
                    $amount = (isset($value->custom_data->offer_data->amount) && $value->custom_data->offer_data->amount != '') ? $value->custom_data->offer_data->amount : "unknown name";
                    $dealStructure = (isset($value->custom_data->offer_data->dealStructure) && $value->custom_data->offer_data->dealStructure != '') ? $value->custom_data->offer_data->dealStructure : "unknown dealStructures";
                    $investmentModel = (isset($value->custom_data->offer_data->investmentModel) && $value->custom_data->offer_data->investmentModel != '') ? $value->custom_data->offer_data->investmentModel : "unknown investmentModel";
                    $type = (isset($value->custom_data->assets->type) && $value->custom_data->assets->type != '') ? $value->custom_data->assets->type : "unknown investmentModel";
                    $USRegion = (isset($value->custom_data->assets->USRegion) && $value->custom_data->assets->USRegion != '') ? $value->custom_data->assets->USRegion : "unknown investmentModel";
                    $invested =  $invested_capital+ $upfront_sum;
                    $committed = $total_committed_capital+ $investment_sum;
                    $invested_percentage = ($invested / $amount) * 100;
                    $committed_percentage = ($committed / $amount) * 100;
                    $sold_out = "Keep Going!";
                    // if ($percentageRaised >= 90) {
                    //     $sold_out = "Almost Sold Out!";
                    // }

                    $currentDate = new DateTime();

                    // Create a DateTime object from the fundraising close date
                    $closeDate = new DateTime($fundraisingCloseDate);

                    // Calculate the difference between the two dates
                    $interval = $currentDate->diff($closeDate);

                    // Get the number of days remaining
                    $daysLeft = $interval->days;

                    // Check if the fundraising close date is in the future and set the message in one variable
                    $fundayleft_message = ($currentDate < $closeDate) ? "$daysLeft Days Left" : "Fundraising Closed";


                ?>
                    <div class="itsp_engage_grid_block itsp_overall_productblock <?php echo esc_attr($side_by_side); ?>" style="color:<?php echo esc_attr($brandkit_colorpalette['primaryColor']); ?>; max-width:<?php echo esc_attr($nbrofcolumn); ?>%; display: flex; ">
                        <div class="itsp_native_product itsp_native_product_style" style="border-width:<?php echo esc_attr($brandkit_colorpalette['borderWidth']); ?>; border-color:<?php echo esc_attr($brandkit_colorpalette['borderColor']); ?>;">
                            <div class="gridImage_section" style="position: relative;">
                                <img src="//<?php print $imgurl; ?>">
                                
                                <h2 style="font-size: <?php echo esc_attr($brandkit_fontinfo['h2']); ?>; padding: 10px 20px; margin: 0; background: #ffffff;">
                                    <?php echo sanitize_text_field($title); ?>
                                </h2>

                                


                                <div class="itsp_contant_section">

                                    <div>
                                        <p class="itsp_offer_description"><?php echo strip_tags(html_entity_decode($dsc)); ?></p>
                                    </div>
                                    <div class="itsp_offer_details_section">
                                        
                                        <div style="display: flex; flex-direction: row; flex-wrap: nowrap; width: 100%;">
                                            <span style="width: 50%; font-weight: 800; padding-top: 15px; color: #000000; font-size: <?php echo esc_attr($brandkit_fontinfo['h3']); ?>;">Sponsor</span>
                                            <span style="width: 50%; padding-top: 15px; color: #000000; font-size: <?php echo esc_attr($brandkit_fontinfo['h3']); ?>;"><?php echo $sponsor_name; ?></span>
                                        </div>
                                        <div style="display: flex; flex-direction: row; flex-wrap: nowrap; width: 100%;">
                                            <span style="width: 50%; font-weight: 800; padding-top: 15px; color: #000000; font-size: <?php echo esc_attr($brandkit_fontinfo['h3']); ?>;">Location</span>
                                            <span style="width: 50%; padding-top: 15px; color: #000000; font-size: <?php echo esc_attr($brandkit_fontinfo['h3']); ?>;"><?php echo $entity_location; ?></span>
                                        </div>
                                        <div style="display: flex; flex-direction: row; flex-wrap: nowrap; width: 100%;">
                                            <span style="width: 50%; font-weight: 800; padding-top: 15px; color: #000000; font-size: <?php echo esc_attr($brandkit_fontinfo['h3']); ?>;">Target IRR</span>
                                            <span style="width: 50%; padding-top: 15px; color: #000000; font-size: <?php echo esc_attr($brandkit_fontinfo['h3']); ?>;"><?php echo $minimumTargetIRR . '% - ' . $maximumTargetIRR . '%'; ?></span>
                                        </div>
                                        <div style="display: flex; flex-direction: row; flex-wrap: nowrap; width: 100%;">
                                            <span style="width: 50%; font-weight: 800; padding-top: 15px; color: #000000; font-size: <?php echo esc_attr($brandkit_fontinfo['h3']); ?>;"> Min Investment </span>
                                            <span style="width: 50%; padding-top: 15px; color: #000000; font-size: <?php echo esc_attr($brandkit_fontinfo['h3']); ?>;"><?php echo $currency . '' . number_format($minimumInvestmentByInvestor); ?> </span>
                                        </div>
                                    </div>
                                    <div class="itsp_card_tags">
                                        <p><?php echo $dealStructure; ?></p>
                                        <p><?php echo $investmentModel; ?></p>
                                        <p><?php echo $type; ?> </p>
                                        <p><?php echo $USRegion; ?> </p>
                                    </div>
                                </div>
                            </div>

                            <div class="itsp_caption">

                                <div class="itsp_contant_section">


                                    <div class="itsp_offercard_button_grid">
                                        <h4 class="itsp_address itsp_cta" style="color:<?php echo esc_attr($brandkit_colorpalette['secondaryTextColor']); ?>;background:<?php echo esc_attr($brandkit_colorpalette['buttonBackgroundColor']); ?>; font-size: <?php echo esc_attr($brandkit_fontinfo['p']); ?>; font-family: <?php echo esc_attr($brandkit_fontinfo['fontFamily']); ?>;line-height: <?php echo esc_attr($brandkit_fontinfo['lineHeight']); ?>;">
                                            <?php if (isset($redofcolumn) && ($redofcolumn == "redirect")) { ?>
                                                <a class="<?php echo esc_attr($uniq_pop); ?>" target="_blank" href=<?php echo esc_url($url); ?> style="color:<?php echo esc_attr($brandkit_colorpalette['buttonTextColor']); ?>;font-family: <?php echo esc_attr($brandkit_fontinfo['fontFamily']); ?>;"> View Details</a>
                                            <?php } else { ?>
                                                <a class="itsp_events_pop <?php echo esc_attr($uniq_pop); ?> trackablebtn" href=<?php echo esc_url($url); ?> style="color:<?php echo esc_attr($brandkit_colorpalette['buttonTextColor']); ?>;font-family: <?php echo esc_attr($brandkit_fontinfo['fontFamily']); ?>;"> View Details</a>
                                            <?php } ?>
                                        </h4>
                                        <!-- CALCULATE BUTTON   -->
                                        <?php if (isset($cclayout) && $cclayout == "yes") { ?>
                                            <h4 class="itsp_address itsp_cta" style="color:<?php echo esc_attr($brandkit_colorpalette['secondaryTextColor']); ?>;background:<?php echo esc_attr($brandkit_colorpalette['secondaryButtonBackgroundColor']); ?>; font-size: <?php echo esc_attr($brandkit_fontinfo['p']); ?>; font-family: <?php echo esc_attr($brandkit_fontinfo['fontFamily']); ?>;line-height: <?php echo esc_attr($brandkit_fontinfo['lineHeight']); ?>;">

                                                <a class="itsp_calculator_pop trackablebtn" style="color:<?php echo esc_attr($brandkit_colorpalette['buttonTextColor']); ?>;font-family: <?php echo esc_attr($brandkit_fontinfo['fontFamily']); ?>; cursor: pointer;" total_investment="<?php echo $minimumInvestmentByInvestor; ?>" total_irr="<?php echo $minimumTargetIRR; ?>" font-size-p="<?php echo esc_attr($brandkit_fontinfo['p']); ?>;" font-size-h2="<?php echo esc_attr($brandkit_fontinfo['h2']); ?>;" primaryColor="<?php echo esc_attr($brandkit_colorpalette['primaryColor']); ?>" secondaryColor="<?php echo esc_attr($brandkit_colorpalette['secondaryColor']); ?>" currency="<?php echo $currency; ?>" fontinfoh2="<?php echo esc_attr($brandkit_fontinfo['h2']); ?>">Calculate</a>
                                            </h4>
                                        <?Php } ?>
                                    </div>

                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="<?php echo isset($args['widget_id']) ? esc_attr($args['widget_id']) : "";
                                ?>-id" data-last-update="<?php echo esc_attr($lstupmillisec); ?>" data-lytlimit="<?php echo esc_attr($lytlimit); ?>" data-load="<?php echo esc_attr($i); ?>"> </div>
                <?php } ?>
            </div>


    <?php

    }
}

    ?>

    <style>
        
        .itsp_side_by_side_event {
            width: 100%;
        }

        .itsp_side_by_side_event .itsp_native_product_style {
            flex-direction: row;
        }

        .itsp_side_by_side_event .gridImage_section {
            width: 50%;
        }

        .itsp_side_by_side_event .itsp_caption {
            width: 50%;
            margin-left: 5rem;
            margin-right: 3rem;
        }

        @media (max-width: 767px) {
            .itsp_side_by_side_event .itsp_caption {
                margin: 15px;
                width: 100%;
            }

            .itsp_side_by_side_event .itsp_native_product_style {
                flex-direction: column;
            }

            .itsp_side_by_side_event .gridImage_section {
                width: 100%;
            }
        }

        .itsp_progress_bar_section {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding-bottom: 20px;
            box-shadow: 0px 4px 8px 0px #0000001A;
        }

        .itsp_native_product_style {
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            border: none;
            box-shadow: 0px 2.83px 16.96px 0px #0000001A;

        }

        .itsp_native_product_style img {
            width: 100%;
            aspect-ratio: 2 / 1;
        }

        .itsp_contant_section {
            padding: 15px;
        }

        .itsp_offer_details_section {
            margin: 20px 0px;
        }

        .itsp_caption h2 {
            margin: 10px 0px 5px;
        }

        .itsp_contant_section h4 {
            margin: auto !important;
            width: 100%;
            border-radius: 10px;
        }

        .itsp_product_offer_label {
            position: absolute;
            top: 0px;
            clip-path: polygon(0 0, 0 100%, 100% 0);
            width: 100px;
            height: 100px;
            background-color: <?php echo esc_attr($brandkit_colorpalette['secondaryColor']); ?>;
            ;
        }

        .itsp_product_offer_symbol {
            rotate: 314deg;
            position: absolute;
            top: 15px;
            bottom: 10px;
            left: 30px;
            font-size: <?php echo esc_attr($brandkit_fontinfo['p']); ?>;
            color: #FFFFFF;
            max-width: 200px;
        }

        .itsp_format_currency {
            color: <?php echo esc_attr($brandkit_colorpalette['primaryColor']); ?>;
            font-size: <?php echo esc_attr($brandkit_fontinfo['h3']); ?>;
        }

        .itsp_bar_investment_status {
            color: #ffffff;
            background: <?php echo esc_attr($brandkit_colorpalette['warningColor']); ?>;
            padding: 5px;
            font-size: <?php echo esc_attr($brandkit_fontinfo['p']); ?>;
            border-radius: 5px;
            margin-bottom: 5px;
        }

        .itsp_offer_description {
            font-size: <?php echo esc_attr($brandkit_fontinfo['p']); ?>;
            color: #000000;
            text-align: left;
            overflow: hidden;
            text-overflow: ellipsis;
            display: -webkit-box;
            -webkit-line-clamp: 3;
            line-clamp: 3;
            -webkit-box-orient: vertical;
        }

        .itsp_card_tags {
            display: flex;
            flex-wrap: wrap;
        }

        .itsp_card_tags p {
            padding: 5px;
            font-size: <?php echo esc_attr($brandkit_fontinfo['p']); ?>;
            color: #000000;
            background: <?php echo esc_attr($brandkit_colorpalette['secondaryBackgroundColor']); ?>;
            margin: 5px;
            border-radius: 5px;
        }

        .itsp_is_events_grid_row {
            justify-content: flex-start;
        }

        .itsp_cta {
            min-height: auto;
        }

        .itsp_offercard_button_grid {
            display: flex;
            flex-direction: row;
            gap: 10px;
        }

        .itsp_fourSection_blocks .itsp_offercard_button_grid {
            flex-direction: column;
        }

        .itsp_progress_bar_section p {
            margin-bottom: 5px !important;
        }

        @media (max-width: 767px) {
            .itsp_offercard_button_grid {
                flex-direction: column;
            }

            .itsp_engage_grid_block {
                max-width: 100% !important;
                display: block;
            }
        }

        /* calculater Range bar */
        .itsp_prise_range {
            -webkit-appearance: none;
            /* Required for custom styling */
            appearance: none;
            /* For standardization */
            width: 100% !important;
            background: #DEB4B5;
            border-radius: 5px;
            outline: none;
        }

        .itsp_prise_range::-webkit-slider-thumb {
            -webkit-appearance: none;
            /* Required for thumb customization */
            width: 15px;
            height: 15px;
            background: #aa3c3e;
            /* Replace with PHP output if needed */
            border-radius: 50%;
            cursor: pointer;
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.5);
        }

        .itsp_prise_range::-moz-range-thumb {
            width: 15px;
            height: 15px;
            background: #aa3c3e;
            border-radius: 50%;
            cursor: pointer;
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.5);
        }

        .itsp_prise_range::-ms-thumb {
            width: 15px;
            height: 15px;
            background: #aa3c3e;
            border-radius: 50%;
            cursor: pointer;
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.5);
        }
    </style>
