<?php
$currency = isset($customer_obj['currency']) ? $customer_obj['currency'] : "$"
?>
<div class="itsp_is_events_grid itsp_event-grid  <?php echo esc_attr($wgtid); ?>  ">
    <div class="itsp_is_events_grid_row <?php echo esc_attr($wgtid); ?>-row">

        <div style="box-shadow: 0px 2.83px 16.96px 0px #0000001A; padding: 20px; border-radius: 10px;">
            <h3>Calculate your estimated Investment Return</h3>
            <p style="color: #000000; font-size: <?php echo esc_attr($brandkit_fontinfo['p']); ?>;">
                Discover potential earnings with our easy-to-use return calculator—quick and accurate
            </p>
            <div class="itsp_calculater_values">
                <div class="itsp_calculater_data">
                    <div style="display: flex; flex-direction: column; gap: 20px; width: 100%;">
                        <div style="display: flex; justify-content: space-between; width: 100%; align-items: center; color: #000000; font-size: <?php echo $brandkit_fontinfo['p']; ?>;">
                            <p style="font-size: <?php echo esc_attr($brandkit_fontinfo['p']); ?>;">Amount you want to invest</p>
                            <!-- <p style="padding: 0px 8px; border: 1px solid #8f8f8f;" id="itsp_single_investment-amount-display"><?php echo $currency; ?> 20,000</p> -->
                            <div class="itsp_calcul_rangeValues" id="itsp_single_investment-amount-display"><?php echo $currency; ?>
                                <input type="number" id="itsp_investment-amount-input" value="20000" style="width: 100px; padding-left: 5px; padding-right: 5px; border: none; color: #000000;" />
                            </div>

                        </div>
                        <div>
                            <input type="range" id="itsp_single_investment-range" name="itsp_investment_range" min="1" max="500000" value="20000" class="itsp_prise_range">
                        </div>
                    </div>
                    <div style="display: flex; flex-direction: column; gap: 20px; width: 100%;">
                        <div style="display: flex; justify-content: space-between; width: 100%; align-items: center; color: #000000; font-size: <?php echo esc_attr($brandkit_fontinfo['p']); ?>;">
                            <p style="font-size: <?php echo esc_attr($brandkit_fontinfo['p']); ?>;">Time Period (years)</p>
                            <!-- <p style="padding: 0px 8px; border: 1px solid #8f8f8f;" id="itsp_single_time-period-display">5 years</p>
                             -->
                            <div class="itsp_calcul_rangeValues" id="itsp_single_time-period-display">
                                <input type="number" id="itsp_time-period-input" value="5" style="width: 72px; text-align: center; border: none; color: #000000;" /> years
                            </div>
                        </div>
                        <div>
                            <!-- <input type="range" id="itsp_single_time-period-range" name="itsp_single_time-period-range" min="0.5" max="50" class="itsp_prise_range">
                             -->
                            <input type="range" id="itsp_single_time-period-range" name="itsp_time_period_range" min="0.5" max="50" value="5" step="0.5" class="itsp_prise_range">

                        </div>
                    </div>
                    <div style="display: flex; flex-direction: column; gap: 20px; width: 100%;">
                        <div style="display: flex; justify-content: space-between; width: 100%; align-items: center; color: #000000; font-size: <?php echo esc_attr($brandkit_fontinfo['p']); ?>;">
                            <p style="font-size: <?php echo esc_attr($brandkit_fontinfo['p']); ?>;">Estimated IRR (Based on the Property)</p>
                            <div class="itsp_calcul_rangeValues" id="itsp_single_irr-display">
                                <input type="number" id="itsp_irr-input" value="10" style="width: 100px; text-align: center; border: none; color: #000000;" />%
                            </div>
                        </div>
                        <div>
                            <input type="range" id="itsp_single_irr-range" name="itsp_single_irr-range" min="1" max="100" class="itsp_prise_range">
                        </div>
                    </div>
                    <h5
                        style="cursor: pointer; width: 100%; background: linear-gradient(270.08deg, <?php echo esc_attr($brandkit_colorpalette['secondaryColor']); ?> 0.07%, <?php echo esc_attr($brandkit_colorpalette['primaryColor']); ?> 98.28%); text-align: center; color: #FFFFFF; padding: 12px; border-radius: 10px;"
                        id="itsp_single_itsp-calculate-btn" class="trackablebtn">
                        Calculate
                    </h5>
                </div>
                <div class="itsp_calculater_total">
                    <p style="color: #FFFFFF; font-size: <?php echo esc_attr($brandkit_fontinfo['p']); ?>;">Your Estimated Investment Return</p>
                    <h3 style="color: #FFFFFF; font-size: <?php echo esc_attr($brandkit_fontinfo['h2']); ?>;" id="itsp_single_investment-return"><?php echo $currency; ?> 30,000.00</h3>
                </div>
            </div>
        </div>

        <div class="<?php echo isset($args['widget_id']) ? esc_attr($args['widget_id']) : "";
                    ?>-id" data-last-update="<?php echo esc_attr($lstupmillisec); ?>" data-lytlimit="<?php echo esc_attr($lytlimit); ?>" data-load="<?php echo esc_attr($i); ?>"> </div>
    </div>



</div>
<style>
    .itsp_calculater_values {
        display: flex;
        flex-direction: row;
        gap: 10px;
        margin-top: 10px;
    }

    .itsp_calculater_data {
        width: 65%;
        border-radius: 10px;
        box-shadow: 0px 0px 3.7px 1px #00000040;
        display: flex;
        flex-direction: column;
        justify-content: space-between;
        align-items: center;
        height: 450px;
        padding: 20px;
    }

    .itsp_calculater_total {
        width: 35%;
        border-radius: 10px;
        box-shadow: 0px 0px 3.7px 1px #00000040;
        display: flex;
        flex-direction: column;
        justify-content: space-between;
        height: 450px;
        padding: 20px;
        background: linear-gradient(360deg, <?php echo esc_attr($brandkit_colorpalette['secondaryColor']); ?> 0%, <?php echo esc_attr($brandkit_colorpalette['primaryColor']); ?> 100%);
    }

    .itsp_calculater_data p {
        margin-bottom: 1px;
    }

    @media (max-width: 767px) {
        .itsp_calculater_values {
            flex-direction: column;

        }

        .itsp_calculater_data {
            width: 100%;
        }

        .itsp_calculater_total {
            width: 100%;
            height: 200px;
        }
    }

    /* calculater Range bar */
    .itsp_prise_range {
        -webkit-appearance: none;
        appearance: none;
        width: 100% !important;
        background: <?php echo esc_attr($brandkit_colorpalette['primaryColor']); ?>;
        border-radius: 5px;
        outline: none;
    }

    .itsp_prise_range::-webkit-slider-thumb {
        -webkit-appearance: none;
        width: 15px;
        height: 15px;
        background: <?php echo esc_attr($brandkit_colorpalette['secondaryColor']); ?>;
        border-radius: 50%;
        cursor: pointer;
        box-shadow: 0 0 5px rgba(0, 0, 0, 0.5);
    }

    .itsp_prise_range::-moz-range-thumb {
        width: 15px;
        height: 15px;
        background: <?php echo esc_attr($brandkit_colorpalette['secondaryColor']); ?>;
        border-radius: 50%;
        cursor: pointer;
        box-shadow: 0 0 5px rgba(0, 0, 0, 0.5);
    }

    .itsp_prise_range::-ms-thumb {
        width: 15px;
        height: 15px;
        background: <?php echo esc_attr($brandkit_colorpalette['secondaryColor']); ?>;
        border-radius: 50%;
        cursor: pointer;
        box-shadow: 0 0 5px rgba(0, 0, 0, 0.5);
    }

    .itsp_calcul_rangeValues {
        padding: 0px 8px;
        border: 1px solid #d9d8d8;
        border-radius: 5px;
        display: flex;
        align-items: center;
        flex-wrap: nowrap;
        height: 42px;
    }
</style>
<script>
    jQuery(document).ready(function() {
        var investmentRange = jQuery('#itsp_investment-amount-input');
        var timePeriodRange = jQuery('#itsp_time-period-input');
        var irrRange = jQuery('#itsp_irr-input');
        var investmentReturnDisplay = jQuery('#itsp_single_investment-return');
        // Calculate function
        function numberFormatI18n(number, decimals = 0, locale = 'en-US') {
            return new Intl.NumberFormat(locale, {
                minimumFractionDigits: decimals,
                maximumFractionDigits: decimals,
            }).format(number);
        }
        jQuery('#itsp_single_itsp-calculate-btn').click(function() {
            var investmentAmount = parseInt(investmentRange.val());
            var timePeriod = parseInt(timePeriodRange.val());
            var irr = parseFloat(irrRange.val()) / 100;
            var interest = investmentAmount * irr * timePeriod;
            var totalAmount = numberFormatI18n(investmentAmount + interest, 2, 'en-US');
            investmentReturnDisplay.html('<?php echo $currency; ?>' + ' ' + totalAmount);
        });
    });
</script>

<script>
    jQuery(document).ready(function() {
        // Synchronize range and input fields
        const syncInputs = (rangeSelector, inputSelector) => {
            jQuery(rangeSelector).on("input", function() {
                jQuery(inputSelector).val(this.value);
            });
            jQuery(inputSelector).on("input", function() {
                jQuery(rangeSelector).val(this.value);
            });
        };

        syncInputs("#itsp_single_investment-range", "#itsp_investment-amount-input");
        syncInputs("#itsp_single_time-period-range", "#itsp_time-period-input");
        syncInputs("#itsp_single_irr-range", "#itsp_irr-input");

        // Calculate button functionality
        //   jQuery("#itsp_single_calculate-btn").click(function () {
        //     const investment = parseFloat(jQuery("#itsp_investment-amount-input").val()) || 0;
        //     const timePeriod = parseFloat(jQuery("#itsp_time-period-input").val()) || 0;
        //     const irr = parseFloat(jQuery("#itsp_irr-input").val()) / 100 || 0;

        //     const totalReturn = investment + investment * irr * timePeriod;

        //     // Display the result
        //     jQuery("#itsp_single_investment-return").text("<?php echo $currency; ?>" + totalReturn.toFixed(2));
        //   });
    });
</script>