<?php
/**
 * IntellaSphere Files Contain All Related Functions ,hooks ,Filters of the intellasphere Plugin
 *
 * 
 * @author    Intellasphere
 * @category 	Core
 * @package 	IntellaShphere
 */
if (!function_exists('itsp_recursive_sanitize_text_field')) {

    /**
     * Sanitize the array value
     * @since 1.0.0
     * @param type $array
     * @return type array
     */
    function itsp_recursive_sanitize_text_field($array) {
        foreach ($array as $key => &$value) {
            if (is_array($value)) {
                $value = itsp_recursive_sanitize_text_field($value);
            } else {
                $value = sanitize_text_field($value);
            }
        }
        return $array;
    }

}

/**
 * Create the Database Function
 */
if (!function_exists('itsp_installer')) {


    /**
     * Create the Table
     * @since 1.0.0
     */
    function itsp_installer() {
        include('installer.php');
    }

}

/**
 * Short Code to Display Banners In Table
 */
add_shortcode('itsp_bannerlist', 'itsp_banner_list_page');

/**
 * Create the Database Function
 */
if (!function_exists('itsp_banner_list_page')) {

    /**
     * Function to display table of banner in ShortCode
     */
    function itsp_banner_list_page() {
        $banner_list_table = new Itsp_Banners_List();
        echo "</pre><div class='wrap'><h2>Banners & Popups</h2>";
        ?>
        <div class="banner_gen_select_engage_type label-title" style=>Select Banner:
            <select class='notification_banner' id="banner_gen_ajax_select" 
                    name="shortcodeform" type="text" data-select="1"  data-change="banner_gen_engagement_type" style ="width:100%;">
                <option>Select</option>
            </select>  
            <select class="" style="display:none;" id="loader_engage">
                <option value="-1">Loading</option>
            </select> 
            Select Pages:
            <select name="page-dropdown" id="get_banner_pages"> 
                <option value="">
                    <?php echo esc_attr(__('Select Page', 'intellasphere')); ?></option> 
                <?php $pages = get_pages(); ?>
                <option value="ALL">ALL</option>
                <?php
                foreach ($pages as $page) {
                    if (!empty($page->post_title)) {
                        ?>
                        <option value="<?php echo esc_attr($page->ID); ?>"> <?php echo esc_attr($page->post_title); ?> </option>
                        <?php
                    }
                }
                ?>
            </select>

            <input type="submit" value="Add" id="submitbanner">
        </div>
        <?php
        $banner_list_table->prepare_items();
        ?>
        <form method="post">
            <?php
            $banner_list_table->display();
            echo '</form></div>';
        }

    }



    /**
     * Language translate
     */
    add_action('init', 'itsp_text_domain_translate');
    if (!function_exists('itsp_text_domain_translate')) {

        function itsp_text_domain_translate() {
            $plugin_rel_path = basename(dirname(__FILE__)) . '/languages'; /* Relative to WP_PLUGIN_DIR */
            load_plugin_textdomain('intellasphere', false, $plugin_rel_path);
            new Itsp_Utility();
        }

    }




    add_action('http_api_curl', 'itsp_custom_curl_timeout', 9999, 1);

    if (!function_exists('itsp_custom_curl_timeout')) {

        /**
         * Increase the Timeout of curl
         * @param type $handle
         */
        function itsp_custom_curl_timeout($handle) {
            curl_setopt($handle, CURLOPT_CONNECTTIMEOUT, 30); // 30 seconds. Too much for production, only for testing.
            curl_setopt($handle, CURLOPT_TIMEOUT, 30); // 30 seconds. Too much for production, only for testing.
        }

    }



    if (!function_exists('itsp_header_banner_notification')) {

        /**
         * Add Banner to Header Function Call
         * @global type $wpdb
         */
        function itsp_header_banner_notification() {
            social_banners('header');
        }

    }

    if (!function_exists('itsp_footer_banner_notification')) {

        /**
         * Add Banner to Footer Function Call
         * @global type $wpdb
         */
        function itsp_footer_banner_notification() {
            social_banners('footer');
        }

    }

    /**
     * Social Banner For Footer & Heaader
     * @global type $wpdb
     * @param type $type
     */
    function social_banners($type) {
        global $wpdb;
        $table = $wpdb->prefix . 'banner';
        $results = $wpdb->get_results("SELECT * FROM $table");
        foreach ($results as $key => $value) {
            $page_id = $value->pages;
            if ($value->pages != "ALL") {
                $page_id = (int) $value->pages;
            }
            if ($page_id == get_the_ID() || $page_id == "ALL") {
                $response = Itsp_Utility::get_post_details($value->banner);
                $unqid = uniqid();
                $name = str_replace(' ', '%20', $response->template);
                $bgcolor = str_replace('#', '', $response->theme->backGroundColor);
                $secbgcolor = str_replace('#', '', $response->theme->secondaryBackgroundColor);
                $bttxtcolor = str_replace('#', '', $response->theme->buttonTextColor);
                $button_color = str_replace('#', '', $response->theme->buttonColor);
                $secbtbgcolor = str_replace('#', '', $response->theme->secondaryButtonBackgroundColor);
                $secbtntxtcolor = str_replace('#', '', $response->theme->secondaryButtonTextColor);
                $txtcolor = str_replace('#', '', $response->theme->textColor);
                $tlecolor = str_replace('#', '', $response->theme->titleColor);
                $sectextcolor = str_replace('#', '', $response->theme->secondaryTextColor);
                $borcolor = str_replace('#', '', $response->theme->borderColor);
                $hdrbgcolor = str_replace('#', '', $response->theme->headerBackgroundColor);
                $ftrbgcolor = str_replace('#', '', $response->theme->footerBackgroundColor);
                $pricolor = str_replace('#', '', $response->theme->primaryColor);
                $pribgcolor = str_replace('#', '', $response->theme->primaryBackgroundColor);
                $pritextcolor = isset($response->theme->primaryTextColor) ? str_replace('#', '', $response->theme->primaryTextColor) : "4a4c54";
                $btbgcolor = str_replace('#', '', $response->theme->buttonBackgroundColor);
                $seccolor = str_replace('#', '', $response->theme->secondaryColor);
                $warcolor = str_replace('#', '', $response->theme->warningColor);
                $borderwidth = str_replace('#', '', $response->theme->borderWidth);
                $showborder = str_replace('#', '', $response->theme->showBorder);
                $fntfamily = str_replace('#', '', $response->theme->fontFamily);
                $fntweight = str_replace('#', '', $response->theme->fontWeight);
                $linheight = str_replace('#', '', $response->theme->lineHeight);
                $h1 = str_replace('#', '', $response->theme->h1);
                $h2 = str_replace('#', '', $response->theme->h2);
                $h3 = str_replace('#', '', $response->theme->h3);
                $h4 = str_replace('#', '', $response->theme->h4);
                $h5 = str_replace('#', '', $response->theme->h5);
                $h6 = str_replace('#', '', $response->theme->h6);
                $ptag = str_replace('#', '', $response->theme->p);
                $btnstyle = str_replace('#', '', $response->theme->buttonStyle);
                $btncrnradius = str_replace('#', '', $response->theme->buttonCornerRadius);
                $btnsize = str_replace('#', '', $response->theme->buttonSize);
                $iptborder = str_replace('#', '', $response->theme->inputBorder);
                $iptstyle = str_replace('#', '', $response->theme->inputStyle);
                $iptcrnradius = str_replace('#', '', $response->theme->inputCornerRadius);
                $style = str_replace('#', '', $response->template);
                $align = $response->alignment;
                $height = (isset($response->cardHeight) && $response->cardHeight != 0 ) ? str_replace('#', '', $response->cardHeight) . 'px' : "100%";
                $width = (isset($response->cardWidth) && $response->cardWidth != 0 ) ? str_replace('#', '', $response->cardWidth) . 'px' : "100%";
                $tsptbkground = (isset($response->theme->transparentBackGround) && $response->theme->transparentBackGround == 1) ? "true" : "false";
                $hidetitle = (isset($response->theme->hideTitle) && $response->theme->hideTitle == 1) ? "true" : "false";
                $showcpylogo = ($response->showCompanyLogo == 1) ? "true" : "false";
                $showcpyname = ($response->showCompanyName == 1) ? "true" : "false";
                $dtastyle = "Notificationbar";
                if ($response->bannerEmbedStyle == 'modal') {
                    $dtastyle = "Modal";
                } else if ($response->bannerEmbedStyle == 'slider') {
                    $dtastyle = "Slider";
                } else if ($response->bannerEmbedStyle == 'pageoverlay') {
                    $dtastyle = "pageTakeOver";
                }
                if ($type == 'header') {
                    if ($align == 'top' || $align == "top_left" || $align == "top_right") {
                        if ($align == "top_left") {
                            $align = "Top%20Left";
                        } elseif ($align == "top_right") {
                            $align = "Top%20Right";
                        }
                        $name = !empty($name) ? $name : ' ';
                        require_once( ITSP_INTEGRATION__PLUGIN_DIR . 'templates/embeddeds/banner.php');
                    }
                } else if ($type == 'footer') {
                    if ($align == 'bottom' || $align == "middle" || $align == "bottom_right" || $align == "bottom_left") {
                        if ($align == "bottom_right") {
                            $align = "Bottom%20Right";
                        } elseif ($align == "bottom_left") {
                            $align = "Bottom%20Left";
                        }
                        require_once( ITSP_INTEGRATION__PLUGIN_DIR . 'templates/embeddeds/banner.php');
                    }
                }
            }
        }
    }

    /**
     * Add Banner Embeded Code to the Header
     */
    add_action('wp_head', 'itsp_header_banner_notification');

    /**
     * Add Banner Embeded Code to the Footer
     */
    add_action('wp_footer', 'itsp_footer_banner_notification');

    /**
     * Filter for Gutenberg to Map the results to title and Post-id
     */
    add_filter('engage_filter', 'is_arrage_options', 10, 1);

    function is_arrage_options($results) {
        $i = 1;
        $options = array();
        $options[] = array('value' => "", 'label' => "Select Options");
        if (is_array($results)) {
            foreach ($results as $key => $values) {
                $options[$i]['value'] = isset($values['postId']) ? $values['postId'] : "";
                $options[$i]['label'] = isset($values['title']) ? $values['title'] : "";
                $i = $i + 1;
            }
        }
        return $options;
    }

    /**
     * Add Tracking Code to the Header
     */
    add_action('wp_head', 'itsp_getanalytics');

    function itsp_getanalytics() {

        $option_name = 'get_tracking_codes_details';
        $results = get_option($option_name);
        $consent_msg = isset($results['cookieConsent']->message) ? $results['cookieConsent']->message : "This website uses cookies to ensure you get the best experience.";
        $link = isset($results['cookieConsent']->link) ? $results['cookieConsent']->link : "Learn more";
        $href = isset($results['cookieConsent']->href) ? $results['cookieConsent']->href : "#";
        $allow = isset($results['cookieConsent']->allow) ? $results['cookieConsent']->allow : "Allow cookies";
        $deny = isset($results['cookieConsent']->deny) ? $results['cookieConsent']->deny : "Declines";
        ?>
        <script>
            document.addEventListener('DOMContentLoaded', function () {
            if (typeof zaraz !== 'undefined') {
            // Set a cookie to indicate that zaraz is defined
            document.cookie = "zaraz_defined=true; path=/; max-age=3600"; // Cookie expires in 1 hour
            }
            });
            function trackLinkClicks(analyticsInstance) {
            document.querySelectorAll('a[href]').forEach(function (link) {
            if (!link.classList.contains('trackablebtn')) {
            link.addEventListener('click', function (event) {
            var linkHref = event.target.href || 'unknown';
            var linkText = event.target.innerText || 'No Text';
            analyticsInstance.track('LinkClick', {
            href: linkHref,
                    text: linkText,
            });
            });
            }
            });
            }

            function trackSubmitButtonClicks(Analytics) {
            document.addEventListener('click', function (event) {
            // Check if the clicked element matches your selector
            if (event.target.matches('button[type="submit"], input[type="submit"]') && !event.target.classList.contains('trackablebtn')) {
            var buttonId = event.target.id || 'unknown';
            var buttonText = event.target.innerText || event.target.value || 'No Text';
            Analytics.track('SubmitButtonClick', {
            id: buttonId,
                    text: buttonText,
            });
            }
            });
            }

            function trackButtonClicks(Analytics) {
            document.querySelectorAll('.trackablebtn').forEach(function (button) {
            button.addEventListener('click', function (event) {
            var buttonId = event.target.id || 'unknown';
            var buttonText = event.target.innerText || 'No Text';
            Analytics.track('ButtonClick', {
            id: buttonId,
                    text: buttonText,
            });
            });
            });
            }

        </script>

        <?php
        if (isset($_COOKIE['zaraz_defined']) && $_COOKIE['zaraz_defined'] === 'true') {
             $results['trackings'] = [
                (object)[
                    "trackingId" => "Zaraz",
                    "providerName" => "Zaraz",
                ]
            ];
        }
        $provider_plugins = get_provider_plugins();
        $included_main_script = false; // Flag to track inclusion of the main script
        $plugins = []; // Array to hold plugin configuration

        if (isset($results['trackings']) && !empty($results['trackings'])) {
            foreach ($results['trackings'] as $value) {
                if (!isset($value->providerName, $value->trackingId)) {
                    continue; // Skip if essential properties are missing
                }
                if (array_key_exists($value->providerName, $provider_plugins)) {
                    if (!$included_main_script) {
                        // Include the main analytics script once
                        echo '<script src="https://unpkg.com/@analytics/router-utils/dist/@analytics/router-utils.min.js"></script>';
                        echo '<script src="https://unpkg.com/analytics/dist/analytics.min.js"></script>';
                        $included_main_script = true;
                    }

                    // Add plugin-specific script
                    $plugin_data = $provider_plugins[$value->providerName];
                    $plugin_name = $plugin_data['plugin'];
                    $init_function = $plugin_data['init'];
                    $config_fields = $plugin_data['config']; // Required configuration fields
                    $config_values = [];

                    // Populate configuration array dynamically
                    foreach ($config_fields as $key => $field) {
                        if (isset($value->{$field})) {
                            $config_values[$key] = htmlspecialchars($value->{$field}, ENT_QUOTES, 'UTF-8');
                        }
                    }

                    $plugins[] = [
                        'init' => $init_function,
                        'config' => $config_values,
                    ];

                    // Include the library script for this plugin
                    if (isset($plugin_data['lib'])) {
                        echo '<script src="' . htmlspecialchars($plugin_data['lib'], ENT_QUOTES, 'UTF-8') . '"></script>';
                    }
                }
            }
        }
        ?>
        <script type="text/javascript">
            document.addEventListener('DOMContentLoaded', function () {
            function checkConsent() {
            // Get all cookies
            const cookies = document.cookie.split('; ');
            // Look for the cf_consent cookie
            for (let i = 0; i < cookies.length; i++) {
            const [name, value] = cookies[i].split('=');
            // Check if the cookie name is cf_consent and value is accepted
            if (name === 'cf_consent' && value === 'accepted') {
            return true;
            }
            }

            // If cf_consent is not set or not equal to 'accepted'
            return false;
            }
            if (typeof zaraz !== 'undefined') {
            var Analytics = _analytics.init({
            app: 'getanalytics-html',
                    debug: true,
                    version: 100,
                    plugins: [analyticsZaraz([])]});
            // Track page view
            Analytics.page();
            trackButtonClicks(Analytics);
            // Track href link clicks
            trackLinkClicks(Analytics);
            trackSubmitButtonClicks(Analytics);
            } else if (checkConsent()) {
              
    <?php 
        if (!empty($plugins)) { ?>

                // Initialize analytics
                var Analytics = _analytics.init({
                app: 'getanalytics-html',
                        debug: true,
                        version: 100,
                        plugins: [
        <?php foreach ($plugins as $plugin) { ?>
            <?php echo $plugin['init']; ?>(
            <?php echo json_encode($plugin['config']); ?>
                            ),
        <?php } ?>
                        ]
                });
                // Track page view
                Analytics.page();
                trackButtonClicks(Analytics);
                // Track href link clicks
                trackLinkClicks(Analytics);
                trackSubmitButtonClicks(Analytics);

                <?Php } ?>
                }



                });
            </script>

            <?php 
            if (!isset($_COOKIE['zaraz_defined']) && $_COOKIE['zaraz_defined'] != 'true' && !empty($plugins)) { ?>
                <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.css" />
                <script src="https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.js"></script>
                <script>
                                

            window.addEventListener("load", function () {
            if (typeof zaraz == 'undefined') {
            window.cookieconsent.initialise({
            palette: {
            popup: {
            background: "#000", // Popup background color
                    text: "#fff"        // Popup text color
            },
                    button: {
                    background: "#f1d600", // Button background color
                            text: "#000"           // Button text color
                    }
            },
                    theme: "edgeless", // Popup theme (options: "classic", "edgeless")
                    position: "bottom-right", // Popup position (options: "top", "bottom", "top-left", "top-right", "bottom-left", "bottom-right")
                    type: "opt-in", // Consent type (options: "info", "opt-in", "opt-out")
                    content: {
                    "message": "<?php echo $consent_msg; ?>",
                            "dismiss": "Got it!", // Button text to dismiss the banner
                            "link": "<?php echo $link; ?>", // Text for the "Learn more" link
                            "href": "<?php echo $href; ?>", // URL for the "Learn more" link
                            "allow": "<?php echo $allow; ?>", // Text for the "Allow cookies" button (optional)
                            "deny": "<?php echo $deny; ?>", // Text for the "Decline cookies" button (optional)
                    },
                    onInitialise: function (status) {
                    if (status === cookieconsent.status.allow) {
                    document.cookie = "cf_consent=accepted; path=/; max-age=" + 60 * 60 * 24 * 365; // Set the cf_consent cookie for 1 year
                    console.log("Cookies accepted!");
                    // Initialize analytics
                    var Analytics = _analytics.init({
                    app: 'getanalytics-html',
                            debug: true,
                            version: 100,
                            plugins: [
            <?php foreach ($plugins as $plugin) { ?>
                <?php echo $plugin['init']; ?>(
                <?php echo json_encode($plugin['config']); ?>
                                ),
            <?php } ?>
                            ]
                    });
                    Analytics.page();
                    trackLinkClicks(Analytics);
                    } else if (status === cookieconsent.status.deny) {
                    console.log("Cookies rejected!");
                    document.cookie = "cf_consent=rejected; path=/; max-age=" + 60 * 60 * 24 * 365; // Set the cf_consent cookie for 1 year

                    }
                    },
                    onStatusChange: function (status) {
                    if (status === cookieconsent.status.allow) {
                    document.cookie = "cf_consent=accepted; path=/; max-age=" + 60 * 60 * 24 * 365; // Set the cf_consent cookie for 1 year
                    console.log("User accepted cookies!");
                    } else if (status === cookieconsent.status.deny) {
                    console.log("User rejected cookies!");
                    document.cookie = "cf_consent=rejected; path=/; max-age=" + 60 * 60 * 24 * 365; // Set the cf_consent cookie for 1 year

                    }
                    }
            });
            }
            });
                </script>
                <style>
                    .cc-window {
                        left: 50% !important;
                        transform: translateX(-50%) !important;
                        max-width: 600px; /* Adjust the width as needed */
                        text-align: center;
                        bottom: 50%;

                    }
                    .cc-revoke{
                        display:none;
                    }

                </style>

            <?php
        }
    //}
}

function get_provider_plugins() {
    // Provider plugin configurations
    $provider_plugins = [
        'Zaraz' => [
            'plugin' => 'zaraz-analytics-plugin',
            'init' => 'analyticsZaraz',
            'lib' => ITSP_INTEGRATION__PLUGIN_URL . '/assets/js/getanalytics/zaraz.js'
        ],
        'Google Analytics' => [
            'plugin' => 'google-analytics',
            'init' => 'analyticsGa.default',
            'config' => [
                'measurementIds' => 'trackingId',
                'url' => 'trackingUrl' // Example additional field
            ],
            'lib' => 'https://unpkg.com/@analytics/google-analytics/dist/@analytics/google-analytics.min.js'
        ],
        'Google Tag Manager' => [
            'plugin' => 'google-tag-manager',
            'init' => 'analyticsGoogleTagManager.default',
            'config' => [
                'containerId' => 'trackingId'
            ],
            'lib' => 'https://unpkg.com/@analytics/google-tag-manager/dist/@analytics/google-tag-manager.min.js'
        ],
        'Segment' => [
            'plugin' => 'segment',
            'init' => 'analyticsSegment.default',
            'config' => [
                'writeKey' => 'trackingId'
            ],
            'lib' => 'https://unpkg.com/@analytics/segment/dist/@analytics/segment.min.js'
        ],
        'Amplitude' => [
            'plugin' => 'amplitude',
            'init' => 'analyticsAmplitude.default',
            'config' => [
                'apiKey' => 'trackingId'
            ],
            'lib' => 'https://unpkg.com/@analytics/amplitude/dist/@analytics/amplitude.min.js'
        ],
        'FullStory' => [
            'plugin' => 'fullstory',
            'init' => 'analyticsFullStory.default',
            'config' => [
                'orgId' => 'trackingId'
            ],
            'lib' => 'https://unpkg.com/@analytics/fullstory/dist/@analytics/fullstory.min.js'
        ],
        'Mixpanel' => [
            'plugin' => 'mixpanel',
            'init' => 'analyticsMixpanel.default',
            'config' => [
                'token' => 'trackingId'
            ],
            'lib' => 'https://unpkg.com/@analytics/mixpanel/dist/@analytics/mixpanel.min.js'
        ],
        'Customer.io' => [
            'plugin' => 'customerio',
            'init' => 'analyticsCustomerIo.default',
            'config' => [
                'siteId' => 'trackingId'
            ],
            'lib' => 'https://unpkg.com/@analytics/customerio/dist/@analytics/customerio.min.js'
        ],
        'Snowplow Analytics' => [
            'plugin' => 'snowplow',
            'init' => 'analyticsSnowplow.default',
            'config' => [
                'collectorUrl' => 'trackingId'
            ],
            'lib' => 'https://unpkg.com/@analytics/snowplow/dist/@analytics/snowplow.min.js'
        ],
        'HubSpot' => [
            'plugin' => 'hubspot',
            'init' => 'analyticsHubspot.default',
            'config' => [
                'portalId' => 'trackingId'
            ],
            'lib' => 'https://unpkg.com/@analytics/hubspot/dist/@analytics/hubspot.min.js'
        ],
        'AWS Pinpoint' => [
            'plugin' => 'aws-pinpoint',
            'init' => 'analyticsAwsPinpoint.default',
            'config' => [
                'appId' => 'trackingId'
            ],
            'lib' => 'https://unpkg.com/@analytics/aws-pinpoint/dist/@analytics/aws-pinpoint.min.js'
        ],
        'CrazyEgg' => [
            'plugin' => 'crazyegg',
            'init' => 'analyticsCrazyEgg.default',
            'config' => [
                'accountNumber' => 'trackingId'
            ],
            'lib' => 'https://unpkg.com/@analytics/crazyegg/dist/@analytics/crazyegg.min.js'
        ],
        'GoSquared' => [
            'plugin' => 'gosquared',
            'init' => 'analyticsGoSquared.default',
            'config' => [
                'siteToken' => 'trackingId'
            ],
            'lib' => 'https://unpkg.com/@analytics/gosquared/dist/@analytics/gosquared.min.js'
        ],
        'Simple Analytics' => [
            'plugin' => 'simple-analytics',
            'init' => 'analyticsSimpleAnalytics.default',
            'config' => [
                'apiKey' => 'trackingId'
            ],
            'lib' => 'https://unpkg.com/@analytics/simple-analytics/dist/@analytics/simple-analytics.min.js'
        ],
        'Ownstats' => [
            'plugin' => 'ownstats',
            'init' => 'analyticsOwnstats.default',
            'config' => [
                'url' => 'trackingId'
            ],
            'lib' => 'https://unpkg.com/@analytics/ownstats/dist/@analytics/ownstats.min.js'
        ],
        'Perfume.js' => [
            'plugin' => 'perfumejs',
            'init' => 'analyticsPerfume.default',
            'config' => [
                'instance' => 'trackingId'
            ],
            'lib' => 'https://unpkg.com/@analytics/perfumejs/dist/@analytics/perfumejs.min.js'
        ],
        'Countly' => [
            'plugin' => 'countly',
            'init' => 'analyticsCountly.default',
            'config' => [
                'serverUrl' => 'trackingId'
            ],
            'lib' => 'https://unpkg.com/@analytics/countly/dist/@analytics/countly.min.js'
        ],
        'Custify' => [
            'plugin' => 'custify',
            'init' => 'analyticsCustify.default',
            'config' => [
                'tenantId' => 'trackingId'
            ],
            'lib' => 'https://unpkg.com/@analytics/custify/dist/@analytics/custify.min.js'
        ],
        'Do Not Track' => [
            'plugin' => 'do-not-track',
            'init' => 'analyticsDoNotTrack.default',
            'config' => [],
            'lib' => 'https://unpkg.com/@analytics/do-not-track/dist/@analytics/do-not-track.min.js'
        ],
        'Tab Events' => [
            'plugin' => 'tab-events',
            'init' => 'analyticsTabEvents.default',
            'config' => [],
            'lib' => 'https://unpkg.com/@analytics/tab-events/dist/@analytics/tab-events.min.js'
        ],
        'Window Events' => [
            'plugin' => 'window-events',
            'init' => 'analyticsWindowEvents.default',
            'config' => [],
            'lib' => 'https://unpkg.com/@analytics/window-events/dist/@analytics/window-events.min.js'
        ],
        'Original Source' => [
            'plugin' => 'original-source',
            'init' => 'analyticsOriginalSource.default',
            'config' => [],
            'lib' => 'https://unpkg.com/@analytics/original-source/dist/@analytics/original-source.min.js'
        ],
        'Event Validation' => [
            'plugin' => 'event-validation',
            'init' => 'analyticsEventValidation.default',
            'config' => [],
            'lib' => 'https://unpkg.com/@analytics/event-validation/dist/@analytics/event-validation.min.js'
        ],
        'Microsoft Bing' => [
            'plugin' => 'bing-uet',
            'init' => 'analyticsBingUET',
            'config' => [
                'bingUETTagId' => 'trackingId',
                'debug' => true // Example additional field 
            ],
            'lib' => ITSP_INTEGRATION__PLUGIN_URL . '/assets/js/getanalytics/microsoftbing.js'
        ],
        'LinkedIn' => [
            'plugin' => 'analyticsLinkedIn',
            'init' => 'analyticsLinkedIn',
            'config' => [
                'partnerId' => 'trackingId',
                'debug' => true
            ],
            'lib' => ITSP_INTEGRATION__PLUGIN_URL . '/assets/js/getanalytics/linkedIn.js'
        ],
        'WhatsApp Pixel' => [
            'plugin' => 'whatsapp-pixel',
            'init' => 'analyticsWhatsAppPixel',
            'config' => [
                'whatsappPixelId' => 'trackingId',
                'debug' => true // Example additional field
            ],
            'lib' => ITSP_INTEGRATION__PLUGIN_URL . '/assets/js/getanalytics/whatsapppixel.js'
        ],
        'Facebook Pixel' => [
            'plugin' => 'facebook-analytics-plugin',
            'init' => 'analyticsFacebook',
            'config' => [
                'pixelId' => 'trackingId',
                'debug' => true // Example additional field
            ],
            'lib' => ITSP_INTEGRATION__PLUGIN_URL . '/assets/js/getanalytics/facebook.js'
        ],
        'Google AdSense' => [
            'plugin' => 'google-adsense-pixel',
            'init' => 'analyticsAdSensePixel',
            'config' => [
                'googleAdSenseId' => 'trackingId',
                'debug' => true // Example additional field
            ],
            'lib' => ITSP_INTEGRATION__PLUGIN_URL . '/assets/js/getanalytics/googleadsensepixel.js'
        ],
        'X Pixel' => [
            'plugin' => 'true',
            'init' => 'analyticsTwitterPixel',
            'config' => [
                'twitterPixelId' => 'trackingId',
                'debug' => true // Example additional fieldxpixel   xpixel
            ],
            'lib' => ITSP_INTEGRATION__PLUGIN_URL . '/assets/js/getanalytics/xpixel.js'
        ],
        'Google Ads' => [
            'plugin' => 'true',
            'init' => 'analyticsGoogleAds',
            'config' => [
                'trackingId' => 'trackingId',
                'debug' => true // Example additional fieldxpixel   xpixel
            ],
            'lib' => ITSP_INTEGRATION__PLUGIN_URL . '/assets/js/getanalytics/googleads.js'
        ]
    ];
    return $provider_plugins;
}
