var analyticsZaraz = (function() {
    'use strict';

    function ownKeys(object, enumerableOnly) {
        var keys = Object.keys(object);
        if (Object.getOwnPropertySymbols) {
            var symbols = Object.getOwnPropertySymbols(object);
            enumerableOnly && (symbols = symbols.filter(function(sym) {
                return Object.getOwnPropertyDescriptor(object, sym).enumerable;
            })), keys.push.apply(keys, symbols);
        }
        return keys;
    }

    function _objectSpread(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = null != arguments[i] ? arguments[i] : {};
            i % 2 ? ownKeys(Object(source), !0).forEach(function(key) {
                _defineProperty(target, key, source[key]);
            }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function(key) {
                Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
            });
        }
        return target;
    }

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }
        return obj;
    }

    var config = {
        debug: false,
        // pixelId: null,
    };

    function zarazAnalyticsPlugin() {
       
        var pluginConfig = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        return {
            name: 'zaraz-analytics-plugin',
            config: _objectSpread(_objectSpread({}, config), pluginConfig),
            initialize: function initialize(_ref) {
                var config = _ref.config;
                
                // Ensure Zaraz is loaded (Zaraz should already be initialized by the site)
                if (typeof zaraz === 'undefined') {
                    throw new Error('Zaraz is not loaded');
                }

                // Debugging
                if (config.debug) {
                    console.log('Zaraz initialized');
                }
            },
            page: function page(_ref2) {
                // Track PageView event with Zaraz
                var payload = _ref2.payload;
                if (typeof zaraz !== 'undefined') {
                    zaraz.track('PageView');
                    if (config.debug) {
                        console.log('Zaraz PageView event tracked');
                    }
                }
            },
            track: function track(_ref3) {
                var payload = _ref3.payload;
                var event = payload.event,
                properties = payload.properties;
                if (typeof zaraz !== 'undefined') {
                    zaraz.track(event, properties);
                    if (config.debug) {
                        console.log('Zaraz Event tracked:', event, properties);
                    }
                }
            },
            identify: function identify(_ref4) {
                var payload = _ref4.payload;
                var userId = payload.userId,
                traits = payload.traits;

                // Send identify event with Zaraz
                if (typeof zaraz !== 'undefined') {
                    // You can use a custom event for identifying a user, here 'UserIdentified'
                    zaraz.track('UserIdentified', {
                        userId: userId,
                        ...traits
                    });

                    if (config.debug) {
                        console.log('Zaraz User Identified:', { userId: userId, traits: traits });
                    }
                } else {
                    if (config.debug) {
                        console.error('Zaraz is not defined');
                    }
                }
            },
            loaded: function loaded() {
                return typeof zaraz !== 'undefined';
            },
        };
    }


    return zarazAnalyticsPlugin; // Return the function
})();