var analyticsTwitterPixel = (function () {
    'use strict';
  
    var config = {
        debug: false,
        twitterPixelId: null,  // Twitter Pixel ID
    };

    /**
     * Twitter Pixel Plugin
     * @param {object} pluginConfig - Plugin configuration
     * @param {string} pluginConfig.twitterPixelId - Your Twitter Pixel ID
     * @param {boolean} [pluginConfig.debug=false] - Enable debug logs
     * @return {object} Analytics plugin
     */
    function twitterPixel() {
        var pluginConfig = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

        return {
            name: 'twitter-pixel',
            config: Object.assign({}, config, pluginConfig),

            initialize: function initialize(_ref) {
                var config = _ref.config;
                var twitterPixelId = config.twitterPixelId;

                if (!twitterPixelId) {
                    throw new Error('No Twitter Pixel ID defined');
                }

                if (!scriptLoaded()) {
                    /* Load Twitter Pixel script */
                    !(function (w, d, t) {
                        var ts = d.createElement(t);
                        ts.async = true;
                        ts.src = 'https://static.ads-twitter.com/uwt.js';
                        ts.onload = function () {
                            if (window.twq) {
                                window.twq('config', twitterPixelId);
                                if (config.debug) {
                                    console.log('Twitter Pixel initialized with ID:', twitterPixelId);
                                }
                            }
                        };
                        var s = d.getElementsByTagName(t)[0];
                        s.parentNode.insertBefore(ts, s);
                    })(window, document, 'script');
                }
            },

            page: function page(_ref2) {
                var payload = _ref2.payload;
                if (window.twq) {
                    window.twq('track', 'PageView');
                    if (config.debug) {
                        console.log('Twitter PageView tracked:', payload);
                    }
                }
            },

            track: function track(_ref3) {
                var payload = _ref3.payload;
                var event = payload.event,
                    properties = payload.properties;

                if (window.twq) {
                    window.twq('track', event, properties);
                    if (config.debug) {
                        console.log('Twitter Event tracked:', event, properties);
                    }
                }
            },

            identify: function identify(_ref4) {
                var payload = _ref4.payload;
                var userId = payload.userId,
                    traits = payload.traits;

                if (window.twq) {
                    window.twq('identify', { user_id: userId, traits: traits });
                    if (config.debug) {
                        console.log('Twitter user identified:', { userId: userId, traits: traits });
                    }
                }
            },

            loaded: function loaded() {
                return typeof window.twq !== 'undefined';
            },
        };
    }

    /* Check if Twitter Pixel script is already loaded */
    function scriptLoaded() {
        var scripts = document.querySelectorAll('script[src]');
        return Array.from(scripts).some(function (script) {
            return script.src.indexOf('https://static.ads-twitter.com/uwt.js') !== -1;
        });
    }

    var index = twitterPixel;

    return index;
})();
