var analyticsWhatsAppPixel = (function () {
    'use strict';

    var config = {
        debug: false,
        whatsappPixelId: null, // Your WhatsApp Pixel ID
    };

    /**
     * WhatsApp Pixel Plugin
     * @param {object} pluginConfig - Plugin configuration
     * @param {string} pluginConfig.whatsappPixelId - Your WhatsApp Pixel ID
     * @param {boolean} [pluginConfig.debug=false] - Enable debug logs
     * @return {object} Analytics plugin
     */
    function whatsappPixel() {
        var pluginConfig = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

        return {
            name: 'whatsapp-pixel',
            config: Object.assign({}, config, pluginConfig),

            initialize: function initialize(_ref) {
                var config = _ref.config;
                var whatsappPixelId = config.whatsappPixelId;

                if (!whatsappPixelId) {
                    throw new Error('No WhatsApp Pixel ID defined');
                }

                if (!scriptLoaded()) {
                    /* Load WhatsApp Pixel script */
                    !(function (w, d, t) {
                        var pixelScript = d.createElement(t);
                        pixelScript.async = true;
                        pixelScript.src = 'https://www.whatsapp.com/pixel.js'; // Replace with actual WhatsApp Pixel URL
                        pixelScript.onload = function () {
                            if (window.whatsappPixelQueue) {
                                window.whatsappPixelQueue.push('event', 'pageView', { pixelId: whatsappPixelId });
                                if (config.debug) {
                                    console.log('WhatsApp Pixel initialized with ID:', whatsappPixelId);
                                }
                            }
                        };
                        var s = d.getElementsByTagName(t)[0];
                        s.parentNode.insertBefore(pixelScript, s);
                    })(window, document, 'script');
                }
            },

            page: function page(_ref2) {
                var payload = _ref2.payload;
                if (window.whatsappPixelQueue) {
                    window.whatsappPixelQueue.push('event', 'pageView', { pixelId: config.whatsappPixelId });
                    if (config.debug) {
                        console.log('WhatsApp PageView tracked:', payload);
                    }
                }
            },

            track: function track(_ref3) {
                var payload = _ref3.payload;
                var event = payload.event,
                    properties = payload.properties;

                if (window.whatsappPixelQueue) {
                    window.whatsappPixelQueue.push('event', event, properties);
                    if (config.debug) {
                        console.log('WhatsApp Event tracked:', event, properties);
                    }
                }
            },

            identify: function identify(_ref4) {
                var payload = _ref4.payload;
                var userId = payload.userId,
                    traits = payload.traits;

                if (window.whatsappPixelQueue) {
                    window.whatsappPixelQueue.push('event', 'identify', { userId: userId, traits: traits });
                    if (config.debug) {
                        console.log('WhatsApp user identified:', { userId: userId, traits: traits });
                    }
                }
            },

            loaded: function loaded() {
                return typeof window.whatsappPixelQueue !== 'undefined';
            },
        };
    }

    /* Check if WhatsApp Pixel script is already loaded */
    function scriptLoaded() {
        var scripts = document.querySelectorAll('script[src]');
        return Array.from(scripts).some(function (script) {
            return script.src.indexOf('https://www.whatsapp.com/pixel.js') !== -1;
        });
    }

    var index = whatsappPixel;

    return index;
})();
