var analyticsLinkedIn = (function () {
    'use strict';
  
    function ownKeys(object, enumerableOnly) { 
      var keys = Object.keys(object); 
      if (Object.getOwnPropertySymbols) { 
        var symbols = Object.getOwnPropertySymbols(object); 
        enumerableOnly && (symbols = symbols.filter(function (sym) { 
          return Object.getOwnPropertyDescriptor(object, sym).enumerable; 
        })), keys.push.apply(keys, symbols); 
      } 
      return keys; 
    }
  
    function _objectSpread(target) { 
      for (var i = 1; i < arguments.length; i++) { 
        var source = null != arguments[i] ? arguments[i] : {}; 
        i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { 
          _defineProperty(target, key, source[key]); 
        }) : Object.getOwnPropertyDescriptors ? 
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : 
          ownKeys(Object(source)).forEach(function (key) { 
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); 
          }); 
      } 
      return target; 
    }
  
    function _defineProperty(obj, key, value) { 
      if (key in obj) { 
        Object.defineProperty(obj, key, { 
          value: value, 
          enumerable: true, 
          configurable: true, 
          writable: true 
        }); 
      } else { 
        obj[key] = value; 
      } 
      return obj; 
    }
  
    var config = {
      debug: false,
      partnerId: null, // The LinkedIn Partner ID
      conversionId: null, // Conversion tracking ID
    };
  
    /**
     * LinkedIn Analytics Plugin
     * @param {object} pluginConfig - Plugin configuration
     * @param {string} pluginConfig.partnerId - LinkedIn Partner ID
     * @param {string} pluginConfig.conversionId - LinkedIn Conversion Tracking ID
     * @param {boolean} [pluginConfig.debug=false] - Enable debug logs
     * @return {object} Analytics plugin
     * @example
     *
     * analyticsLinkedIn({
     *   partnerId: 'YOUR_PARTNER_ID',
     *   conversionId: 'YOUR_CONVERSION_ID',
     *   debug: true
     * })
     */
    function linkedInAnalyticsPlugin() {
      var pluginConfig = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  
      return {
        name: 'linkedin-analytics-plugin',
        config: _objectSpread(_objectSpread({}, config), pluginConfig),
  
        initialize: function initialize(_ref) {
          var config = _ref.config;
          var partnerId = config.partnerId;
  
          if (!partnerId) {
            throw new Error('No LinkedIn Partner ID defined');
          }
  
          if (!scriptLoaded(partnerId)) {
            /* Load LinkedIn Insight Tag script */
            !(function (w, d, s, l, i) {
              w[l] = w[l] || [];
              w[l].push({
                'li.start': new Date().getTime(),
                event: 'li.js'
              });
              var f = d.getElementsByTagName(s)[0],
                  j = d.createElement(s),
                  dl = l != 'dataLayer' ? '&l=' + l : '';
  
              j.src = 'https://snap.licdn.com/li.lms-analytics/insight.min.js';
              j.setAttribute('data-partner-id', i);
              f.parentNode.insertBefore(j, f);
            })(window, document, 'script', 'linkedin', partnerId);
  
            if (config.debug) {
              console.log('LinkedIn Insight Tag initialized with ID:', partnerId);
            }
          }
        },
  
        page: function page(_ref2) {
          var payload = _ref2.payload;
          if (window._linkedin_data_partner_ids) {
            if (config.debug) {
              console.log('LinkedIn PageView tracked:', payload);
            }
            window._linkedin_data_partner_ids.push(config.partnerId);
          }
        },
  
        track: function track(_ref3) {
          var payload = _ref3.payload;
          var event = payload.event,
            properties = payload.properties;
  
          if (window._linkedin_data_partner_ids) {
            if (config.debug) {
              console.log('LinkedIn Event tracked:', event, properties);
            }
            window._linkedin_data_partner_ids.push(config.partnerId);
            window._linkedin_data_partner_ids.push({
              event: event,
              properties: properties
            });
          }
        },
  
        identify: function identify(_ref4) {
          var payload = _ref4.payload;
          var userId = payload.userId,
            traits = payload.traits;
  
          if (window._linkedin_data_partner_ids) {
            window._linkedin_data_partner_ids.push(config.partnerId);
            window._linkedin_data_partner_ids.push({
              event: 'Identify',
              userId: userId,
              traits: traits
            });
  
            if (config.debug) {
              console.log('LinkedIn user identified:', { userId: userId, traits: traits });
            }
          }
        },
  
        loaded: function loaded() {
          return typeof window._linkedin_data_partner_ids !== 'undefined';
        },
      };
    }
  
    /* Check if LinkedIn Insight Tag script is already loaded */
    function scriptLoaded(partnerId) {
      var regex = new RegExp('https://snap.licdn.com/li.lms-analytics/insight.min.js');
      var scripts = document.querySelectorAll('script[src]');
      return !!Object.keys(scripts).filter(function (key) {
        return (scripts[key].src || '').match(regex);
      }).length;
    }
  
    var index = linkedInAnalyticsPlugin;
  
    return index;
  
  })();
  