// Initialize Google AdSense Pixel
var analyticsAdSensePixel = (function () {
    'use strict';

    var config = {
        debug: false,
        googleAdSenseId: null, // Your Google AdSense ID
    };

    /**
     * Google AdSense Pixel Plugin
     * @param {object} pluginConfig - Plugin configuration
     * @param {string} pluginConfig.googleAdSenseId - Your Google AdSense ID
     * @param {boolean} [pluginConfig.debug=false] - Enable debug logs
     * @return {object} Analytics plugin
     */
    function googleAdSensePixel() {
        var pluginConfig = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

        return {
            name: 'google-adsense-pixel',
            config: Object.assign({}, config, pluginConfig),

            initialize: function initialize(_ref) {
                var config = _ref.config;
                var googleAdSenseId = config.googleAdSenseId;

                if (!googleAdSenseId) {
                    throw new Error('No Google AdSense ID defined');
                }

                if (!scriptLoaded()) {
                    /* Load Google AdSense script */
                    !(function (w, d, t) {
                        var adsenseScript = d.createElement(t);
                        adsenseScript.async = true;
                        adsenseScript.src = 'https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js'; // Google AdSense script URL
                        adsenseScript.onload = function () {
                            if (config.debug) {
                                console.log('Google AdSense initialized with ID:', googleAdSenseId);
                            }

                            // Ensure that the push happens only when the ad unit is not filled already
                            if (typeof window.adsbygoogle !== 'undefined') {
                                var adUnits = document.querySelectorAll('.adsbygoogle');
                                adUnits.forEach(function (adUnit) {
                                    if (!adUnit.innerHTML) {  // Check if the ad unit is empty
                                        (window.adsbygoogle = window.adsbygoogle || []).push({ google_ad_client: googleAdSenseId });
                                    }
                                });
                            } else {
                                console.warn('Google AdSense is not properly loaded');
                            }
                        };
                        var s = d.getElementsByTagName(t)[0];
                        s.parentNode.insertBefore(adsenseScript, s);
                    })(window, document, 'script');
                }
            },

            page: function page(_ref2) {
                var payload = _ref2.payload;
                if (config.debug) {
                    console.log('Google AdSense PageView tracked:', payload);
                }
            },

            track: function track(_ref3) {
                var payload = _ref3.payload;
                var event = payload.event,
                    properties = payload.properties;

                if (config.debug) {
                    console.log('Google AdSense Event tracked:', event, properties);
                }
            },

            identify: function identify(_ref4) {
                var payload = _ref4.payload;
                var userId = payload.userId,
                    traits = payload.traits;

                if (config.debug) {
                    console.log('Google AdSense user identified:', { userId: userId, traits: traits });
                }
            },

            loaded: function loaded() {
                return typeof window.adsbygoogle !== 'undefined';
            },
        };
    }

    /* Check if Google AdSense script is already loaded */
    function scriptLoaded() {
        var scripts = document.querySelectorAll('script[src]');
        return Array.from(scripts).some(function (script) {
            return script.src.indexOf('https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js') !== -1;
        });
    }

    var index = googleAdSensePixel;

    return index;
})();
