var analyticsGoogleAds = (function() {
    'use strict';

    function ownKeys(object, enumerableOnly) {
        var keys = Object.keys(object);
        if (Object.getOwnPropertySymbols) {
            var symbols = Object.getOwnPropertySymbols(object);
            enumerableOnly && (symbols = symbols.filter(function(sym) {
                return Object.getOwnPropertyDescriptor(object, sym).enumerable;
            })), keys.push.apply(keys, symbols);
        }
        return keys;
    }

    function _objectSpread(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = null != arguments[i] ? arguments[i] : {};
            i % 2 ? ownKeys(Object(source), !0).forEach(function(key) {
                _defineProperty(target, key, source[key]);
            }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function(key) {
                Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
            });
        }
        return target;
    }

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }
        return obj;
    }

    var config = {
        debug: false,
        trackingId: null,  // Google Ads tracking ID (AW-XXXXXXXXXX)
    };

    function googleAdsAnalyticsPlugin() {
        var pluginConfig = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        return {
            name: 'google-ads-analytics-plugin',
            config: _objectSpread(_objectSpread({}, config), pluginConfig),
            initialize: function initialize(_ref) {
                var config = _ref.config;
                var trackingId = config.trackingId;
                trackingId = 'AW-1234567890'; // Just as a placeholder, replace with real ID
                if (!trackingId) {
                    throw new Error('No Google Ads Tracking ID defined');
                }

                if (!scriptLoaded(trackingId)) {
                    // Load Google Ads Global Site Tag (gtag.js)
                    (function(f, b, e, v, n, t, s) {
                        if (f.gtag) return;
                        n = f.gtag = function() {
                            n.callMethod ? n.callMethod.apply(n, arguments) : n.queue.push(arguments);
                        };
                        if (!f._gtag) f._gtag = n;
                        n.push = n;
                        n.loaded = true;
                        n.version = '1';
                        n.queue = [];
                        t = b.createElement(e);
                        t.async = true;
                        t.src = 'https://www.googletagmanager.com/gtag/js?id=' + trackingId;
                        s = b.getElementsByTagName(e)[0];
                        s.parentNode.insertBefore(t, s);
                        t.onload = function() {
                            //gtag('config', trackingId);
                            if (config.debug) {
                                console.log('Google Ads Global Site Tag initialized with ID:', trackingId);
                            }
                        };
                    })(window, document, 'script');
                }
            },
            page: function page(_ref2) {
                var payload = _ref2.payload;
                if (window.gtag) {
                    gtag('event', 'page_view');
                    if (config.debug) {
                        console.log('Google Ads PageView tracked:', payload);
                    }
                }
            },
            track: function track(_ref3) {
                var payload = _ref3.payload;
                var event = payload.event,
                    properties = payload.properties;
                if (window.gtag) {
                    gtag('event', event, properties);
                    if (config.debug) {
                        console.log('Google Ads Event tracked:', event, properties);
                    }
                }
            },
            identify: function identify(_ref4) {
                var payload = _ref4.payload;
                var userId = payload.userId,
                    traits = payload.traits;
                if (window.gtag) {
                    gtag('set', { 'user_id': userId, ...traits });
                    if (config.debug) {
                        console.log('Google Ads user identified:', { userId: userId, traits: traits });
                    }
                }
            },
            loaded: function loaded() {
                return typeof gtag !== 'undefined';
            },
        };
    }

    function scriptLoaded(trackingId) {
        var regex = new RegExp('https://www.googletagmanager.com/gtag/js?id=' + trackingId);
        var scripts = document.querySelectorAll('script[src]');
        return !!Object.keys(scripts).filter(function(key) {
            return (scripts[key].src || '').match(regex);
        }).length;
    }

    return googleAdsAnalyticsPlugin; // Return the function
})();
