var analyticsFacebook = (function() {
    'use strict';

    function ownKeys(object, enumerableOnly) {
        var keys = Object.keys(object);
        if (Object.getOwnPropertySymbols) {
            var symbols = Object.getOwnPropertySymbols(object);
            enumerableOnly && (symbols = symbols.filter(function(sym) {
                return Object.getOwnPropertyDescriptor(object, sym).enumerable;
            })), keys.push.apply(keys, symbols);
        }
        return keys;
    }

    function _objectSpread(target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = null != arguments[i] ? arguments[i] : {};
            i % 2 ? ownKeys(Object(source), !0).forEach(function(key) {
                _defineProperty(target, key, source[key]);
            }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function(key) {
                Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
            });
        }
        return target;
    }

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }
        return obj;
    }

    var config = {
        debug: false,
        pixelId: null,
    };

    function facebookAnalyticsPlugin() {
       
        var pluginConfig = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        return {
            name: 'facebook-analytics-plugin',
            config: _objectSpread(_objectSpread({}, config), pluginConfig),
            initialize: function initialize(_ref) {
                var config = _ref.config;
                var pixelId = config.pixelId;
                if (!pixelId) {
                    throw new Error('No Facebook Pixel ID defined');
                }
               
                if (!scriptLoaded(pixelId)) {
                    !(function(f, b, e, v, n, t, s) {
                        if (f.fbq) return;
                        n = f.fbq = function() {
                            n.callMethod ? n.callMethod.apply(n, arguments) : n.queue.push(arguments);
                        };
                        if (!f._fbq) f._fbq = n;
                        n.push = n;
                        n.loaded = true;
                        n.version = '2.0';
                        n.queue = [];
                        t = b.createElement(e);
                        t.async = true;
                        t.src = 'https://connect.facebook.net/en_US/fbevents.js';
                        s = b.getElementsByTagName(e)[0];
                        s.parentNode.insertBefore(t, s);
                    })(window, document, 'script');
                    fbq('init', pixelId);
                    //alert(config.debug);
                    if (config.debug) {
                        console.log('Facebook Pixel initialized with ID:', pixelId);
                    }
                }
            },
            page: function page(_ref2) {
                var payload = _ref2.payload;
                if (window.fbq) {
                    fbq('track', 'PageView');
                    if (config.debug) {
                        console.log('Facebook PageView tracked:', payload);
                    }
                }
            },
            track: function track(_ref3) {
                var payload = _ref3.payload;
                var event = payload.event,
                    properties = payload.properties;
                if (window.fbq) {
                    fbq('track', event, properties);
                    if (config.debug) {
                        console.log('Facebook Event tracked:', event, properties);
                    }
                }
            },
            identify: function identify(_ref4) {
                var payload = _ref4.payload;
                var userId = payload.userId,
                    traits = payload.traits;
                if (window.fbq) {
                    fbq('track', 'Lead', _objectSpread({
                        userId: userId
                    }, traits));
                    if (config.debug) {
                        console.log('Facebook user identified:', {
                            userId: userId,
                            traits: traits
                        });
                    }
                }
            },
            loaded: function loaded() {
                return typeof fbq !== 'undefined';
            },
        };
    }

    function scriptLoaded(pixelId) {
        var regex = new RegExp('https://connect.facebook.net/en_US/fbevents.js');
        var scripts = document.querySelectorAll('script[src]');
        return !!Object.keys(scripts).filter(function(key) {
            return (scripts[key].src || '').match(regex);
        }).length;
    }

    return facebookAnalyticsPlugin; // Return the function
})();