<?php

if (!defined('ABSPATH'))
    exit;

/**
 * Class Itsp_Leadaction
 */
if (!class_exists("Itsp_Leadaction")) {

    final class Itsp_Leadaction extends NF_Abstracts_Action {

        /**
         * @var string
         */
        protected $_name = 'is_lead';

        /**
         * @var string
         */
        protected $_timing = 'late';

        /**
         * @var int
         */
        protected $_priority = 0;

        /**
         * Constructor
         */
        public function __construct() {
            parent::__construct();
            $this->_nicename = __(ITSP_NAME.' Contact Form ', 'intellasphere');
            $fields_settings = Itsp_Utility::ninja_form_mapping('FORM_CONTACTUS');
            if (isset($fields_settings['option']) && $fields_settings['option'] != '') {
                $this->_settings['is_actions'] = array(
                    'name' => 'is_actions',
                    'type' => 'fieldset',
                    'width' => 'full',
                    'label' => __(ITSP_NAME.' Actions', 'intellasphere'),
                    'group' => 'primary',
                    'settings' => array(
                        array(
                            'name' => 'is_select_form',
                            'type' => 'select',
                            'label' => __('Send Lead This Form', 'intellasphere'),
                            'width' => 'full',
                            'group' => 'primary',
                            'options' => $fields_settings['option'],
                            'use_merge_tags' => false,
                            'help' => __('This feature requires the user set up automated Lead in the Intellashpere', 'intellasphere')
                        )
                    )
                );
            }

            if (isset($fields_settings['fields']) && $fields_settings['fields'] != '') {
                $this->_settings['field_mapping'] = array(
                    'name' => 'field_mapping',
                    'type' => 'fieldset',
                    'width' => 'full',
                    'label' => __('Field Mapping', 'intellasphere'),
                    'group' => 'primary',
                    'settings' => $fields_settings['fields']
                );
            }
        }

        /**
         * @param array $action_settings
         * @param int|string $form_id
         * @param array $data
         * @return array $data
         */
        public function process($action_settings, $form_id, $data) {
            $lead_id = $action_settings['is_select_form'];
            $lead_list = array();
            if (isset($lead_id) && !empty($lead_id)) {
                foreach ($action_settings as $key => $value) {
                    if (strstr($key, 'is_lead_list_')) {
                        $lead_list[$lead_id][str_replace('is_lead_list_', '', $key)] = $value;
                    }
                }
                $lead_id = Itsp_Utility::is_store_lead($lead_list);
            }

            return $data;
        }

    }

}


/**
 * Class Itsp_Newsletteraction
 */
if (!class_exists("Itsp_Newsletteraction")) {

    final class Itsp_Newsletteraction extends NF_Abstracts_Action {

        /**
         * @var string
         */
        protected $_name = 'is_newsletter';

        /**
         * @var string
         */
        protected $_timing = 'late';

        /**
         * @var int
         */
        protected $_priority = 0;

        /**
         * Constructor
         */
        public function __construct() {
            parent::__construct();
            $this->_nicename = __(ITSP_NAME.' NewsLetter Subscription', 'intellasphere');
            $fields_settings = Itsp_Utility::ninja_form_mapping('NEWSLETTER_SUBSCRIPTION');
            if (isset($fields_settings['option']) && $fields_settings['option'] != '') {
                $this->_settings['is_actions'] = array(
                    'name' => 'is_actions',
                    'type' => 'fieldset',
                    'width' => 'full',
                    'label' => __(ITSP_NAME.' Actions', 'intellasphere'),
                    'group' => 'primary',
                    'settings' => array(
                        array(
                            'name' => 'is_select_form',
                            'type' => 'select',
                            'label' => __('Send Newsletter This Form', 'intellasphere'),
                            'width' => 'full',
                            'group' => 'primary',
                            'options' => $fields_settings['option'],
                            'use_merge_tags' => false,
                            'help' => __('This feature requires the user set up automated Newsletter in the Intellashpere', 'intellasphere')
                        )
                    )
                );
            }

            if (isset($fields_settings['fields']) && $fields_settings['fields'] != '') {
                $this->_settings['field_mapping'] = array(
                    'name' => 'field_mapping',
                    'type' => 'fieldset',
                    'width' => 'full',
                    'label' => __('Field Mapping', 'intellasphere'),
                    'group' => 'primary',
                    'settings' => $fields_settings['fields']
                );
            }
        }

        /**
         * @param array $action_settings
         * @param int|string $form_id
         * @param array $data
         * @return array $data
         */
        public function process($action_settings, $form_id, $data) {
            $Newsletter_id = $action_settings['is_select_form'];
            $Newsletter_list = array();
            if (isset($Newsletter_id) && !empty($Newsletter_id)) {
                foreach ($action_settings as $key => $value) {
                    if (strstr($key, 'is_lead_list_')) {
                        $Newsletter_list[$Newsletter_id][str_replace('is_lead_list_', '', $key)] = $value;
                    }
                }
                $Newsletter_id = Itsp_Utility::is_store_lead($Newsletter_list ,'subscriptionformresponse');
            }

            return $data;
        }

    }

}


//feedbackformresponse
/**
 * Class Itsp_Feedbackaction
 */
if (!class_exists("Itsp_Feedbackaction")) {

    final class Itsp_Feedbackaction extends NF_Abstracts_Action {

        /**
         * @var string
         */
        protected $_name = 'is_feedback';

        /**
         * @var string
         */
        protected $_timing = 'late';

        /**
         * @var int
         */
        protected $_priority = 0;

        /**
         * Constructor
         */
        public function __construct() {
            parent::__construct();
            $this->_nicename = __(ITSP_NAME.' Feedback ', 'intellasphere');
            $fields_settings = Itsp_Utility::ninja_form_mapping('FORM_FEEDBACK');
            if (isset($fields_settings['option']) && $fields_settings['option'] != '') {
                $this->_settings['is_actions'] = array(
                    'name' => 'is_actions',
                    'type' => 'fieldset',
                    'width' => 'full',
                    'label' => __(ITSP_NAME.' Actions', 'intellasphere'),
                    'group' => 'primary',
                    'settings' => array(
                        array(
                            'name' => 'is_select_form',
                            'type' => 'select',
                            'label' => __('Send Feedback This Form', 'intellasphere'),
                            'width' => 'full',
                            'group' => 'primary',
                            'options' => $fields_settings['option'],
                            'use_merge_tags' => false,
                            'help' => __('This feature requires the user set up automated Feedback in the Intellashpere', 'intellasphere')
                        )
                    )
                );
            }

            if (isset($fields_settings['fields']) && $fields_settings['fields'] != '') {
                $this->_settings['field_mapping'] = array(
                    'name' => 'field_mapping',
                    'type' => 'fieldset',
                    'width' => 'full',
                    'label' => __('Field Mapping', 'intellasphere'),
                    'group' => 'primary',
                    'settings' => $fields_settings['fields']
                );
            }
        }

        /**
         * @param array $action_settings
         * @param int|string $form_id
         * @param array $data
         * @return array $data
         */
        public function process($action_settings, $form_id, $data) {
            $Feedback_id = $action_settings['is_select_form'];
            $Feedback_list = array();
            if (isset($Feedback_id) && !empty($Feedback_id)) {
                foreach ($action_settings as $key => $value) {
                    if (strstr($key, 'is_lead_list_')) {
                        $Feedback_list[$Feedback_id][str_replace('is_lead_list_', '', $key)] = $value;
                    }
                }
                $Feedback_id = Itsp_Utility::is_store_lead($Feedback_list ,'feedbackformresponse');
            }

            return $data;
        }

    }

}

/**
 * Class Itsp_Reviewaction
 */
if (!class_exists("Itsp_Reviewaction")) {

    final class Itsp_Reviewaction extends NF_Abstracts_Action {

        /**
         * @var string
         */
        protected $_name = 'is_review';

        /**
         * @var string
         */
        protected $_timing = 'late';

        /**
         * @var int
         */
        protected $_priority = 0;

        /**
         * Constructor
         */
        public function __construct() {
            parent::__construct();
            $this->_nicename = __(ITSP_NAME.' Review ', 'intellasphere');
            $fields_settings = Itsp_Utility::ninja_form_mapping('FORM_REVIEW');
            if (isset($fields_settings['option']) && $fields_settings['option'] != '') {
                $this->_settings['is_actions'] = array(
                    'name' => 'is_actions',
                    'type' => 'fieldset',
                    'width' => 'full',
                    'label' => __(ITSP_NAME.' Actions', 'intellasphere'),
                    'group' => 'primary',
                    'settings' => array(
                        array(
                            'name' => 'is_select_form',
                            'type' => 'select',
                            'label' => __('Send Review This Form', 'intellasphere'),
                            'width' => 'full',
                            'group' => 'primary',
                            'options' => $fields_settings['option'],
                            'use_merge_tags' => false,
                            'help' => __('This feature requires the user set up automated Review in the Intellashpere', 'intellasphere')
                        )
                    )
                );
            }

            if (isset($fields_settings['fields']) && $fields_settings['fields'] != '') {
                $this->_settings['field_mapping'] = array(
                    'name' => 'field_mapping',
                    'type' => 'fieldset',
                    'width' => 'full',
                    'label' => __('Field Mapping', 'intellasphere'),
                    'group' => 'primary',
                    'settings' => $fields_settings['fields']
                );
            }
        }

        /**
         * @param array $action_settings
         * @param int|string $form_id
         * @param array $data
         * @return array $data
         */
        public function process($action_settings, $form_id, $data) {
            $Review_id = $action_settings['is_select_form'];
            $Review_list = array();
            if (isset($Review_id) && !empty($Review_id)) {
                foreach ($action_settings as $key => $value) {
                    if (strstr($key, 'is_lead_list_')) {
                        $Review_list[$Review_id][str_replace('is_lead_list_', '', $key)] = $value;
                    }
                }
                $Review_id = Itsp_Utility::is_store_lead($Review_list ,'reviewResponse');
            }

            return $data;
        }

    }

}


//Reviewformresponse
