
// Different config options for each type of shortcode
const calendar = {
  policy: 'hide',
  datepicker: 'only',
  target: 'integrio-calendar',
};

const custom_search_enquiry = {
  custom_enquiry_page: true, 
  datepicker: 'only',
  target: 'integrio-custom-search-enquiry',
  // host: 'book.' + integrioData.subdomain + '.co.za', // LEFT HERE IN CASE WE NEED IT, MURRAY KNOWS THE REASON FOR THIS OPTION
};

const custom_search_results = {
  force_enquiry: true,
  target: 'integrio-custom-search-results'
}

const single_bookable = {
  policy: 'hide', 
  bookable: 'THIS WILL GET OVERIDDEN',
  target: 'integrio-single-bookable',
  // host: 'book.' + integrioData.subdomain + '.co.za', // LEFT HERE IN CASE WE NEED IT, MURRAY KNOWS THE REASON FOR THIS OPTION
}

document.addEventListener('DOMContentLoaded', function() {
  const integrioCustomSearchEnquiryContainer = document.querySelector('#integrio-custom-search-enquiry');
  const integrioCalendarContainer = document.querySelector('#integrio-calendar');
  const integrioCustomSearchResultsContainer = document.querySelector('#integrio-custom-search-results');
  const integrioSingleBookableContainer = document.querySelector('#integrio-single-bookable');
  const integrioBookableId = document.querySelector('#integrio-single-bookable')?.dataset.bookableId;

  if (integrioCustomSearchEnquiryContainer) {
      InnStyle(integrioData.subdomain, custom_search_enquiry);
  }
  if (integrioCalendarContainer) {
      InnStyle(integrioData.subdomain, calendar);
  }
  if (integrioCustomSearchResultsContainer) {
      InnStyle(integrioData.subdomain, custom_search_results);
  }
  if (integrioSingleBookableContainer) {
      single_bookable.bookable = integrioBookableId;
      InnStyle(integrioData.subdomain, single_bookable);
  }
});