<?php
// If this file is called directly, abort.
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

/**
 * Delete plugin options.
 *
 * @param int|null $site_id Optional. Site ID for multisite, defaults to null.
 */
function integrazo_wz_delete_options($site_id = null)
{
    $options = [
        'integrazo_wz_delete_data',
        'integrazo_wz_enable_log_cleanup',
        'integrazo_wz_log_retention_days',
        'integrazo_wz_error_notification',
        'integrazo_wz_error_notification_email',
        'integrazo_wz_error_notification_subject',
        'integrazo_wz_access_tokens',
    ];

    // Switch to the specific site if a site ID is provided (multisite support)
    if ($site_id !== null && is_multisite()) {
        switch_to_blog($site_id);
    }

    foreach ($options as $option) {
        delete_option($option); // Delete each option
    }

    // Restore the current site if a site ID was provided
    if ($site_id !== null && is_multisite()) {
        restore_current_blog();
    }
}

/**
 * Delete plugin tables.
 *
 * @param int|null $site_id Optional. Site ID for multisite, defaults to null.
 */
function integrazo_wz_delete_table($site_id = null)
{
    global $wpdb;

    $table_list = [
        'integrazo_wz_logs',
        'integrazo_wz_integrations',
        'integrazo_wz_accounts',
    ];

    // Switch to the specific site if a site ID is provided (multisite support)
    if ($site_id !== null && is_multisite()) {
        switch_to_blog($site_id);
    }

    foreach ($table_list as $table) {
        $full_table_name = $wpdb->prefix . $table;

        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.PreparedSQL.InterpolatedNotPrepared, WordPress.DB.DirectDatabaseQuery.SchemaChange
        $wpdb->query("DROP TABLE IF EXISTS `{$full_table_name}`");
    }

    // Restore the current site if a site ID was provided
    if ($site_id !== null && is_multisite()) {
        restore_current_blog();
    }
}

/**
 * Main uninstallation process.
 */
function integrazo_wz_run_uninstall()
{
    if (is_multisite()) {
        // Handle network-wide uninstall
        $sites = get_sites(['fields' => 'ids']);
        foreach ($sites as $site_id) {
            // Switch to each site
            switch_to_blog($site_id);

            // Check if data deletion is enabled
            $delete_status = get_option('integrazo_wz_delete_data', '');
            if ($delete_status === '1') {
                integrazo_wz_delete_options($site_id);
                integrazo_wz_delete_table($site_id);
            }

            // Restore the original site context
            restore_current_blog();
        }
    } else {
        // Handle single-site uninstall
        $delete_status = get_option('integrazo_wz_delete_data', '');
        if ($delete_status === '1') {
            integrazo_wz_delete_options();
            integrazo_wz_delete_table();
        }
    }
}

// Execute the uninstallation process
integrazo_wz_run_uninstall();
