<?php
// Exit if accessed directly.
if (! defined('ABSPATH')) {
    exit;
}
/**
 *
 * @return bool
 */
function integrazo_wz_is_pro_active()
{
    include_once(ABSPATH . 'wp-admin/includes/plugin.php');

    $pro_plugin = 'integrazo-integration-for-zoho-apps-pro/integrazo-integration-for-zoho-apps-pro.php';

    return is_plugin_active($pro_plugin);
}

/**
 * Check if the Pro plugin file exists (installed).
 *
 * @return bool
 */
function integrazo_wz_is_pro_file_exists()
{
    $pro_plugin_path = INTEGRAZO_WZ_PLUGIN_DIR . '../integrazo-integration-for-zoho-apps-pro/integrazo-integration-for-zoho-apps-pro.php';
    return file_exists($pro_plugin_path);
}

function integrazo_wz_session()
{
    // Pro must be active
    if (!integrazo_wz_is_pro_active()) {
        return false;
    }
    // Retrieve session data from options
    $session = get_option('integrazo_wz_session_key', null);
    if (!empty($session)) {
        if ($session === "MTExMTExMTExMTExMQ==") {
            return true;
        }
        // Decode the session key
        $decoded_session = base64_decode($session, true);

        // Ensure the session key was successfully decoded and is numeric
        if ($decoded_session !== false && is_numeric($decoded_session)) {
            $current_time = round(microtime(true) * 1000); // Current time in milliseconds
            // Check if the decoded session key is greater than the current time
            if ((is_numeric($decoded_session) && (int)$decoded_session > $current_time)) {
                return true;
            }
        }
    }

    // If the session is not valid, return false
    return false;
}

add_action('admin_post_integrazo_wz_handle_field_mapping_step', 'integrazo_wz_handle_field_mapping_step');

function integrazo_wz_handle_field_mapping_step()
{
    // Verify nonce
    if (
        !isset($_POST['integrazo_wz_field_mapping_nonce']) ||
        !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['integrazo_wz_field_mapping_nonce'])), 'integrazo_wz_field_mapping_action')
    ) {
        wp_die(esc_html__('Invalid request', 'integrazo-integration-for-zoho-apps'));
    }
    if (! current_user_can('manage_options')) {
        wp_die(esc_html__('Insufficient permissions.', 'integrazo-integration-for-zoho-apps'));
    }
    // Define keys to exclude from saving
    $exclude_keys = [
        'integrazo_wz_field_mapping_nonce',
        '_wp_http_referer',
        'action',
        'integrazo_wz_next'
    ];

    // Sanitize all inputs except excluded keys
    $sanitized_post = [];
    foreach ($_POST as $key => $value) {
        if (in_array($key, $exclude_keys, true)) {
            continue;
        }

        $sanitized_post[$key] = is_array($value)
            ? array_map('sanitize_text_field', wp_unslash($value))
            : sanitize_text_field(wp_unslash($value));
    }

    // Get required ID
    $integration_id = $sanitized_post['integration_id'] ?? '';

    // Remove integration_id from data (it’s used for lookup, not storing)
    unset($sanitized_post['integration_id']);


    // Save form/module or other data as JSON
    $model = new INTEGRAZO_WZ_Integration_Model();
    $model->update_integration_data($integration_id, $sanitized_post);

    // Redirect to Step 3
    $redirect_url = admin_url('admin.php?page=integrazo-integration-for-zoho-apps&integration_id=' . urlencode($integration_id) . '&step=3');
    wp_redirect($redirect_url);
    exit;
}
