<?php

if (! defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class INTEGRAZO_WZ_Plugin_Input_Renderer
{

    public static function render($integration_details)
    {
        $integration_data = json_decode($integration_details['integration_data'] ?? '', true);
        $from_plugin = $integration_details['from_plugin'];
        switch ($from_plugin) {
            case 'wordpress_org':
            case 'woocommerce':
                $selected_event = $integration_data['integrazo_wz_event_name'] ?? null;
                return self::render_event_select($integration_details, $selected_event);
                break;

            default:
                $selected_form_id = $integration_data['integrazo_wz_form_id'] ?? null;
                return self::render_form_select($integration_details, $selected_form_id);
                break;
        }
    }

    private static function render_event_select($integration_details, $selected_event)
    {
        $events = INTEGRAZO_WZ_Event_Details::render($integration_details);

        if ($events === null) {
            return $events;
        }

        if (!is_array($events)) {
            return new WP_Error(
                'integrazo_wz_invalid_event', // Unique error code
                esc_html($events)     // Sanitize dynamic error message
            );
        }

        ob_start();
?>
        <div class="integrazo-wz-setup-div">
            <label for="integrazo_wz_event_select" class="integrazo-wz-setup-lable" style="width:170px;margin-right: 10px;">
                <?php esc_html_e('Select Event:', 'integrazo-integration-for-zoho-apps'); ?>
                <div class="integrazo-wz-helpicon-help-icon-wrapper" style="display: inline-block; margin-left: 5px;">
                    <span class="integrazo-wz-helpicon-help-icon">?</span>
                    <div class="integrazo-wz-helpicon-help-tooltip">
                        <p><?php esc_html_e('Select an event that will trigger this integration.', 'integrazo-integration-for-zoho-apps'); ?></p>
                    </div>
                </div>
            </label>
            <select name="integrazo_wz_event_name" id="integrazo_wz_event_select" class="regular-text integrazo-wz-setup-select-change" style="width: 60%;">
                <option value=""><?php esc_html_e('Select', 'integrazo-integration-for-zoho-apps'); ?></option>
                <?php foreach ($events as $event): ?>
                    <option value="<?php echo esc_attr($event['id']); ?>" <?php selected($event['id'], $selected_event); ?>>
                        <?php echo esc_html($event['title']); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
    <?php
        return ob_get_clean();
    }


    private static function render_form_select($integration_details, $selected_form_id)
    {
        $forms = INTEGRAZO_WZ_Event_Details::render($integration_details);
        if ($forms === null) {
            return $forms;
        }
        if (!is_array($forms)) {
            return new WP_Error(
                'integrazo_wz_invalid_event', // Unique error code (for debugging/logging)
                $forms                // Error message string (human-readable)
            );
        }

        ob_start();
    ?>
        <div class="integrazo-wz-setup-div">
            <label for="integrazo_wz_form_select" class="integrazo-wz-setup-lable" style="width:170px;margin-right: 10px;">
                <?php esc_html_e('Select Form:', 'integrazo-integration-for-zoho-apps'); ?>
                <div class="integrazo-wz-helpicon-help-icon-wrapper" style="display: inline-block; margin-left: 5px;">
                    <span class="integrazo-wz-helpicon-help-icon">?</span>
                    <div class="integrazo-wz-helpicon-help-tooltip">
                        <p><?php esc_html_e('Choose the form you want to link with this integration.', 'integrazo-integration-for-zoho-apps'); ?></p>
                    </div>
                </div>
            </label>
            <select name="integrazo_wz_form_id" id="integrazo_wz_form_select" class="regular-text integrazo-wz-setup-select-change" style="width: 60%;">
                <option value=""><?php esc_html_e('Select', 'integrazo-integration-for-zoho-apps'); ?></option>
                <?php foreach ($forms as $form) : ?>
                    <option value="<?php echo esc_attr($form['id']); ?>" <?php selected($form['id'], $selected_form_id); ?>>
                        <?php echo esc_html($form['title']); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
<?php
        return ob_get_clean();
    }
    /**
     * Allowed admin HTML for our internal UI fragments (selects, options, etc).
     */
    public static function allowed_admin_html()
    {
        // Start from 'post' defaults and extend.
        $allowed = wp_kses_allowed_html('post');

        // Add/extend tags we use in admin UI.
        $allowed['div']   = array_merge($allowed['div'] ?? [],   array('class' => true, 'id' => true, 'style' => true));
        $allowed['span']  = array_merge($allowed['span'] ?? [],  array('class' => true, 'id' => true, 'style' => true, 'title' => true));
        $allowed['label'] = array_merge($allowed['label'] ?? [], array('for' => true, 'class' => true, 'style' => true));

        $allowed['select'] = array(
            'name'   => true,
            'id'     => true,
            'class'  => true,
            'style'  => true,
            'disabled' => true,
            'multiple' => true,
        );
        $allowed['option'] = array(
            'value'    => true,
            'selected' => true,
            'disabled' => true,
            'title'    => true,
        );
        $allowed['optgroup'] = array(
            'label' => true,
        );
        $allowed['button'] = array(
            'type'  => true,
            'id'    => true,
            'name'  => true,
            'class' => true,
            'style' => true,
        );
        $allowed['p'] = array('class' => true, 'style' => true);

        return $allowed;
    }
}
