<?php

// Exit if accessed directly.
if (! defined('ABSPATH')) {
    exit;
}


$integration_sources = [
    'plugins' => [
        ['name' => 'Contact Form 7', 'id' => 'contact_form_7', 'img' => 'contact_form_7.png'],
        ['name' => 'WP Forms', 'id' => 'wp_form', 'img' => 'wp_form.png'],
        ['name' => 'Elementor Forms', 'id' => 'elementor_form', 'img' => 'elementor_form.png'],
        ['name' => 'WordPress.org', 'id' => 'wordpress_org', 'img' => 'wordpress_org.png'],
        ['name' => 'Woocommerce', 'id' => 'woocommerce', 'img' => 'woocommerce.png'],
        ['name' => 'Gravity Forms', 'id' => 'gravity_form', 'img' => 'gravity_form.png', 'pro' => true],
        ['name' => 'Ninja Forms', 'id' => 'ninja_form', 'img' => 'ninja_form.png', 'pro' => true],
        ['name' => 'Formidable Forms', 'id' => 'formidable_form', 'img' => 'formidable_form.png', 'pro' => true],
        ['name' => 'Everest Forms', 'id' => 'everest_form', 'img' => 'everest_form.png', 'pro' => true],
        ['name' => 'Fluent Forms', 'id' => 'fluent_form', 'img' => 'fluent_form.png', 'pro' => true],
        ['name' => 'Forminator Forms', 'id' => 'forminator_form', 'img' => 'forminator_form.png', 'pro' => true],
        ['name' => 'MetForm', 'id' => 'met_form', 'img' => 'met_form.png', 'pro' => true],
        ['name' => 'JetFormBuilder', 'id' => 'jet_form', 'img' => 'jet_form.png', 'pro' => true],
        ['name' => 'SureForms', 'id' => 'sure_form', 'img' => 'sure_form.png', 'pro' => true],
        ['name' => 'Happyforms', 'id' => 'happy_form', 'img' => 'happy_form.png', 'pro' => true],
        ['name' => 'weForms', 'id' => 'we_form', 'img' => 'we_form.png', 'pro' => true],
        ['name' => 'WSForms', 'id' => 'ws_form', 'img' => 'ws_form.png', 'pro' => true],
        ['name' => 'NEX-Forms', 'id' => 'nex_forms', 'img' => 'nex_forms.png', 'pro' => true],
        ['name' => 'Kali Forms', 'id' => 'kali_forms', 'img' => 'kali_forms.png', 'pro' => true],
        ['name' => 'ARForms', 'id' => 'ar_forms', 'img' => 'ar_forms.png', 'pro' => true],

    ],
    'products' => [
        ['name' => 'Zoho Bigin',        'id' => 'zoho_bigin',         'img' => 'zoho_bigin.png'],
        ['name' => 'Zoho Campaigns',     'id' => 'zoho_campaign',      'img' => 'zoho_campaign.png'],
        ['name' => 'Zoho Inventory',     'id' => 'zoho_inventory',      'img' => 'zoho_inventory.png'],
        ['name' => 'Zoho Books',     'id' => 'zoho_books',      'img' => 'zoho_books.png'],
        ['name' => 'Zoho Invoice',     'id' => 'zoho_invoice',      'img' => 'zoho_invoice.png'],
        ['name' => 'Zoho CRM',          'id' => 'zoho_crm',           'img' => 'zoho_crm.png'],
        ['name' => 'Zoho Desk',         'id' => 'zoho_desk',          'img' => 'zoho_desk.png'],
    ]
];


/**
 * $force_mode:
 * - 'auto'    => use flags (current behavior)
 * - 'grouped' => free A–Z then Pro A–Z (ignore flags)
 * - 'flat'    => all A–Z (ignore flags)
 */
function integrazo_wz_get_plugins_sorted($plugins, $force_mode = 'auto')
{
    if (!is_array($plugins)) return [];

    $cmp = static function ($a, $b) {
        return strcasecmp($a['name'] ?? '', $b['name'] ?? '');
    };

    // Decide mode
    if ($force_mode === 'auto') {
        $pro_active  = function_exists('integrazo_wz_is_pro_active') ? (bool) integrazo_wz_is_pro_active() : false;
        $has_session = function_exists('integrazo_wz_session')      ? (bool) integrazo_wz_session()      : false;
        $mode = ($pro_active && $has_session) ? 'flat' : 'grouped';
    } else {
        $mode = $force_mode;
    }

    if ($mode === 'flat') {
        $all = array_values($plugins);
        usort($all, $cmp);
        return $all;
    }

    // grouped: free A–Z, then pro A–Z
    $free = [];
    $pro  = [];
    foreach ($plugins as $plg) {
        $is_pro = !empty($plg['pro']) && $plg['pro'];
        if ($is_pro) {
            $pro[] = $plg;
        } else {
            $free[] = $plg;
        }
    }
    usort($free, $cmp);
    usort($pro,  $cmp);
    return array_merge($free, $pro);
}

function integrazo_wz_get_products_sorted($products, $force_mode = 'auto')
{
    if (!is_array($products)) return [];

    $cmp = static function ($a, $b) {
        return strcasecmp($a['name'] ?? '', $b['name'] ?? '');
    };

    // Decide mode
    if ($force_mode === 'auto') {
        $pro_active  = function_exists('integrazo_wz_is_pro_active') ? (bool) integrazo_wz_is_pro_active() : false;
        $has_session = function_exists('integrazo_wz_session')      ? (bool) integrazo_wz_session()      : false;
        $mode = ($pro_active && $has_session) ? 'flat' : 'grouped';
    } else {
        $mode = $force_mode;
    }

    if ($mode === 'flat') {
        $all = array_values($products);
        usort($all, $cmp);
        return $all;
    }

    // grouped: free A–Z, then pro A–Z
    $free = [];
    $pro  = [];
    foreach ($products as $prod) {
        $is_pro = !empty($prod['pro']) && $prod['pro'];
        if ($is_pro) {
            $pro[] = $prod;
        } else {
            $free[] = $prod;
        }
    }
    usort($free, $cmp);
    usort($pro,  $cmp);
    return array_merge($free, $pro);
}


/**
 * Return only Pro product IDs, sorted A–Z by product name.
 *
 * @param array $products The products array (e.g., $integration_sources['products'])
 * @return array List of product IDs (strings) that are marked 'pro' => true
 */
function integrazo_wz_get_pro_product_ids($products)
{
    if (!is_array($products)) return [];

    // Filter to pro-only
    $pro_only = array_filter($products, static function ($prod) {
        return !empty($prod['pro']);
    });

    // Sort A–Z by name (case-insensitive)
    usort($pro_only, static function ($a, $b) {
        return strcasecmp($a['name'] ?? '', $b['name'] ?? '');
    });

    // Return only IDs
    return array_values(array_map(static function ($prod) {
        return (string) ($prod['id'] ?? '');
    }, $pro_only));
}


/**
 * Return only Pro plugin IDs, sorted A–Z by plugin name.
 *
 * @param array $plugins The plugins array (e.g., $integration_sources['plugins'])
 * @return array List of plugin IDs (strings) that are marked 'pro' => true
 */
function integrazo_wz_get_pro_plugin_ids($plugins)
{
    if (!is_array($plugins)) return [];

    // Filter to pro-only
    $pro_only = array_filter($plugins, static function ($plugin) {
        return !empty($plugin['pro']);
    });

    // Sort A–Z by name (case-insensitive)
    usort($pro_only, static function ($a, $b) {
        return strcasecmp($a['name'] ?? '', $b['name'] ?? '');
    });

    // Return only IDs
    return array_values(array_map(static function ($plugin) {
        return (string) ($plugin['id'] ?? '');
    }, $pro_only));
}
