<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class INTEGRAZO_WZ_Event_Details
{
    /**
     * Render event or form field selection based on the plugin type.
     *
     * @param array $integration_details
     * @return mixed
     */
    public static function render($integration_details)
    {
        $integration_data = json_decode($integration_details['integration_data'] ?? '', true);
        $from_plugin = $integration_details['from_plugin'] ?? '';

        switch ($from_plugin) {
            case 'woocommerce':
                return INTEGRAZO_WZ_WooCommerce_Helper::get_events();
            case 'wordpress_org':
                return INTEGRAZO_WZ_WordPressCom_Helper::get_events();
            case 'contact_form_7':
                return INTEGRAZO_WZ_CF7_Helper::get_all_forms();

            case 'elementor_form':
                return INTEGRAZO_WZ_Elementor_Helper::get_all_forms();

            case 'wp_form':
                return INTEGRAZO_WZ_WPForms_Helper::get_all_forms();

            case 'gravity_form':
            case 'ninja_form':
            case 'formidable_form':
            case 'everest_form':
            case 'fluent_form':
            case 'forminator_form':
            case 'met_form':
            case 'jet_form':
            case 'sure_form':
            case 'form_maker':
            case 'happy_form':
            case 'we_form':
            case 'ws_form':
            case 'quill_forms':
            case 'nex_forms':
            case 'kali_forms':
            case 'ar_forms':
                if (integrazo_wz_is_pro_active()) {
                    return self::get_pro_form_data($from_plugin);
                }
                return null;

            default:
                return null;
        }
    }
    /**
     * Helper to call correct Pro helper class.
     *
     * @param string $from_plugin
     * @return mixed|null
     */
    private static function get_pro_form_data($from_plugin)
    {
        switch ($from_plugin) {
            case 'gravity_form':
                return INTEGRAZO_WZ_GravityForms_Helper::get_all_forms();
            case 'ninja_form':
                return INTEGRAZO_WZ_NinjaForms_Helper::get_all_forms();
            case 'formidable_form':
                return INTEGRAZO_WZ_FormidableForms_Helper::get_all_forms();
            case 'everest_form':
                return INTEGRAZO_WZ_EverestForms_Helper::get_all_forms();
            case 'fluent_form':
                return INTEGRAZO_WZ_FluentForms_Helper::get_all_forms();
            case 'forminator_form':
                return INTEGRAZO_WZ_Forminator_Helper::get_all_forms();
            case 'met_form':
                return INTEGRAZO_WZ_MetForm_Helper::get_all_forms();
            case 'jet_form':
                return INTEGRAZO_WZ_JetFormBuilder_Helper::get_all_forms();
            case 'sure_form':
                return INTEGRAZO_WZ_SureForms_Helper::get_all_forms();
            case 'form_maker':
                return INTEGRAZO_WZ_FormMaker_Helper::get_all_forms();
            case 'happy_form':
                return INTEGRAZO_WZ_HappyForms_Helper::get_all_forms();
            case 'we_form':
                return INTEGRAZO_WZ_weForms_Helper::get_all_forms();
            case 'ws_form':
                return INTEGRAZO_WZ_WSForm_Helper::get_all_forms();
            case 'quill_forms':
                return INTEGRAZO_WZ_QuillForm_Helper::get_all_forms();
            case 'nex_forms':
                return INTEGRAZO_WZ_NEXForms_Helper::get_all_forms();
            case 'kali_forms':
                return INTEGRAZO_WZ_KaliForms_Helper::get_all_forms();
            case 'ar_forms':
                return INTEGRAZO_WZ_ARForms_Helper::get_all_forms();

            default:
                return null;
        }
    }
}
