<?php

// Exit if accessed directly.
if (! defined('ABSPATH')) {
    exit;
}

class INTEGRAZO_WZ_Auth_Fields
{
    public static function get_fields_by_service($service)
    {
        switch ($service) {

            case 'zoho_crm':
                return [
                    'fields' => [
                        'dc' => [
                            'label'   => 'Data Center',
                            'type'    => 'select',
                            'options' => [
                                'zoho.com'     => 'Zoho.com (US)',
                                'zoho.in'      => 'Zoho.in (India)',
                                'zoho.eu'      => 'Zoho.eu (EU)',
                                'zoho.uk'      => 'Zoho.uk (UK)',
                                'zoho.jp'      => 'Zoho.jp (Japan)',
                                'zohocloud.ca' => 'Zohocloud.ca (Canada)',
                                'zoho.sa'      => 'Zoho.sa (Saudi Arabia)',
                                'zoho.com.cn'  => 'Zoho.com.cn (China)',
                                'zoho.com.au'  => 'Zoho.com.au (Australia)',
                            ],
                            'note' => '',
                            'help' => 'Select your Zoho Data Center (e.g. US→Zoho.com, IN→Zoho.in, EU→Zoho.eu).',
                        ],
                    ],
                    'common_note'   => 'After clicking Connect, you will be redirected to Zoho. Once you approve access, you will return here automatically.',
                    'action'        => 'integrazo_wz_zoho_crm_account_authentication',
                    'update_action' => 'integrazo_wz_zoho_crm_account_update',
                ];

            case 'zoho_desk':
                return [
                    'fields' => [
                        'dc' => [
                            'label'   => 'Data Center',
                            'type'    => 'select',
                            'options' => [
                                'zoho.com'     => 'Zoho.com (US)',
                                'zoho.in'      => 'Zoho.in (India)',
                                'zoho.eu'      => 'Zoho.eu (EU)',
                                'zoho.uk'      => 'Zoho.uk (UK)',
                                'zoho.jp'      => 'Zoho.jp (Japan)',
                                'zohocloud.ca' => 'Zohocloud.ca (Canada)',
                                'zoho.sa'      => 'Zoho.sa (Saudi Arabia)',
                                'zoho.com.cn'  => 'Zoho.com.cn (China)',
                                'zoho.com.au'  => 'Zoho.com.au (Australia)',
                            ],
                            'note' => '',
                            'help' => 'Select your Zoho Data Center (e.g. US→Zoho.com, IN→Zoho.in, EU→Zoho.eu).',
                        ],
                    ],
                    'common_note'   => 'After clicking Connect, you will be redirected to Zoho. Once you approve access, you will return here automatically.',
                    'action'        => 'integrazo_wz_zoho_desk_account_authentication',
                    'update_action' => 'integrazo_wz_zoho_desk_account_update',
                ];

            case 'zoho_campaign':
                return [
                    'fields' => [
                        'dc' => [
                            'label'   => 'Data Center',
                            'type'    => 'select',
                            'options' => [
                                'zoho.com'     => 'Zoho.com (US)',
                                'zoho.in'      => 'Zoho.in (India)',
                                'zoho.eu'      => 'Zoho.eu (EU)',
                                'zoho.uk'      => 'Zoho.uk (UK)',
                                'zoho.jp'      => 'Zoho.jp (Japan)',
                                'zohocloud.ca' => 'Zohocloud.ca (Canada)',
                                'zoho.sa'      => 'Zoho.sa (Saudi Arabia)',
                                'zoho.com.cn'  => 'Zoho.com.cn (China)',
                                'zoho.com.au'  => 'Zoho.com.au (Australia)',
                            ],
                            'note' => '',
                            'help' => 'Select your Zoho Data Center (e.g. US→Zoho.com, IN→Zoho.in, EU→Zoho.eu).',
                        ],
                    ],
                    'common_note'   => 'After clicking Connect, you will be redirected to Zoho. Once you approve access, you will return here automatically.',
                    'action'        => 'integrazo_wz_zoho_campaigns_account_authentication',
                    'update_action' => 'integrazo_wz_zoho_campaigns_account_update',
                ];
            case 'zoho_inventory':
                return [
                    'fields' => [
                        'dc' => [
                            'label'   => 'Data Center',
                            'type'    => 'select',
                            'options' => [
                                'zoho.com'     => 'Zoho.com (US)',
                                'zoho.in'      => 'Zoho.in (India)',
                                'zoho.eu'      => 'Zoho.eu (EU)',
                                'zoho.uk'      => 'Zoho.uk (UK)',
                                'zoho.jp'      => 'Zoho.jp (Japan)',
                                'zohocloud.ca' => 'Zohocloud.ca (Canada)',
                                'zoho.sa'      => 'Zoho.sa (Saudi Arabia)',
                                'zoho.com.cn'  => 'Zoho.com.cn (China)',
                                'zoho.com.au'  => 'Zoho.com.au (Australia)',
                            ],
                            'note' => '',
                            'help' => 'Select your Zoho Data Center (e.g. US → Zoho.com, IN → Zoho.in, EU → Zoho.eu).',
                        ],
                    ],

                    // Message below input fields
                    'common_note' => 'After clicking Connect, you will be redirected to Zoho Inventory. Approve the access to continue.',

                    // OAuth Connect action
                    'action' => 'integrazo_wz_zoho_inventory_account_authentication',

                    // For updating saved account details
                    'update_action' => 'integrazo_wz_zoho_inventory_account_update',
                ];
                case 'zoho_books':
                return [
                    'fields' => [
                        'dc' => [
                            'label'   => 'Data Center',
                            'type'    => 'select',
                            'options' => [
                                'zoho.com'     => 'Zoho.com (US)',
                                'zoho.in'      => 'Zoho.in (India)',
                                'zoho.eu'      => 'Zoho.eu (EU)',
                                'zoho.uk'      => 'Zoho.uk (UK)',
                                'zoho.jp'      => 'Zoho.jp (Japan)',
                                'zohocloud.ca' => 'Zohocloud.ca (Canada)',
                                'zoho.sa'      => 'Zoho.sa (Saudi Arabia)',
                                'zoho.com.cn'  => 'Zoho.com.cn (China)',
                                'zoho.com.au'  => 'Zoho.com.au (Australia)',
                            ],
                            'note' => '',
                            'help' => 'Select your Zoho Data Center (e.g. US → Zoho.com, IN → Zoho.in, EU → Zoho.eu).',
                        ],
                    ],

                    // Message below input fields
                    'common_note' => 'After clicking Connect, you will be redirected to Zoho Books. Approve the access to continue.',

                    // OAuth Connect action
                    'action' => 'integrazo_wz_zoho_books_account_authentication',

                    // For updating saved account details
                    'update_action' => 'integrazo_wz_zoho_books_account_update',
                ];
            case 'zoho_invoice':
                return [
                    'fields' => [
                        'dc' => [
                            'label'   => 'Data Center',
                            'type'    => 'select',
                            'options' => [
                                'zoho.com'     => 'Zoho.com (US)',
                                'zoho.in'      => 'Zoho.in (India)',
                                'zoho.eu'      => 'Zoho.eu (EU)',
                                'zoho.uk'      => 'Zoho.uk (UK)',
                                'zoho.jp'      => 'Zoho.jp (Japan)',
                                'zohocloud.ca' => 'Zohocloud.ca (Canada)',
                                'zoho.sa'      => 'Zoho.sa (Saudi Arabia)',
                                'zoho.com.cn'  => 'Zoho.com.cn (China)',
                                'zoho.com.au'  => 'Zoho.com.au (Australia)',
                            ],
                            'note' => '',
                            'help' => 'Select your Zoho Data Center (e.g. US → Zoho.com, IN → Zoho.in, EU → Zoho.eu).',
                        ],
                    ],

                    // Message below input fields
                    'common_note' => 'After clicking Connect, you will be redirected to Zoho Invoice. Approve the access to continue.',

                    // OAuth Connect action
                    'action' => 'integrazo_wz_zoho_invoice_account_authentication',

                    // For updating saved account details
                    'update_action' => 'integrazo_wz_zoho_invoice_account_update',
                ];

            case 'zoho_bigin':
                return [
                    'fields' => [
                        'dc' => [
                            'label'   => 'Data Center',
                            'type'    => 'select',
                            'options' => [
                                'zoho.com'     => 'Zoho.com (US)',
                                'zoho.in'      => 'Zoho.in (India)',
                                'zoho.eu'      => 'Zoho.eu (EU)',
                                'zoho.uk'      => 'Zoho.uk (UK)',
                                'zoho.jp'      => 'Zoho.jp (Japan)',
                                'zohocloud.ca' => 'Zohocloud.ca (Canada)',
                                'zoho.sa'      => 'Zoho.sa (Saudi Arabia)',
                                'zoho.com.cn'  => 'Zoho.com.cn (China)',
                                'zoho.com.au'  => 'Zoho.com.au (Australia)',
                            ],
                            'note' => '',
                            'help' => 'Select your Zoho Data Center (e.g. US→Zoho.com, IN→Zoho.in, EU→Zoho.eu).',
                        ],
                    ],
                    'common_note'   => 'After clicking Connect, you will be redirected to Zoho. Once you approve access, you will return here automatically.',
                    'action'        => 'integrazo_wz_zoho_bigin_account_authentication',
                    'update_action' => 'integrazo_wz_zoho_bigin_account_update',
                ];
            default:
                return [
                    'fields' => [],
                    'common_note' => ''
                ];
        }
    }
}
