<?php
if (!defined('ABSPATH')) {
    exit;
}

require_once INTEGRAZO_WZ_PLUGIN_DIR . 'src/products/zoho_inventory/util.php';
require_once INTEGRAZO_WZ_PLUGIN_DIR . 'src/products/common/class-zoho-base.php';
require_once INTEGRAZO_WZ_PLUGIN_DIR . 'src/products/common/trait-zoho-organizations.php';
require_once INTEGRAZO_WZ_PLUGIN_DIR . 'src/products/common/trait-zoho-contacts.php';

if (!class_exists('INTEGRAZO_WZ_Zoho_Inventory')) {

    class INTEGRAZO_WZ_Zoho_Inventory extends INTEGRAZO_WZ_ZOHO_Base
    {
        use INTEGRAZO_WZ_ZOHO_Contacts_Trait;
        use INTEGRAZO_WZ_ZOHO_Organizations_Trait;

        public function __construct(array $account_details = [])
        {

            parent::__construct($account_details, 'inventory');
        }

        public function get_events(): array
        {
            return [
                [
                    'api_name'     => 'create_contact',
                    'display_name' => 'Add New Contact',
                    'pro'          => true,
                    'priority'     => 10, // Runs first
                ],
                [
                    'api_name'     => 'update_contact',
                    'display_name' => 'Create or Update Contact',
                    'pro'          => false,
                    'priority'     => 20,
                ],
                [
                    'api_name'     => 'create_item',
                    'display_name' => 'Add New Item',
                    'pro'          => false,
                    'priority'     => 30,
                ],
                [
                    'api_name'     => 'update_item',
                    'display_name' => 'Create or Update Item',
                    'pro'          => false,
                    'priority'     => 40,
                ],
                [
                    'api_name'     => 'create_inventory_adjustment',
                    'display_name' => 'Record Inventory Adjustment',
                    'pro'          => false,
                    'priority'     => 50,
                ],
                [
                    'api_name'     => 'create_sales_order',
                    'display_name' => 'Create Sales Order',
                    'pro'          => false,
                    'priority'     => 60,
                ],
                [
                    'api_name'     => 'create_invoice',
                    'display_name' => 'Generate Invoice',
                    'pro'          => false,
                    'priority'     => 70, // Runs last
                ],
            ];
        }
    }
}
