<?php
// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit; // Prevent direct access to the file.
}

// Check if the class already exists to avoid redeclaration.
if (!class_exists('INTEGRAZO_WZ_Product_Util')) {

    /**
     * Utility class for handling Zoho-related operations, such as access token management.
     */
    class INTEGRAZO_WZ_Product_Util
    {
        /**
         * Helper function to create a standardized error response.
         *
         * @param string $error_code
         * @param string $message
         * @param mixed $body
         * @return array
         */
        public static function create_error_response($error_code, $message, $body = null)
        {
            return [
                'category' => $error_code,
                'message'  => $message,
                'body'     => $body
            ];
        }
    }
}
