<?php

// Exit if accessed directly.
if (! defined('ABSPATH')) {
    exit;
}

$selected_record_action = !empty($integration_details["record_action"]) ? $integration_details["record_action"] : 'add';

// If no options, skip rendering
if (!empty($record_action_options)) :
?>
    <br><br>
    <div style="display: flex; margin-bottom: 15px;">
        <label for="integrazo_wz_form_select" class="integrazo-wz-setup-lable" style="width: 150px; margin-right: 10px;">
            <?php esc_html_e('Record Action:', 'integrazo-integration-for-zoho-apps'); ?>
            <div class="integrazo-wz-helpicon-help-icon-wrapper" style="display: inline-block; margin-left: 5px;">
                <span class="integrazo-wz-helpicon-help-icon">?</span>
                <div class="integrazo-wz-helpicon-help-tooltip">
                    <p><?php esc_html_e('Choose how records should be handled.', 'integrazo-integration-for-zoho-apps'); ?></p>
                </div>
            </div>
        </label>

        <div style="display: inline-grid; gap: 10px;">
            <?php foreach ($record_action_options as $option) :
                $is_disabled = (!$session && !empty($option['disabled']));
                $is_default  = !empty($option['default']);
                // Fallback: if nothing selected, pick the default
                $selected_value = $selected_record_action ?: ($is_default ? $option['value'] : '');
            ?>
                <label style="<?php echo $is_disabled ? 'color: #66666699;' : ''; ?>">
                    <input type="radio"
                        name="integrazo_wz_record_action"
                        value="<?php echo esc_attr($option['value']); ?>"
                        <?php checked($option['value'], $selected_value); ?>
                        <?php echo $is_disabled ? 'disabled' : ''; ?>>
                    <span <?php echo $is_disabled ? 'title="This feature comes in Premium version"' : ''; ?>>
                        <?php echo esc_html($option['label']); ?>
                    </span>
                </label>
            <?php endforeach; ?>

        </div>
    </div>
<?php endif; ?>


<?php
$filter_criteria = !empty($integration_details["filter_criteria"]) ? $integration_details["filter_criteria"] : 'no';
$filter_criteria_json = $integration_details["filter_criteria_json"];
?>
<br><br>
<div style="display: flex; margin-bottom: 15px;">
    <label for="integrazo_wz_form_select" class="integrazo-wz-setup-lable" style="width: 150px; margin-right: 10px;">
        <?php esc_html_e('Enable Filters?', 'integrazo-integration-for-zoho-apps'); ?>
        <div class="integrazo-wz-helpicon-help-icon-wrapper" style="display: inline-block; margin-left: 5px;">
            <span class="integrazo-wz-helpicon-help-icon">?</span>
            <div class="integrazo-wz-helpicon-help-tooltip">
                <p><?php esc_html_e('Apply conditions to control when data should be sent. Use filters to include or exclude based on specific values.', 'integrazo-integration-for-zoho-apps'); ?></p>
            </div>
        </div>
    </label>
    <div style="display: flex; gap: 20px;">
        <label>
            <input type="radio" name="filter_criteria" value="yes" <?php checked('yes', $filter_criteria); ?>>
            <?php esc_html_e('Yes', 'integrazo-integration-for-zoho-apps'); ?>
        </label>
        <label>
            <input type="radio" name="filter_criteria" value="no" <?php checked('no', $filter_criteria); ?>>
            <?php esc_html_e('No', 'integrazo-integration-for-zoho-apps'); ?>
        </label>
    </div>
</div>



<?php if ($filter_criteria === 'no') : ?>

    <!-- Filter Content -->
    <div class="integrazo-wz-setup-filter-content">
        <div class="integrazo-wz-setup-filter-clear-all" onclick="integrazo_wz_clearAll()" style="cursor:pointer; color: blue; text-align: right;">Clear All</div>
        <div id="integrazo-wz-setup-filter-group-container" class="integrazo-wz-setup-filter-group-container">
            <div class="integrazo-wz-setup-filter-block">
                <div class="integrazo-wz-setup-filter-group">
                    <div class="integrazo-wz-setup-filter-row">
                        <select class="integrazo-wz-setup-filter-field">
                            <option value="" disabled selected>Select Field</option>
                            <?php foreach ($raw_form_fields as $field) : ?>
                                <option value="<?php echo esc_attr($field['name']); ?>">
                                    <?php echo esc_html($field['label']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>

                        <select class="integrazo-wz-setup-filter-condition">
                            <option value="" disabled selected>Choose Condition</option>
                            <option value="contains">Contains</option>
                            <option value="not_contains">Does Not Contain</option>
                            <option value="equals">Equals</option>
                            <option value="not_equals">Does Not Equal</option>
                            <option value="starts_with">Starts With</option>
                            <option value="ends_with">Ends With</option>
                            <option value="greater_than">Greater Than</option>
                            <option value="less_than">Less Than</option>
                            <option value="is_empty">Is Empty</option>
                            <option value="is_not_empty">Is Not Empty</option>
                        </select>

                        <input type="text" class="integrazo-wz-setup-filter-value" placeholder="Enter value" />

                        <div class="integrazo-wz-setup-filter-actions">
                            <button type="button" class="integrazo-wz-setup-filter-add-icon">+</button>
                            <button type="button" class="integrazo-wz-setup-filter-close-icon">×</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php else : ?>

    <!-- Filter Content -->
    <div class="integrazo-wz-setup-filter-content" style="display:block;">
        <div class="integrazo-wz-setup-filter-clear-all" onclick="integrazo_wz_clearAll()" style="cursor:pointer; color: blue; text-align: right;">Clear All</div>
        <div id="integrazo-wz-setup-filter-group-container" class="integrazo-wz-setup-filter-group-container">
            <?php
            $filter_data = json_decode($filter_criteria_json, true);
            $total_blocks = count($filter_data);
            if (!empty($filter_data)) :
                foreach ($filter_data as $index => $item) :
            ?>
                    <div class="integrazo-wz-setup-filter-block">
                        <?php if ($index > 0) : ?>
                            <div class="integrazo-wz-setup-filter-connector">
                                <select class="integrazo-wz-setup-filter-logic">
                                    <option value="AND" <?php selected($filter_data[$index - 1]['logic'], 'AND'); ?>>AND</option>
                                    <option value="OR" <?php selected($filter_data[$index - 1]['logic'], 'OR'); ?>>OR</option>
                                </select>
                            </div>
                        <?php endif; ?>
                        <div class="integrazo-wz-setup-filter-group">
                            <div class="integrazo-wz-setup-filter-row">
                                <select class="integrazo-wz-setup-filter-field">
                                    <option value="" disabled>Select Field</option>
                                    <?php foreach ($raw_form_fields as $field) : ?>
                                        <option value="<?php echo esc_attr($field['name']); ?>" <?php selected($item['field'], $field['name']); ?>>
                                            <?php echo esc_html($field['label']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>

                                <select class="integrazo-wz-setup-filter-condition">
                                    <option value="" disabled>Choose Condition</option>
                                    <option value="contains" <?php selected($item['condition'], 'contains'); ?>>Contains</option>
                                    <option value="not_contains" <?php selected($item['condition'], 'not_contains'); ?>>Does Not Contain</option>
                                    <option value="equals" <?php selected($item['condition'], 'equals'); ?>>Equals</option>
                                    <option value="not_equals" <?php selected($item['condition'], 'not_equals'); ?>>Does Not Equal</option>
                                    <option value="starts_with" <?php selected($item['condition'], 'starts_with'); ?>>Starts With</option>
                                    <option value="ends_with" <?php selected($item['condition'], 'ends_with'); ?>>Ends With</option>
                                    <option value="greater_than" <?php selected($item['condition'], 'greater_than'); ?>>Greater Than</option>
                                    <option value="less_than" <?php selected($item['condition'], 'less_than'); ?>>Less Than</option>
                                    <option value="is_empty" <?php selected($item['condition'], 'is_empty'); ?>>Is Empty</option>
                                    <option value="is_not_empty" <?php selected($item['condition'], 'is_not_empty'); ?>>Is Not Empty</option>
                                </select>

                                <input type="text" class="integrazo-wz-setup-filter-value" placeholder="Enter value" value="<?php echo esc_attr($item['value']); ?>" />

                                <div class="integrazo-wz-setup-filter-actions">
                                    <button type="button" class="integrazo-wz-setup-filter-add-icon">+</button>
                                    <button type="button" class="integrazo-wz-setup-filter-close-icon">×</button>
                                </div>
                            </div>
                        </div>
                    </div>
            <?php
                endforeach;
            endif;
            ?>
        </div>
    </div>
<?php endif; ?>