<?php
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Pure field definitions (no HTTP calls).
 */
if (!class_exists('INTEGRAZO_WZ_Field_Schemas')) {
    class INTEGRAZO_WZ_Field_Schemas
    {
        public static function create_contact_fields(): array
        {
            return [
                // ======= REQUIRED & CORE IDENTIFICATION =======
                [
                    'api_name'         => 'contact_name',
                    'field_label'      => 'Display name',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => true,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'email',
                    'field_label'      => 'Email address',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => true,
                    'pick_list_values' => [],
                ],

                // ======= BASIC PROFILE =======
                [
                    'api_name'         => 'first_name',
                    'field_label'      => 'First name',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'last_name',
                    'field_label'      => 'Last name',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'company_name',
                    'field_label'      => 'Company name',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'customer_sub_type',
                    'field_label'      => 'Customer Type',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => true,
                    'pick_list_values' => [
                        ['actual_value' => 'business',  'display_value' => 'Business'],
                        ['actual_value' => 'individual', 'display_value' => 'Individual'],
                    ],
                ],
                [
                    'api_name'         => 'contact_salutation',
                    'field_label'      => 'Contact Salutation',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [
                        ['actual_value' => 'Mr.',  'display_value' => 'Mr.'],
                        ['actual_value' => 'Ms.',  'display_value' => 'Ms.'],
                        ['actual_value' => 'Mrs.', 'display_value' => 'Mrs.'],
                        ['actual_value' => 'Dr.',  'display_value' => 'Dr.'],
                    ],
                ],

                // ======= COMMUNICATION =======
                [
                    'api_name'         => 'phone',
                    'field_label'      => 'Phone number',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'mobile',
                    'field_label'      => 'Mobile number',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'language_code',
                    'field_label'      => 'Language Code',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [
                        ['actual_value' => 'de', 'display_value' => 'German'],
                        ['actual_value' => 'en', 'display_value' => 'English'],
                        ['actual_value' => 'es', 'display_value' => 'Spanish'],
                        ['actual_value' => 'fr', 'display_value' => 'French'],
                        ['actual_value' => 'it', 'display_value' => 'Italian'],
                        ['actual_value' => 'ja', 'display_value' => 'Japanese'],
                        ['actual_value' => 'nl', 'display_value' => 'Dutch'],
                        ['actual_value' => 'pt', 'display_value' => 'Portuguese'],
                        ['actual_value' => 'sv', 'display_value' => 'Swedish'],
                        ['actual_value' => 'zh', 'display_value' => 'Chinese'],
                    ],
                ],

                // ======= BILLING ADDRESS =======
                ['api_name' => 'billing_address_attention', 'field_label' => 'Billing address - Attention',     'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],
                ['api_name' => 'billing_address_address',   'field_label' => 'Billing address - Line 1',       'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],
                ['api_name' => 'billing_address_street2',   'field_label' => 'Billing address - Line 2',       'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],
                ['api_name' => 'billing_address_city',      'field_label' => 'Billing address - City',         'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],
                ['api_name' => 'billing_address_state',     'field_label' => 'Billing address - State',        'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],
                ['api_name' => 'billing_address_zip',       'field_label' => 'Billing address - ZIP code',     'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],
                ['api_name' => 'billing_address_country',   'field_label' => 'Billing address - Country',      'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],
                ['api_name' => 'billing_address_fax',       'field_label' => 'Billing address - Fax number',   'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],
                ['api_name' => 'billing_address_phone',     'field_label' => 'Billing address - Phone number', 'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],

                // ======= SHIPPING ADDRESS =======
                ['api_name' => 'shipping_address_attention', 'field_label' => 'Shipping address - Attention',   'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],
                ['api_name' => 'shipping_address_address',   'field_label' => 'Shipping address - Line 1',     'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],
                ['api_name' => 'shipping_address_street2',   'field_label' => 'Shipping address - Street 2',   'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],
                ['api_name' => 'shipping_address_city',      'field_label' => 'Shipping address - City',       'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],
                ['api_name' => 'shipping_address_state',     'field_label' => 'Shipping address - State',      'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],
                ['api_name' => 'shipping_address_zip',       'field_label' => 'Shipping address - ZIP code',   'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],
                ['api_name' => 'shipping_address_country',   'field_label' => 'Shipping address - Country',    'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],
                ['api_name' => 'shipping_address_fax',       'field_label' => 'Shipping address - Fax number', 'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],
                ['api_name' => 'shipping_address_phone',     'field_label' => 'Shipping address - Phone number', 'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],

                // ======= TAX & COMPLIANCE =======
                [
                    'api_name'         => 'gst_treatment',
                    'field_label'      => 'GST Treatment',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [
                        ['actual_value' => 'business_gst',  'display_value' => 'Business GST'],
                        ['actual_value' => 'business_none', 'display_value' => 'Business none'],
                        ['actual_value' => 'overseas',      'display_value' => 'Overseas'],
                        ['actual_value' => 'consumer',      'display_value' => 'Consumer'],
                    ],
                ],
                [
                    'api_name'         => 'gst_no',
                    'field_label'      => 'GST number',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'pan_no',
                    'field_label'      => 'PAN no',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'place_of_contact',
                    'field_label'      => 'Place of contact',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'vat_treatment',
                    'field_label'      => 'VAT treatment',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'vat_reg_no',
                    'field_label'      => 'VAT registration number',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'avatax_exempt_no',
                    'field_label'      => 'Avatax exempt number',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'avatax_use_code',
                    'field_label'      => 'Avatax use code',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],

                // ======= FINANCIAL / SYSTEM =======
                [
                    'api_name'         => 'currency_id',
                    'field_label'      => 'Currency ID',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'payment_terms',
                    'field_label'      => 'Payment terms',
                    'data_type'        => 'number',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [
                        ['actual_value' => 0,   'display_value' => 'Payment Received'],
                        ['actual_value' => 15,  'display_value' => 'Net 15'],
                        ['actual_value' => 30,  'display_value' => 'Net 30'],
                        ['actual_value' => 45,  'display_value' => 'Net 45'],
                        ['actual_value' => 60,  'display_value' => 'Net 60'],
                        ['actual_value' => -2,  'display_value' => 'Due end of the month'],
                        ['actual_value' => -3,  'display_value' => 'Due end of next month'],
                    ],
                ],
                [
                    'api_name'         => 'pricebook_id',
                    'field_label'      => 'Pricebook',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'tax_id',
                    'field_label'      => 'Tax ID',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'tax_exemption_code',
                    'field_label'      => 'Tax exemption code',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'tax_authority_id',
                    'field_label'      => 'Tax authority ID',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'country_code',
                    'field_label'      => 'Country code',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],

                // ======= SOCIAL & NOTES =======
                [
                    'api_name'         => 'website',
                    'field_label'      => 'Website',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'twitter',
                    'field_label'      => 'Twitter',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'facebook',
                    'field_label'      => 'Facebook',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'skype',
                    'field_label'      => 'Skype',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'designation',
                    'field_label'      => 'Designation',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'department',
                    'field_label'      => 'Department',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'notes',
                    'field_label'      => 'Remark',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'is_taxable',
                    'field_label'      => 'Is taxable?',
                    'data_type'        => 'boolean',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [
                        ['actual_value' => 'true',  'display_value' => 'Yes'],
                        ['actual_value' => 'false', 'display_value' => 'No'],
                    ],
                ],

                // ======= EXCHANGE =======
                [
                    'api_name'         => 'exchange_rate',
                    'field_label'      => 'Exchange rate',
                    'data_type'        => 'number',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
            ];
        }

        /** Inventory-only: item fields (if you need them elsewhere). */
        public static function create_items_fields(): array
        {
            return [
                // ======= IDENTIFIERS =======
                [
                    'api_name'         => 'sku',
                    'field_label'      => 'SKU',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => true,
                    'pick_list_values' => [],
                ],
                // ======= REQUIRED & TYPE =======
                [
                    'api_name'         => 'product_type',
                    'field_label'      => 'Type',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => true,
                    'pick_list_values' => [
                        ['actual_value' => 'goods',   'display_value' => 'Goods'],
                        ['actual_value' => 'service', 'display_value' => 'Service'],
                    ],
                ],
                [
                    'api_name'         => 'name',
                    'field_label'      => 'Name',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => true,
                    'pick_list_values' => [],
                ],

                [
                    'api_name'         => 'item_type',
                    'field_label'      => 'Item Type',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [
                        ['actual_value' => 'inventory',           'display_value' => 'Inventory'],
                        ['actual_value' => 'sales',               'display_value' => 'Sales'],
                        ['actual_value' => 'purchases',           'display_value' => 'Purchases'],
                        ['actual_value' => 'sales_and_purchases', 'display_value' => 'Sales & Purchases'],
                    ],
                ],



                // ======= UNITS & CATEGORIZATION =======
                [
                    'api_name'         => 'unit',
                    'field_label'      => 'Unit',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => true,
                    'pick_list_values' => [
                        ['actual_value' => 'box', 'display_value' => 'box'],
                        ['actual_value' => 'cm',  'display_value' => 'cm'],
                        ['actual_value' => 'dz',  'display_value' => 'dz'],
                        ['actual_value' => 'ft',  'display_value' => 'ft'],
                        ['actual_value' => 'g',   'display_value' => 'g'],
                        ['actual_value' => 'in',  'display_value' => 'in'],
                        ['actual_value' => 'kg',  'display_value' => 'kg'],
                        ['actual_value' => 'km',  'display_value' => 'km'],
                        ['actual_value' => 'lb',  'display_value' => 'lb'],
                        ['actual_value' => 'mg',  'display_value' => 'mg'],
                        ['actual_value' => 'ml',  'display_value' => 'ml'],
                        ['actual_value' => 'm',   'display_value' => 'm'],
                        ['actual_value' => 'pcs', 'display_value' => 'pcs'],
                    ],
                ],
                [
                    'api_name'         => 'category_id',
                    'field_label'      => 'Category',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'brand',
                    'field_label'      => 'Brand',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'manufacturer',
                    'field_label'      => 'Manufacturer',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],

                // ======= COMPLIANCE =======
                [
                    'api_name'         => 'hsn_or_sac',
                    'field_label'      => 'HSN Code',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],

                // ======= TAXATION =======
                [
                    'api_name'         => 'is_taxable',
                    'field_label'      => 'Is taxable?',
                    'data_type'        => 'boolean',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [
                        ['actual_value' => 'true',  'display_value' => 'Yes'],
                        ['actual_value' => 'false', 'display_value' => 'No'],
                    ],
                ],
                [
                    'api_name'         => 'tax_id',
                    'field_label'      => 'Tax ID',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'tax_exemption_code',
                    'field_label'      => 'Tax exemption code',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'inter_tax_id',
                    'field_label'      => 'Inter state tax ID',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'intra_tax_id',
                    'field_label'      => 'Intra state tax ID',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],

                // ======= PACKAGE DETAILS =======
                [
                    'api_name'         => 'package_details_length',
                    'field_label'      => 'Package details - length',
                    'data_type'        => 'number',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'package_details_width',
                    'field_label'      => 'Package details - width',
                    'data_type'        => 'number',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'package_details_height',
                    'field_label'      => 'Package details - height',
                    'data_type'        => 'number',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'package_details_weight',
                    'field_label'      => 'Package details - weight',
                    'data_type'        => 'number',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],

                // ======= IDENTIFIER CODES =======
                [
                    'api_name'         => 'upc',
                    'field_label'      => 'UPC',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'isbn',
                    'field_label'      => 'ISBN',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'ean',
                    'field_label'      => 'EAN',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'part_number',
                    'field_label'      => 'Part number',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],

                // ======= SALES INFO =======
                [
                    'api_name'         => 'rate',
                    'field_label'      => 'Sales rate',
                    'data_type'        => 'number',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'account_id',
                    'field_label'      => 'Sales account ID',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'description',
                    'field_label'      => 'Sales description',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],

                // ======= PURCHASE INFO =======
                [
                    'api_name'         => 'purchase_rate',
                    'field_label'      => 'Purchase rate',
                    'data_type'        => 'number',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'purchase_account_id',
                    'field_label'      => 'Purchase account ID',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'purchase_description',
                    'field_label'      => 'Purchase description',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],

                // ======= STOCK =======
                [
                    'api_name'         => 'initial_stock',
                    'field_label'      => 'Initial stock',
                    'data_type'        => 'number',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'initial_stock_rate',
                    'field_label'      => 'Initial stock rate',
                    'data_type'        => 'number',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'reorder_level',
                    'field_label'      => 'Reorder level',
                    'data_type'        => 'number',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],

                // ======= ACCOUNTS & VENDOR =======
                [
                    'api_name'         => 'inventory_account_id',
                    'field_label'      => 'Inventory account ID',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'vendor_id',
                    'field_label'      => 'Preferred Vendor',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],

                // ======= RETURNABLE =======
                [
                    'api_name'         => 'is_returnable',
                    'field_label'      => 'Is returnable?',
                    'data_type'        => 'boolean',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [
                        ['actual_value' => 'true',  'display_value' => 'Yes'],
                        ['actual_value' => 'false', 'display_value' => 'No'],
                    ],
                ],
            ];
        }
        /**
         * Fields for creating a single-line Item Adjustment.
         * Ordered to match the Zoho Inventory UI you shared (top → bottom),
         * with an added 'sku' field (used by our code to resolve item_id).
         */
        public static function create_item_adjustment_fields($all_account_ids): array
        {
            // Build account dropdown options if data exists
            $account_options = [];
            if (!empty($all_account_ids) && !empty($all_account_ids['accounts'])) {
                foreach ($all_account_ids['accounts'] as $acc) {
                    $account_options[] = [
                        'actual_value'  => $acc['id'],
                        'display_value' => $acc['name']
                    ];
                }
            }
            return [

                // We drive item resolution via SKU (preferred)
                [
                    'api_name'         => 'sku',
                    'field_label'      => 'SKU',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => true,     // required by our flow to resolve item_id
                    'pick_list_values' => [],
                ],

                // ======= HEADER DETAILS =======
                [
                    'api_name'         => 'adjustment_type',
                    'field_label'      => 'Mode of adjustment',
                    'data_type'        => 'string', // select
                    'is_custom'        => false,
                    'system_mandatory' => true,    // UI doesn’t mark it required
                    'pick_list_values' => [
                        ['actual_value' => 'quantity', 'display_value' => 'Quantity'],
                        ['actual_value' => 'value',    'display_value' => 'Value'],
                    ],
                ],



                [
                    'api_name'         => 'adjustment_account_id',
                    'field_label'      => 'Account',
                    'data_type'        => 'string', // select (account id)
                    'is_custom'        => false,
                    'system_mandatory' => true,     // UI shows mandatory
                    'pick_list_values' => $account_options,       // populate with accounts if needed
                ],
                [
                    'api_name'         => 'reason',
                    'field_label'      => 'Reason',
                    'data_type'        => 'string', // select
                    'is_custom'        => false,
                    'system_mandatory' => true,     // UI marks mandatory
                    'pick_list_values' => [
                        ['actual_value' => 'Stock on fire',                      'display_value' => 'Stock on fire'],
                        ['actual_value' => 'Stolen goods',                       'display_value' => 'Stolen goods'],
                        ['actual_value' => 'Damaged goods',                      'display_value' => 'Damaged goods'],
                        ['actual_value' => 'Stock Written off',                  'display_value' => 'Stock Written off'],
                        ['actual_value' => 'Stocktaking results',                'display_value' => 'Stocktaking results'],
                        ['actual_value' => 'Inventory Revaluation',              'display_value' => 'Inventory Revaluation'],
                        ['actual_value' => 'Stock Transfer For Replenishment',   'display_value' => 'Stock Transfer For Replenishment'],
                    ],
                ],

                // Quantity (+/-)
                [
                    'api_name'         => 'quantity_adjusted',
                    'field_label'      => 'Quantity adjusted (+/- value)',
                    'data_type'        => 'number', // +/- value
                    'is_custom'        => false,
                    'system_mandatory' => true,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'reference_number',
                    'field_label'      => 'Reference number',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'date', // UI label: Inventory adjustment date
                    'field_label'      => 'Adjustment date',
                    'data_type'        => 'Date', // YYYY-MM-DD
                    'is_custom'        => false,
                    'system_mandatory' => false,     // UI shows mandatory
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'description',
                    'field_label'      => 'Description',
                    'data_type'        => 'string', // textarea
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],

                // ======= LINE CONTEXT =======
                [
                    'api_name'         => 'warehouse_id',
                    'field_label'      => 'Warehouse ID',
                    'data_type'        => 'string', // select
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],       // populate with warehouses if needed
                ],


            ];
        }
        public static function get_sales_order_fields(): array
        {
            return [

                // ======= CUSTOMER =======
                // ['api_name' => 'customer_id',            'field_label' => 'Customer ID',          'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => true,  'pick_list_values' => []],
                ['api_name' => 'sku',                'field_label' => 'SKU',              'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => true,  'pick_list_values' => []],

                ['api_name' => 'email',            'field_label' => 'Email',          'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => true,  'pick_list_values' => []],
                ['api_name' => 'quantity',               'field_label' => 'Item quantity',        'data_type' => 'number', 'is_custom' => false, 'system_mandatory' => true,  'pick_list_values' => []],
                [
                    'api_name'         => 'mark_as_confiremed',
                    'field_label'      => 'Mark Sales Order as Confirmed?',
                    'data_type'        => 'boolean',
                    'is_custom'        => false,
                    'system_mandatory' => true,
                    'pick_list_values' => [
                        ['actual_value' => 'yes', 'display_value' => 'Yes (Change from Draft to Confirmed)'],
                        ['actual_value' => 'no',  'display_value' => 'No (Keep as Draft)'],
                    ],
                ],

                // ======= INDIA GST =======
                ['api_name' => 'place_of_supply',        'field_label' => 'Place of supply',      'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],
                [
                    'api_name' => 'gst_treatment',
                    'field_label' => 'GST treatment',
                    'data_type' => 'string',
                    'is_custom' => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [
                        ['actual_value' => 'business_gst',  'display_value' => 'Business GST'],
                        ['actual_value' => 'business_none', 'display_value' => 'Business none'],
                        ['actual_value' => 'overseas',      'display_value' => 'Overseas'],
                        ['actual_value' => 'consumer',      'display_value' => 'Consumer'],
                    ],
                ],
                ['api_name' => 'gst_no',                 'field_label' => 'GST no',               'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],

                // ======= PRICING / CURRENCY =======
                ['api_name' => 'exchange_rate',          'field_label' => 'Exchange rate',        'data_type' => 'number', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],

                // ======= NUMBERING =======
                [
                    'api_name' => 'ignore_auto_number_generation',
                    'field_label' => 'Ignore auto number generation?',
                    'data_type' => 'boolean',
                    'is_custom' => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [
                        ['actual_value' => 'false', 'display_value' => 'False'],
                        ['actual_value' => 'true',  'display_value' => 'True'],
                    ],
                ],
                ['api_name' => 'salesorder_number',      'field_label' => 'Salesorder number',    'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],
                ['api_name' => 'reference_number',       'field_label' => 'Reference number',     'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],

                // ======= DATES =======
                ['api_name' => 'date',                   'field_label' => 'Sales order date',     'data_type' => 'Date',   'is_custom' => false, 'system_mandatory' => false,  'pick_list_values' => []], // YYYY-MM-DD
                ['api_name' => 'shipment_date',          'field_label' => 'Shipment date',        'data_type' => 'Date',   'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],

                // ======= TERMS / DELIVERY / OWNER =======
                [
                    'api_name' => 'payment_terms',
                    'field_label' => 'Payment terms',
                    'data_type' => 'number',
                    'is_custom' => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [
                        ['actual_value' => 0,   'display_value' => 'Payment Received'],
                        ['actual_value' => 15,  'display_value' => 'Net 15'],
                        ['actual_value' => 30,  'display_value' => 'Net 30'],
                        ['actual_value' => 45,  'display_value' => 'Net 45'],
                        ['actual_value' => 60,  'display_value' => 'Net 60'],
                        ['actual_value' => -2,  'display_value' => 'Due end of the month'],
                        ['actual_value' => -3,  'display_value' => 'Due end of next month'],
                    ],
                ],
                ['api_name' => 'payment_terms_label',    'field_label' => 'Payment terms label',  'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],
                ['api_name' => 'delivery_method',        'field_label' => 'Delivery method',      'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],
                ['api_name' => 'salesperson_id',         'field_label' => 'Salesperson ID',       'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],

                // ======= TAX SETTINGS =======
                [
                    'api_name' => 'is_inclusive_tax',
                    'field_label' => 'Is inclusive of tax?',
                    'data_type' => 'boolean',
                    'is_custom' => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [
                        ['actual_value' => 'true',  'display_value' => 'Yes'],
                        ['actual_value' => 'false', 'display_value' => 'No'],
                    ],
                ],
                ['api_name' => 'pricebook_id',           'field_label' => 'Pricebook',            'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],

                // ======= LINE ITEM (single-line as per your UI) =======
                // ['api_name' => 'item_id',                'field_label' => 'Item ID',              'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => true,  'pick_list_values' => []],

                ['api_name' => 'description',            'field_label' => 'Item description',     'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],
                ['api_name' => 'rate',                   'field_label' => 'Item rate',            'data_type' => 'number', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],

                ['api_name' => 'tax_id',                 'field_label' => 'Tax ID',               'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],
                ['api_name' => 'tax_exemption_code',     'field_label' => 'Tax exemption code',   'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],

                [
                    'api_name' => 'discount_type',
                    'field_label' => 'Discount type',
                    'data_type' => 'string',
                    'is_custom' => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [
                        ['actual_value' => 'item_level',   'display_value' => 'Item level'],
                        ['actual_value' => 'entity_level', 'display_value' => 'Entity level'],
                    ],
                ],
                ['api_name' => 'discount',               'field_label' => 'Discount',             'data_type' => 'number',  'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],
                [
                    'api_name' => 'is_discount_before_tax',
                    'field_label' => 'Is discount before tax?',
                    'data_type' => 'boolean',
                    'is_custom' => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [
                        ['actual_value' => 'true',  'display_value' => 'Yes'],
                        ['actual_value' => 'false', 'display_value' => 'No'],
                    ],
                ],

                // ======= CHARGES & ADJUSTMENTS =======
                ['api_name' => 'shipping_charge',        'field_label' => 'Shipping charge',      'data_type' => 'number', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],
                ['api_name' => 'adjustment_description', 'field_label' => 'Adjustment description', 'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],
                ['api_name' => 'adjustment',             'field_label' => 'Adjustment',           'data_type' => 'number', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],

                // ======= NOTES / T&C / TEMPLATE =======
                ['api_name' => 'notes',                  'field_label' => 'Customer notes',       'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],
                ['api_name' => 'terms',                  'field_label' => 'Terms and Conditions', 'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],
                ['api_name' => 'template_id',            'field_label' => 'Template ID',          'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => false, 'pick_list_values' => []],
            ];
        }
        public static function get_invoice_fields(): array
        {
            return [
                // ======= ORGANIZATION / CUSTOMER =======
                ['api_name' => 'sku',                'field_label' => 'SKU',              'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => true,  'pick_list_values' => []],

                ['api_name' => 'email',            'field_label' => 'Email',          'data_type' => 'string', 'is_custom' => false, 'system_mandatory' => true,  'pick_list_values' => []],
                ['api_name' => 'quantity',               'field_label' => 'Item quantity',        'data_type' => 'number', 'is_custom' => false, 'system_mandatory' => true,  'pick_list_values' => []],

                [
                    'api_name'         => 'auto_mark_invoice_paid',
                    'field_label'      => 'Mark Invoice as Paid?',
                    'data_type'        => 'boolean',
                    'is_custom'        => false,
                    'system_mandatory' => true,
                    'pick_list_values' => [
                        ['actual_value' => 'yes', 'display_value' => 'Yes (Mark Draft Invoice as Paid)'],
                        ['actual_value' => 'no',  'display_value' => 'No (Keep as Draft)'],
                    ],
                ],
                // ======= EMAIL =======
                [
                    'api_name'         => 'send_email',
                    'field_label'      => 'Send Invoice Email to Customer?',
                    'data_type'        => 'boolean',
                    'is_custom'        => false,
                    'system_mandatory' => true,
                    'pick_list_values' => [
                        ['actual_value' => 'yes', 'display_value' => 'Yes'],
                        ['actual_value' => 'no',  'display_value' => 'No'],
                    ],
                ],
                [
                    'api_name'         => 'custom_subject',
                    'field_label'      => 'Custom Email Subject (Optional)',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'custom_body',
                    'field_label'      => 'Custom Email Message Body (Optional)',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],


                // ======= INDIA / US / UK TAX SETTINGS =======
                [
                    'api_name'         => 'gst_treatment',
                    'field_label'      => 'GST treatment',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [
                        ['actual_value' => 'business_gst',  'display_value' => 'Business GST'],
                        ['actual_value' => 'business_none', 'display_value' => 'Business none'],
                        ['actual_value' => 'overseas',      'display_value' => 'Overseas'],
                        ['actual_value' => 'consumer',      'display_value' => 'Consumer'],
                    ],
                ],
                [
                    'api_name'         => 'gst_no',
                    'field_label'      => 'GST number',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'place_of_supply',
                    'field_label'      => 'Place of supply',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'tax_authority_id',
                    'field_label'      => 'Tax authority ID',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'avatax_exempt_no',
                    'field_label'      => 'Avatax exempt no',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'avatax_use_code',
                    'field_label'      => 'Avatax use code',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'vat_treatment',
                    'field_label'      => 'VAT treatment',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],

                // ======= NUMBERING =======
                [
                    'api_name'         => 'ignore_auto_number_generation',
                    'field_label'      => 'Ignore auto number generation?',
                    'data_type'        => 'boolean',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [
                        ['actual_value' => 'false', 'display_value' => 'False'],
                        ['actual_value' => 'true',  'display_value' => 'True'],
                    ],
                ],
                [
                    'api_name'         => 'invoice_number',
                    'field_label'      => 'Invoice number',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'reference_number',
                    'field_label'      => 'Order number',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],

                // ======= DATES =======
                [
                    'api_name'         => 'date',
                    'field_label'      => 'Invoice date',
                    'data_type'        => 'Date', // YYYY-MM-DD
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'payment_terms',
                    'field_label'      => 'Payment terms',
                    'data_type'        => 'number',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [
                        ['actual_value' => 0,   'display_value' => 'Payment Received'],
                        ['actual_value' => 15,  'display_value' => 'Net 15'],
                        ['actual_value' => 30,  'display_value' => 'Net 30'],
                        ['actual_value' => 45,  'display_value' => 'Net 45'],
                        ['actual_value' => 60,  'display_value' => 'Net 60'],
                        ['actual_value' => -2,  'display_value' => 'Due end of the month'],
                        ['actual_value' => -3,  'display_value' => 'Due end of next month'],
                    ],
                ],
                [
                    'api_name'         => 'payment_terms_label',
                    'field_label'      => 'Payment terms label',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'due_date',
                    'field_label'      => 'Due date',
                    'data_type'        => 'Date', // YYYY-MM-DD
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],

                // ======= OWNER / PRICING =======
                [
                    'api_name'         => 'salesperson_id',
                    'field_label'      => 'Salesperson ID',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'is_inclusive_tax',
                    'field_label'      => 'Is inclusive of tax?',
                    'data_type'        => 'boolean',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [
                        ['actual_value' => 'true',  'display_value' => 'Yes'],
                        ['actual_value' => 'false', 'display_value' => 'No'],
                    ],
                ],
                [
                    'api_name'         => 'pricebook_id',
                    'field_label'      => 'Pricebook',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],

                // ======= LINE ITEM (single-line per your UI) =======
                [
                    'api_name'         => 'description',
                    'field_label'      => 'Item description',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'rate',
                    'field_label'      => 'Item rate',
                    'data_type'        => 'number',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'warehouse_id',
                    'field_label'      => 'Warehouse',
                    'data_type'        => 'string', // select
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'serial_numbers',
                    'field_label'      => 'Item serial number',
                    'data_type'        => 'string', // CSV
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'tax_id',
                    'field_label'      => 'Tax ID',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'tax_exemption_code',
                    'field_label'      => 'Tax exemption code',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'salesorder_item_id',
                    'field_label'      => 'Sales order line item ID',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'is_discount_before_tax',
                    'field_label'      => 'Is discount before tax?',
                    'data_type'        => 'boolean',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [
                        ['actual_value' => 'true',  'display_value' => 'Yes'],
                        ['actual_value' => 'false', 'display_value' => 'No'],
                    ],
                ],
                [
                    'api_name'         => 'discount_type',
                    'field_label'      => 'Discount type',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [
                        ['actual_value' => 'item_level',   'display_value' => 'Item level'],
                        ['actual_value' => 'entity_level', 'display_value' => 'Entity level'],
                    ],
                ],
                [
                    'api_name'         => 'discount',
                    'field_label'      => 'Discount',
                    'data_type'        => 'number',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],

                // ======= CHARGES & ADJUSTMENTS =======
                [
                    'api_name'         => 'shipping_charge',
                    'field_label'      => 'Shipping charge',
                    'data_type'        => 'number',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'adjustment_description',
                    'field_label'      => 'Adjustment description',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'adjustment',
                    'field_label'      => 'Adjustment',
                    'data_type'        => 'number',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],

                // ======= NOTES / TEMPLATE =======
                [
                    'api_name'         => 'notes',
                    'field_label'      => 'Customer notes',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'terms',
                    'field_label'      => 'Terms and conditions',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'allow_partial_payments',
                    'field_label'      => 'Allow partial payments?',
                    'data_type'        => 'boolean',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [
                        ['actual_value' => 'true',  'display_value' => 'Yes'],
                        ['actual_value' => 'false', 'display_value' => 'No'],
                    ],
                ],
                [
                    'api_name'         => 'payment_options_payment_gateways',
                    'field_label'      => 'Payment options payment gateways',
                    'data_type'        => 'string', // CSV of gateway codes
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],
                [
                    'api_name'         => 'template_id',
                    'field_label'      => 'Template ID',
                    'data_type'        => 'string',
                    'is_custom'        => false,
                    'system_mandatory' => false,
                    'pick_list_values' => [],
                ],


            ];
        }
    }
}
