<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

if (!class_exists('INTEGRAZO_WZ_WordPressCom_Helper')) {
    class INTEGRAZO_WZ_WordPressCom_Helper
    {
        /**
         * Get a list of WordPress user-related events.
         */
        public static function get_events()
        {
            return array(
                //  array('id' => 'register_new_user',      'title' => 'User created'),
                array('id' => 'user_register',  'title' => 'New user added'),
                array('id' => 'profile_update',     'title' => 'User profile updated'),
                array('id' => 'wp_login',           'title' => 'User logged in'),
            );
        }

        /**
         * Get all fields for WordPress user registration.
         */
        public static function get_form_fields($event_id)
        {

            return array(
                array('name' => 'user_login',       'type' => 'text',     'label' => 'Username',         'identifier' => 'user_login'),
                array('name' => 'user_email',       'type' => 'email',    'label' => 'Email',            'identifier' => 'user_email'),
                array('name' => 'first_name',       'type' => 'text',     'label' => 'First Name',       'identifier' => 'first_name'),
                array('name' => 'last_name',        'type' => 'text',     'label' => 'Last Name',        'identifier' => 'last_name'),
                array('name' => 'nickname',         'type' => 'text',     'label' => 'Nickname',         'identifier' => 'nickname'),
                array('name' => 'description',      'type' => 'textarea', 'label' => 'Biographical Info', 'identifier' => 'description'),
                array('name' => 'user_url',         'type' => 'url',      'label' => 'Website URL',      'identifier' => 'user_url'),
                array('name' => 'display_name',     'type' => 'text',     'label' => 'Display Name',     'identifier' => 'display_name'),
                array('name' => 'user_registered',  'type' => 'text',     'label' => 'Registered Date',  'identifier' => 'user_registered'),
                array('name' => 'role',             'type' => 'text',     'label' => 'Role',             'identifier' => 'role'),
            );
        }


        /**
         * Capture user registration or login events.
         */
        public static function capture_submission($user_id_or_login, $event = '', $unused = '')
        {
            try {
                $user = is_numeric($user_id_or_login)
                    ? get_userdata($user_id_or_login)
                    : get_user_by('login', $user_id_or_login);

                if (!$user) {
                    return;
                }

                $user_id = $user->ID;
                $roles = $user->roles;
                $role = !empty($roles) ? $roles[0] : '';

                // Full data for other events
                $form_data = array(
                    'event'           => $event,
                    'user_login'      => $user->user_login,
                    'user_email'      => $user->user_email,
                    'user_url'        => $user->user_url,
                    'first_name'      => get_user_meta($user_id, 'first_name', true),
                    'last_name'       => get_user_meta($user_id, 'last_name', true),
                    'nickname'        => get_user_meta($user_id, 'nickname', true),
                    'description'     => get_user_meta($user_id, 'description', true),
                    'display_name'    => $user->display_name,
                    'user_registered' => $user->user_registered,
                    'role'            => $role
                );

                INTEGRAZO_WZ_Form_Hooks::process_submission($event, $form_data, 'wordpress_org');
            } catch (Throwable $e) {
            }
        }
    }
}

if (class_exists('INTEGRAZO_WZ_WordPressCom_Helper')) {
    global $integrazo_wz_recently_registered_user_id;
    $integrazo_wz_recently_registered_user_id = null;

    // Admin-created user (skip if just handled by register_new_user)
    add_action('user_register', function ($user_id) {
        global $integrazo_wz_recently_registered_user_id;

        if ($integrazo_wz_recently_registered_user_id == $user_id) {
            // Skip user_register fired right after self-registration
            $integrazo_wz_recently_registered_user_id = null;
            return;
        }

        $integrazo_wz_recently_registered_user_id = $user_id;
        INTEGRAZO_WZ_WordPressCom_Helper::capture_submission($user_id, 'user_register');
    }, 10, 1);

    // Profile update (ignore if just registered)
    add_action('profile_update', function ($user_id) {
        global $integrazo_wz_recently_registered_user_id;

        if ($integrazo_wz_recently_registered_user_id == $user_id) {
            // Skip profile_update triggered by registration
            $integrazo_wz_recently_registered_user_id = null; // reset
            return;
        }

        INTEGRAZO_WZ_WordPressCom_Helper::capture_submission($user_id, 'profile_update');
    }, 10, 1);

    // User login
    add_action('wp_login', function ($user_login, $user) {
        INTEGRAZO_WZ_WordPressCom_Helper::capture_submission($user_login, 'wp_login');
    }, 10, 2);
}
