<?php
// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit; // Prevent direct access to the file.
}

// Check if the class already exists to avoid redeclaration.
if (!class_exists('INTEGRAZO_WZ_Identifier_Util')) {

    /**
     * Utility class for handling general integration-related operations.
     */
    class INTEGRAZO_WZ_Identifier_Util
    {
        /**
         * Builds a standardized field identifier by combining a cleaned field label with the field ID.
         *
         * @param string $field_id    The unique ID of the field.
         * @param string $field_label The label of the field.
         * @return string             Standardized identifier (e.g., full_name_123).
         */
        public static function build_field_identifier($field_id, $field_label)
        {
            $raw   = preg_replace('/[^a-zA-Z0-9]+/', '_', $field_label);
            $clean = trim(preg_replace('/_+/', '_', $raw), '_');

            return strtolower($clean . '_' . $field_id);
        }

        /**
         * Extracts the numeric field ID from the given identifier.
         * If no numeric suffix is found, returns the original identifier.
         *
         * @param string $identifier The standardized field identifier.
         * @return string            Extracted field ID or original identifier.
         */
        public static function extract_field_id_from_identifier($identifier)
        {
            $parts = explode('_', $identifier);
            return trim(end($parts));
        }



        public static function get_plugin_identifier_support($plugin_name)
        {

            $plugins = [
                'contact_form_7' => false,
                'wp_form'        => true,
                'elementor_form' => true,
                'gravity_form'  => true,
                'formidable_form'     => true,
                'everest_form' => true,
                'fluent_form' => false,
                'ninja_form' => false,
                'forminator_form' => false,
                'jet_form' => false,
                'sure_forms' => false,
                'happy_form' => false,
                'we_form' => false,
                'form_maker' => true,
                'ws_form' => true,
                'quill_forms' => true,
                'ar_forms' => true,
            ];

            // Return false if plugin name is empty or not found
            if (empty($plugin_name) || !array_key_exists($plugin_name, $plugins)) {
                return false;
            }

            return $plugins[$plugin_name];
        }
    }
}
