<?php

/**
 * Plugin Name:       Integration for Zoho Apps
 * Plugin URI:        https://integrazo.com/products/integration-for-zoho-apps
 * Description:       Connect Zoho CRM, Books, Invoice, Inventory, Desk, Campaigns and Bigin to send WooCommerce and form submission data.
 * Version:           1.0.3
 * Author:            Integrazo
 * Author URI:        https://integrazo.com/
 * License:           GPL2
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       integrazo-integration-for-zoho-apps
 */


if (! defined('ABSPATH')) {
    exit; // No direct access
}

// Define Plugin Constants
define('INTEGRAZO_WZ_PLUGIN_VERSION', '1.0.3');
define('INTEGRAZO_WZ_PLUGIN_NAME', 'Integration for Zoho Apps');
define('INTEGRAZO_WZ_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('INTEGRAZO_WZ_PLUGIN_URL', plugin_dir_url(__FILE__));

// Include core functionality files
require_once INTEGRAZO_WZ_PLUGIN_DIR . 'includes/includes.php';


/**
 * Plugin activation callback.
 *
 * @param bool $network_wide Whether the plugin is being activated network-wide in multisite.
 */
function integrazo_wz_activate($network_wide)
{

    // Multisite activation handling
    if (is_multisite() && $network_wide) {
        $sites = get_sites(['fields' => 'ids']);
        foreach ($sites as $site_id) {
            switch_to_blog($site_id);
            $db_setup = new INTEGRAZO_WZ_DB_Setup();
            $db_setup->create_tables();
            restore_current_blog();
        }
    } else {
        // Single site or site-specific activation
        $db_setup = new INTEGRAZO_WZ_DB_Setup();
        $db_setup->create_tables();
    }
}

// Register the activation hook
register_activation_hook(__FILE__, 'integrazo_wz_activate');

/**
 * Function to handle tasks during plugin deactivation
 */
function integrazo_wz_deactivate($network_wide)
{
    if (is_multisite() && $network_wide) {
        // Handle network-wide deactivation
        $sites = get_sites(array('fields' => 'ids')); // Fetch only site IDs for efficiency
        foreach ($sites as $site_id) {
            switch_to_blog($site_id); // Switch to the current site in the loop
            //  integrazo_wz_uninstall(); // Call uninstall function for each site
            restore_current_blog(); // Restore the original site context
        }
    } else {
        // Handle single site deactivation
        //integrazo_wz_uninstall(); // Call uninstall function for the current site
    }
}

// Hook for plugin deactivation
register_deactivation_hook(__FILE__, 'integrazo_wz_deactivate');


/**
 * Add "Settings" and "Upgrade to Pro" links to the plugin action links.
 *
 * @param array $links Existing plugin action links.
 * @return array Modified plugin action links.
 */
function integrazo_wz_plugin_action_links($links)
{
    // Add Settings link
    $settings_link = '<a href="admin.php?page=integrazo-integration-for-zoho-apps&tab=setup">' . esc_html__('Settings', 'integrazo-integration-for-zoho-apps') . '</a>';
    array_unshift($links, $settings_link);
    if (!integrazo_wz_is_pro_file_exists()) {
        $upgrade_link = '<a href="https://integrazo.com/products/integration-for-zoho-apps" style="color: rgb(0, 163, 42); font-weight: bold;" target="_blank">' . esc_html__('Upgrade to Pro', 'integrazo-integration-for-zoho-apps') . '</a>';
        $links[] = $upgrade_link;
    }
    return $links;
}
add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'integrazo_wz_plugin_action_links');
