<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

// Always load the integration model.
$model = new INTEGRAZO_WZ_Integration_Model();

// Get total integration count
$integration_count = $model->get_total_integrations_count();

// If no integrations, show initial setup page
$nonce = isset($_GET['_wpnonce']) ? sanitize_text_field(wp_unslash($_GET['_wpnonce'])) : '';
$action = isset($_GET['action']) ? sanitize_key(wp_unslash($_GET['action'])) : '';

if ($action === 'addnew' && !empty($nonce) && !wp_verify_nonce($nonce, 'integrazo_wz_setup_add')) {
    wp_die(esc_html__('Security check failed. Please reload the page and try again.', 'integrazo-integration-for-zoho-apps'));
}

if (! current_user_can('manage_options')) {
    wp_die(esc_html__('Insufficient permissions.', 'integrazo-integration-for-zoho-apps'));
}

if (
    $integration_count > 0 &&
    !isset($_GET['integration_id']) &&
    (!isset($_GET['action']) || $_GET['action'] !== 'addnew')
) {
    require_once INTEGRAZO_WZ_PLUGIN_DIR . 'includes/extend/setup.php';
} else {

    // Show back button if there is at least one integration
    if ($integration_count > 0) {
        echo '<div style="padding:10px;"><a href="admin.php?page=integrazo-integration-for-zoho-apps&tab=setup" style="text-decoration: none;">← Back to Integrations</a></div>';
    }
    // Load integration options utility

    $account_instance = new INTEGRAZO_WZ_Account_Model();
    $account_count    = $account_instance->get_total_accounts_count();

    // Initialize variables
    $integration_details = null;
    $account_details     = null;
    $account_id          = null;
    $account_name        = null;
    $integration_id      = null;
    $from_plugin         = null;
    $to_product          = null;
    $integration_name    = null;
    $field_mapping  = null;

    // Check if we are editing an existing integration
    if (
        isset($_GET['integration_id']) &&
        isset($_GET['page']) &&
        sanitize_text_field(wp_unslash($_GET['page'])) === 'integrazo-integration-for-zoho-apps'
    ) {

        $integration_id      = intval($_GET['integration_id']);
        $integration_details = $model->get_integration_by_id($integration_id);

        if (!empty($integration_details)) {
            $from_plugin      = $integration_details['from_plugin'] ?? '';
            $to_product       = $integration_details['to_product'] ?? '';
            $account_id       = $integration_details['account_id'] ?? null;
            $integration_name = $integration_details['integration_name'] ?? '';
            $field_mapping =  $integration_details['field_mapping'] ?? 1;
            if (!empty($account_id)) {
                $account_details = $account_instance->get_account_by_id($account_id);
                $account_name    = $account_details['account_name'] ?? '';
            }
        }
    }
    // Include setup steps
    require_once INTEGRAZO_WZ_PLUGIN_DIR . 'includes/page/setup-1.php';
    require_once INTEGRAZO_WZ_PLUGIN_DIR . 'includes/page/setup-2.php';
    require_once INTEGRAZO_WZ_PLUGIN_DIR . 'includes/page/setup-3.php';
    //

}
