<?php
// Exit if accessed directly.
if (! defined('ABSPATH')) {
    exit;
}

?>

<div class="integrazo-wz-setup-accordion" id="step3">
    <div class="integrazo-wz-setup-accordion-header">
        <?php esc_html_e('3. Map Fields', 'integrazo-integration-for-zoho-apps'); ?> <span class="integrazo-wz-setup-toggle-icon">+</span>
    </div>

    <div class="integrazo-wz-setup-accordion-content">
        <!-- ✅ Header Section -->
        <div id="integrazo-wz-header-section">
            <?php

            // Sanitize the product name.
            $safe_product = sanitize_key($to_product);
            $safe_plugin = sanitize_key($from_plugin);
            $pro_product_ids = integrazo_wz_get_pro_product_ids($integration_sources['products']);
            $pro_plugin_ids = integrazo_wz_get_pro_plugin_ids($integration_sources['plugins']);
           if ( ! $session ) {
                if ( in_array( $safe_product, $pro_product_ids, true ) || in_array( $safe_plugin, $pro_plugin_ids, true ) ) {
                    // Pro product → load from Pro plugin directory
                    echo '<p style="text-align: center;">' . esc_html__( 'This integration is available only in the Pro version. Please make sure you have activated the Pro plugin and a valid license.', 'integrazo-integration-for-zoho-apps' ) . '</p>';
                    return;
                }
            }

            if (defined('INTEGRAZO_WZ_PRO_PLUGIN_DIR') && in_array($safe_product, $pro_product_ids, true)) {
                // Pro product → load from Pro plugin dir
                $page_path = trailingslashit(INTEGRAZO_WZ_PRO_PLUGIN_DIR) . 'src/products/' . $safe_product . '/page.php';
            } else {
                // Free/default → load from Free plugin dir
                $page_path = trailingslashit(INTEGRAZO_WZ_PLUGIN_DIR) . 'src/products/' . $safe_product . '/page.php';
            }

            // Include the file if it exists.
            if (file_exists($page_path)) {
                $event =  INTEGRAZO_WZ_Plugin_Input_Renderer::render($integration_details);

                if (is_wp_error($event)) {
                    echo '<p style="text-align: center;">' . esc_html($event->get_error_message()) . '</p>';
                    return;
                }
                if ($event === null) {
                    echo '<p style="text-align: center;">' . esc_html__('The selected plugin is not supported in the Free version. Please upgrade to Pro to use this integration.', 'integrazo-integration-for-zoho-apps') . '</p>';
                    return;
                }
                // Load additional fields
                require_once INTEGRAZO_WZ_PLUGIN_DIR . 'src/util/additional-fields.php';

                // Decode integration data
                $integration_data    = json_decode($integration_details['integration_data'] ?? '', true);
                require_once $page_path;
            } else if (in_array($safe_product, $pro_product_ids, true)) {
                echo '<p style="text-align: center;">' . esc_html__('The selected service is not supported in the Free version. Please upgrade to Pro to use this integration.', 'integrazo-integration-for-zoho-apps') . '</p>';
                return;
            } else {
                echo '<p>' . esc_html__('Please complete Step 1 (Connect Service) and Step 2 (Sign In / Authenticate) before mapping fields.', 'integrazo-integration-for-zoho-apps') . '</p>';
            }
            ?>
        </div>
    </div>
</div>