<?php
// Exit if accessed directly.
if (! defined('ABSPATH')) {
    exit;
}

$service_config = INTEGRAZO_WZ_Auth_Fields::get_fields_by_service($to_product);
$fields         = $service_config['fields'];
$common_note    = $service_config['common_note'];
$account_list   = $account_instance->get_accounts_by_product_name($to_product);

?>

<div class="integrazo-wz-setup-accordion" id="step2">
    <div class="integrazo-wz-setup-accordion-header">
        <?php esc_html_e('2. Sign In / Authenticate', 'integrazo-integration-for-zoho-apps'); ?> <span class="integrazo-wz-setup-toggle-icon">+</span>
    </div>

    <div class="integrazo-wz-setup-accordion-content">
        <?php if (! empty($integration_details)) : ?>
            <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
                <?php wp_nonce_field('integrazo_wz_auth_action', 'integrazo_wz_auth_nonce'); ?>
                <!-- <input type="hidden" name="action" value="integrazo_wz_auth_integration"> -->
                <input type="hidden" name="action" value="<?php echo esc_attr($service_config['action']); ?>">
                <input type="hidden" name="integration_id" value="<?php echo esc_attr($integration_id ?? ''); ?>" />
                <input type="hidden" name="account_id" value="<?php echo esc_attr($account_id ?? ''); ?>" />
                <input type="hidden" name="to_product" value="<?php echo esc_attr($to_product ?? ''); ?>">

                <!-- Existing account selection -->
                <div id="integrazo-wz-select_account_section"
                    style="display: <?php echo ! empty($account_list) ? 'flex' : 'none'; ?>; align-items: center; gap: 12px; max-width: 700px; margin-bottom: 20px;">
                    <label for="integrazo-wz-account_select" class="integrazo-wz-setup-lable">
                        <?php esc_html_e('Select Account', 'integrazo-integration-for-zoho-apps'); ?>
                        <div class="integrazo-wz-helpicon-help-icon-wrapper">
                            <span class="integrazo-wz-helpicon-help-icon">?</span>
                            <div class="integrazo-wz-helpicon-help-tooltip">
                                <p><?php esc_html_e('Choose an existing authenticated account or create a new one to continue the integration.', 'integrazo-integration-for-zoho-apps'); ?></p>
                            </div>
                        </div>
                    </label>

                    <select name="account_id" id="integrazo-wz-account_select" class="regular-text">

                        <?php if (! empty($account_list)) : ?>
                            <?php foreach ($account_list as $account) : ?>
                                <option value="<?php echo esc_attr($account['id']); ?>"
                                    <?php selected($account_id ?? '', $account['id']); ?>>
                                    <?php echo esc_html($account['account_name']); ?>
                                </option>
                            <?php endforeach; ?>
                        <?php else : ?>
                            <option value="" disabled><?php esc_html_e('No accounts found', 'integrazo-integration-for-zoho-apps'); ?></option>
                        <?php endif; ?>
                    </select>

                    <button type="button" id="new_account_btn" class="button button-secondary">
                        <?php esc_html_e('+ New', 'integrazo-integration-for-zoho-apps'); ?>
                    </button>
                </div>

                <!-- New account fields -->
                <div id="integrazo-wz-new_account_fields" style="display: <?php echo empty($account_list) ? 'block' : 'none'; ?>;">
                    <!-- Account Name -->
                    <div id="integrazo-wz-new_account_name" style="display: flex; flex-wrap: wrap; align-items: flex-start; margin-bottom: 20px; max-width: 700px;">
                        <label for="integrazo_wz_account_name" class="integrazo-wz-setup-lable">
                            <?php esc_html_e('Account Name', 'integrazo-integration-for-zoho-apps'); ?>
                            <div class="integrazo-wz-helpicon-help-icon-wrapper">
                                <span class="integrazo-wz-helpicon-help-icon">?</span>
                                <div class="integrazo-wz-helpicon-help-tooltip">
                                    <p><?php esc_html_e('Enter a unique name to identify this account. You can rename it or re-authenticate anytime under Settings → Accounts.', 'integrazo-integration-for-zoho-apps'); ?></p>
                                </div>
                            </div>
                        </label>
                        <div style="width: 70%;">
                            <?php $account_name_value = 'Account #' . ($account_count + 1); ?>
                            <input type="text" name="integrazo_wz_account_name" id="integrazo_wz_account_name" class="regular-text" value="<?php echo esc_attr($account_name_value); ?>" />
                        </div>
                    </div>

                    <!-- Dynamic Fields -->
                    <?php foreach ($fields as $name => $field) : ?>
                        <div style="display: flex; flex-wrap: wrap; align-items: flex-start; margin-bottom: 20px; max-width: 700px;">
                            <label for="<?php echo esc_attr($name); ?>" class="integrazo-wz-setup-lable">
                                <?php echo esc_html($field['label']); ?>
                                <?php if (! empty($field['help'])) : ?>
                                    <div class="integrazo-wz-helpicon-help-icon-wrapper" style="margin-left: 5px;">
                                        <span class="integrazo-wz-helpicon-help-icon">?</span>
                                        <div class="integrazo-wz-helpicon-help-tooltip">
                                            <?php echo esc_html($field['help']); ?>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </label>

                            <div style="width: 70%;">
                                <?php if ($field['type'] === 'select') : ?>
                                    <select name="<?php echo esc_attr($name); ?>" class="regular-text">
                                        <?php foreach ($field['options'] as $key => $label) : ?>
                                            <option value="<?php echo esc_attr($key); ?>"><?php echo esc_html($label); ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                <?php else : ?>
                                    <input type="<?php echo esc_attr($field['type']); ?>" name="<?php echo esc_attr($name); ?>" class="regular-text" />
                                <?php endif; ?>

                                <?php if (! empty($field['note'])) : ?>
                                    <p class="integrazo-wz-setup-step2-note"><?php echo esc_html($field['note']); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>

                    <!-- Common Note -->
                    <?php if (! empty($common_note)) : ?>
                        <div class="integrazo-wz-setup-step2-note-bottom">
                            <?php echo wp_kses_post($common_note); ?>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Submit Buttons -->
                <?php if (empty($account_id) && empty($account_list)) : ?>
                    <!-- Condition 1: Show Authenticate and Next -->
                    <div class="integrazo-wz-setup-next-btn-wrapper integrazo-wz-setup-step2-save-btn">
                        <button type="submit" class="button button-primary" id="step2_next" value="auth_and_next" name="integrazo_wz_step2_button_action">
                            <?php esc_html_e('Authenticate and Next', 'integrazo-integration-for-zoho-apps'); ?>
                        </button>
                    </div>

                <?php elseif (!empty($account_id) && !empty($account_list)) : ?>
                    <!-- Condition 2: Show Save -->
                    <div class="integrazo-wz-setup-next-btn-wrapper integrazo-wz-setup-step2-save-btn">
                        <button type="submit" class="button button-primary" id="step2_save" value="save" name="integrazo_wz_step2_button_action">
                            <?php esc_html_e('Save', 'integrazo-integration-for-zoho-apps'); ?>
                        </button>
                    </div>

                <?php elseif (empty($account_id) && !empty($account_list)) : ?>
                    <!-- Condition 3: Show Save and Next -->
                    <div class="integrazo-wz-setup-next-btn-wrapper integrazo-wz-setup-step2-save-btn">
                        <button type="submit" class="button button-primary" id="step2_save_next" value="save_and_next" name="integrazo_wz_step2_button_action">
                            <?php esc_html_e('Save and Next', 'integrazo-integration-for-zoho-apps'); ?>
                        </button>
                    </div>
                <?php endif; ?>


                <div class="integrazo-wz-setup-next-btn-wrapper integrazo-wz-setup-step2-save-btn" style="display: none;">
                    <button type="submit" class="button button-primary" id="step2_auth" value="auth" name="integrazo_wz_step2_button_action">
                        <?php esc_html_e('Authenticate', 'integrazo-integration-for-zoho-apps'); ?>
                    </button>
                </div>
            </form>
        <?php else : ?>
            <p><?php esc_html_e('Please complete the connection step first (Step 1) before continuing with authentication.', 'integrazo-integration-for-zoho-apps'); ?></p>
        <?php endif; ?>
    </div>
</div>