<?php

// Exit if accessed directly.
if (! defined('ABSPATH')) {
    exit;
}
global $integration_sources;
$ordered_plugins  = integrazo_wz_get_plugins_sorted($integration_sources['plugins']);
$ordered_products = integrazo_wz_get_products_sorted($integration_sources['products']);

// Display success or error admin notice based on transient.
if ($msg = get_transient('integrazo_wz_integration_message')) : ?>
    <div class="notice notice-success is-dismissible">
        <p><?php echo esc_html($msg); ?></p>
    </div>
    <?php delete_transient('integrazo_wz_integration_message'); ?>
<?php elseif ($err = get_transient('integrazo_wz_integration_error')) : ?>
    <div class="notice notice-error is-dismissible">
        <p><?php echo esc_html($err); ?></p>
    </div>
    <?php delete_transient('integrazo_wz_integration_error'); ?>
<?php endif; ?>

<div class="integrazo-wz-setup-accordion" id="step1">
    <div class="integrazo-wz-setup-accordion-header">
        <?php esc_html_e('1. Connect Service', 'integrazo-integration-for-zoho-apps'); ?> <span class="integrazo-wz-setup-toggle-icon">−</span>
    </div>

    <div class="integrazo-wz-setup-accordion-content">
        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
            <?php wp_nonce_field('integrazo_wz_save_integration_action', 'integrazo_wz_nonce'); ?>

            <?php if (! empty($integration_count) && $integration_count > 0) : ?>
                <div style="display: flex; align-items: center; margin-bottom: 25px; max-width: 60%;">
                    <label for="integration_name" class="integrazo-wz-setup-lable">
                        <?php esc_html_e('Integration Name:', 'integrazo-integration-for-zoho-apps'); ?>
                        <div class="integrazo-wz-helpicon-help-icon-wrapper">
                            <span class="integrazo-wz-helpicon-help-icon">?</span>
                            <div class="integrazo-wz-helpicon-help-tooltip">
                                <p><?php esc_html_e('A unique name to identify this Integration.', 'integrazo-integration-for-zoho-apps'); ?></p>
                            </div>
                        </div>
                    </label>

                    <input type="text" id="integration_name" name="integration_name"
                        class="regular-text" placeholder=""
                        value="<?php echo esc_attr(empty($integration_name) ? 'Integration #' . ($integration_count + 1) : $integration_name); ?>" />
                </div>
            <?php else : ?>
                <input type="hidden" id="integration_name" name="integration_name"
                    placeholder="" class="integrazo-wz-setup-setp1-integration-name"
                    value="Integration #1" />
            <?php endif; ?>

            <?php
            // Selected plugin.
            $selected_plugin = null;
            if (! empty($from_plugin)) {
                foreach ($integration_sources['plugins'] as $plugin) {
                    if ($plugin['id'] === $from_plugin) {
                        $selected_plugin = $plugin;
                        break;
                    }
                }
            }

            // Selected product.
            $selected_product = null;
            if (! empty($to_product)) {
                foreach ($integration_sources['products'] as $product) {
                    if ($product['id'] === $to_product) {
                        $selected_product = $product;
                        break;
                    }
                }
            }
            ?>

            <div class="integrazo-wz-setup-step1-wrapper">
                <!-- Plugin Box -->
                <div class="integrazo-wz-setup-step1-box <?php echo $selected_plugin ? '' : 'integrazo-wz-setup-step1-expand-toggle'; ?>"
                    <?php echo $selected_plugin ? '' : 'data-target="#integrazo-wz-plugin-popup"'; ?>>
                    <?php if (! $selected_plugin) : ?>
                        <span class="integrazo-wz-setup-step1-label"><?php esc_html_e('Select Plugin', 'integrazo-integration-for-zoho-apps'); ?></span>
                    <?php endif; ?>
                    <div class="<?php echo !empty($selected_plugin['id'])
                                    ? 'integrazo-wz-setup-step1-plugin-thumb ' . esc_attr($selected_plugin['id'])
                                    : 'integrazo-wz-setup-step1-add-icon'; ?>">
                    </div>
                    <span class="integrazo-wz-setup-step1-plugin-title"><?php echo esc_html($selected_plugin['name'] ?? ''); ?></span>
                </div>

                <div class="integrazo-wz-setup-step1-arrow">&#8594;</div>

                <!-- Product Box -->
                <div class="integrazo-wz-setup-step1-box <?php echo $selected_product ? '' : 'integrazo-wz-setup-step1-expand-toggle'; ?>"
                    <?php echo $selected_product ? '' : 'data-target="#integrazo-wz-product-popup"'; ?>>
                    <?php if (! $selected_product) : ?>
                        <span class="integrazo-wz-setup-step1-label"><?php esc_html_e('Select Product', 'integrazo-integration-for-zoho-apps'); ?></span>
                    <?php endif; ?>

                    <div class="<?php echo !empty($selected_product['id'])
                                    ? 'integrazo-wz-setup-step1-plugin-thumb ' . esc_attr($selected_product['id'])
                                    : 'integrazo-wz-setup-step1-add-icon'; ?>">
                    </div>

                    <span class="integrazo-wz-setup-step1-plugin-title"><?php echo esc_html($selected_product['name'] ?? ''); ?></span>
                </div>
            </div>

            <input type="hidden" name="from_plugin" value="<?php echo esc_attr($from_plugin ?? ''); ?>">
            <input type="hidden" name="to_product" value="<?php echo esc_attr($to_product ?? ''); ?>">

            <?php if (empty($integration_name)) : ?>
                <input type="hidden" name="action" value="integrazo_wz_save_integration">
                <div class="integrazo-wz-setup-next-btn-wrapper">
                    <button type="submit" class="button button-primary" id="step1_next"><?php esc_html_e('Save and Next', 'integrazo-integration-for-zoho-apps'); ?></button>
                </div>
            <?php else : ?>
                <input type="hidden" name="integration_id" value="<?php echo esc_attr($integration_id ?? ''); ?>" />
                <input type="hidden" name="action" value="integrazo_wz_save_only">
                <div class="integrazo-wz-setup-next-btn-wrapper">
                    <button type="submit" class="button button-primary" id="step1_save_only"><?php esc_html_e('Save', 'integrazo-integration-for-zoho-apps'); ?></button>
                </div>
            <?php endif; ?>
        </form>
    </div>
</div>

<!-- Plugin Overlay Popup -->
<div class="integrazo-wz-setup-step1-overlay" id="integrazo-wz-plugin-popup" style="display: none;">
    <div class="integrazo-wz-setup-step1-popup">
        <span class="integrazo-wz-setup-step1-popup-close" id="integrazo-wz-plugin-popup-close">×</span>
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px;">
            <input type="text" id="integrazo-wz-plugin-popup-search" placeholder="<?php esc_attr_e('Search plugins...', 'integrazo-integration-for-zoho-apps'); ?>" class="integrazo-wz-setup-step1-input-search" style="width: 75%;">
        </div>

        <div class="integrazo-wz-setup-step1-plugin-grid" id="integrazo-wz-plugin-popup-list">
            <?php foreach ($ordered_plugins as $plugin) : ?>
                <?php
                $is_pro = !empty($plugin['pro']) && $plugin['pro'];
                $class_name = ($is_pro && !$session) ? 'integrazo-wz-pro-plugin' : 'integrazo-wz-setup-step1-plugin-item';
                ?>
                <div class="<?php echo esc_attr($class_name); ?>"
                    data-group="plugin"
                    data-name="<?php echo esc_attr($plugin['name']); ?>"
                    data-id="<?php echo esc_attr($plugin['id']); ?>"
                    data-source="from">
                    <div class="integrazo-wz-setup-step1-plugin-thumb <?php echo esc_attr($plugin['id']); ?>"></div>
                    <span class="integrazo-wz-setup-step1-plugin-title"><?php echo esc_html($plugin['name']); ?></span>
                   <?php if ( $is_pro && ! $session ) : ?>
                        <span class="integrazo-wz-setup-step1-plugin-pro-label">
                            Pro
                            <!-- <a href="********" target="_blank" rel="noopener noreferrer" style="text-decoration: none;">Demo</a> -->
                        </span>
                    <?php endif; ?>

                </div>
            <?php endforeach; ?>
        </div>



    </div>
</div>

<!-- Product Overlay Popup -->
<div class="integrazo-wz-setup-step1-overlay" id="integrazo-wz-product-popup" style="display: none;">
    <div class="integrazo-wz-setup-step1-popup">
        <span class="integrazo-wz-setup-step1-popup-close" id="integrazo-wz-product-popup-close">×</span>
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px;">
            <input type="text" id="integrazo-wz-product-popup-search" placeholder="<?php esc_attr_e('Search products...', 'integrazo-integration-for-zoho-apps'); ?>" class="integrazo-wz-setup-step1-input-search" style="width: 75%;">
        </div>
        <div class="integrazo-wz-setup-step1-plugin-grid" id="integrazo-wz-product-popup-list">
            <?php foreach ($ordered_products as $product) : ?>
                <?php
                $is_pro = !empty($product['pro']) && $product['pro'];
                $class_name = ($is_pro && !$session) ? 'integrazo-wz-pro-plugin' : 'integrazo-wz-setup-step1-plugin-item';
                ?>
                <div class="<?php echo esc_attr($class_name); ?>"
                    data-group="product"
                    data-name="<?php echo esc_attr($product['name']); ?>"
                    data-id="<?php echo esc_attr($product['id']); ?>"
                    data-source="to">
                    <div class="integrazo-wz-setup-step1-plugin-thumb <?php echo esc_attr($product['id']); ?>"></div>
                    <span class="integrazo-wz-setup-step1-plugin-title"><?php echo esc_html($product['name']); ?></span>
                    <?php if ($is_pro && !$session) : ?>
                        <span class="integrazo-wz-setup-step1-plugin-pro-label">Pro
                            <!-- <a href="*******" target="_blank" rel="noopener noreferrer" style="text-decoration: none;">Demo</a> -->
                        </span>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>

    </div>
</div>