<?php
// Exit if accessed directly.
if (! defined('ABSPATH')) {
    exit;
}
$pro_status = integrazo_wz_is_pro_active();
?>

<div class="wrap">
    <?php
    // phpcs:ignore WordPress.Security.NonceVerification.Recommended
    $active_subtab = isset($_GET['subtab']) ? sanitize_key(wp_unslash($_GET['subtab'])) : 'general';

    ?>

    <!-- Second-level subtabs -->
    <h1 style="display:none;"></h1>
    <div style="padding: 10px 20px;">
        <p class="integrazo-wz-settings-heading <?php echo $active_subtab === 'general' ? 'integrazo-wz-settings-heading-active' : ''; ?>">
            <a href="<?php echo esc_url(admin_url('admin.php?page=integrazo-integration-for-zoho-apps&tab=settings&subtab=general')); ?>">
                <?php esc_html_e('General', 'integrazo-integration-for-zoho-apps'); ?>
            </a>
        </p>
        <p class="integrazo-wz-settings-heading <?php echo $active_subtab === 'notifications' ? 'integrazo-wz-settings-heading-active' : ''; ?>">
            <a href="<?php echo esc_url(admin_url('admin.php?page=integrazo-integration-for-zoho-apps&tab=settings&subtab=notifications')); ?>">
                <?php esc_html_e('Notifications', 'integrazo-integration-for-zoho-apps'); ?>
            </a>
        </p>
        <p class="integrazo-wz-settings-heading <?php echo $active_subtab === 'accounts' ? 'integrazo-wz-settings-heading-active' : ''; ?>">
            <a href="<?php echo esc_url(admin_url('admin.php?page=integrazo-integration-for-zoho-apps&tab=settings&subtab=accounts')); ?>">
                <?php esc_html_e('Accounts', 'integrazo-integration-for-zoho-apps'); ?>
            </a>
        </p>
        <?php if ($pro_status) : ?>
            <p class="integrazo-wz-settings-heading <?php echo $active_subtab === 'license' ? 'integrazo-wz-settings-heading-active' : ''; ?>">
                <a href="<?php echo esc_url(admin_url('admin.php?page=integrazo-integration-for-zoho-apps&tab=settings&subtab=license')); ?>">
                    <?php esc_html_e('License', 'integrazo-integration-for-zoho-apps'); ?>
                </a>
            </p>
        <?php endif; ?>

    </div>


    <!-- General section -->
    <div class="integrazo-wz-settings-section integrazo-wz-general-section" style="<?php echo $active_subtab === 'general' ? '' : 'display:none;'; ?>">
        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" style="margin-top: 20px; max-width: 600px;">
            <?php wp_nonce_field('integrazo_wz_save_settings', 'integrazo_wz_settings_nonce'); ?>
            <input type="hidden" name="action" value="integrazo_wz_save_general_settings">

            <table class="form-table" role="presentation">
                <tbody>
                    <!-- Delete data -->
                    <tr>
                        <th scope="row">
                            <label for="delete_data_on_uninstall"><?php esc_html_e('Delete data', 'integrazo-integration-for-zoho-apps'); ?></label>
                        </th>
                        <td>
                            <fieldset>
                                <label>
                                    <input
                                        name="delete_data_on_uninstall"
                                        type="checkbox"
                                        id="delete_data_on_uninstall"
                                        value="1"
                                        <?php checked(get_option('integrazo_wz_delete_data', ''), '1'); ?>>
                                    <span><?php esc_html_e('Erase all plugin data on uninstall', 'integrazo-integration-for-zoho-apps'); ?></span>
                                </label>
                                <p class="description">
                                    <?php esc_html_e('Removes plugin database tables, logs, and settings when the plugin is deleted.', 'integrazo-integration-for-zoho-apps'); ?>
                                </p>
                            </fieldset>
                        </td>
                    </tr>

                    <!-- Log cleanup -->
                    <tr>
                        <th scope="row">
                            <label for="enable_log_cleanup"><?php esc_html_e('Log cleanup', 'integrazo-integration-for-zoho-apps'); ?></label>
                        </th>
                        <td>
                            <fieldset>
                                <label style="display: block; margin-bottom: 6px;">
                                    <input
                                        name="enable_log_cleanup"
                                        type="checkbox"
                                        id="enable_log_cleanup"
                                        value="1"
                                        <?php checked(get_option('integrazo_wz_enable_log_cleanup', ''), '1'); ?>>
                                    <span><?php esc_html_e('Enable auto log cleanup', 'integrazo-integration-for-zoho-apps'); ?></span>
                                </label>

                                <div style="display: flex; align-items: center; gap: 10px;">
                                    <input
                                        name="log_retention_days"
                                        type="number"
                                        min="1"
                                        id="log_retention_days"
                                        value="<?php echo esc_attr(get_option('integrazo_wz_log_retention_days', '')); ?>"
                                        class="small-text">
                                    <span><?php esc_html_e('days', 'integrazo-integration-for-zoho-apps'); ?></span>
                                </div>

                                <p class="description">
                                    <?php esc_html_e('Logs older than this will be deleted automatically.', 'integrazo-integration-for-zoho-apps'); ?>
                                </p>
                            </fieldset>
                        </td>
                    </tr>
                </tbody>
            </table>

            <?php submit_button(esc_html__('Save Settings', 'integrazo-integration-for-zoho-apps')); ?>
        </form>
    </div>

    <!-- Accounts section -->
    <div class="integrazo-wz-settings-section integrazo-wz-accounts-section" style="<?php echo $active_subtab === 'notifications' ? '' : 'display:none;'; ?>">
        <?php require_once INTEGRAZO_WZ_PLUGIN_DIR . 'includes/page/notifications.php'; ?>
    </div>
    <!-- Accounts section -->
    <div class="integrazo-wz-settings-section integrazo-wz-accounts-section" style="<?php echo $active_subtab === 'accounts' ? '' : 'display:none;'; ?>">
        <?php require_once INTEGRAZO_WZ_PLUGIN_DIR . 'includes/extend/accounts.php'; ?>
    </div>

    <?php if ($pro_status && defined('INTEGRAZO_WZ_PRO_PLUGIN_DIR')) : ?>
        <div class="integrazo-wz-settings-section integrazo-wz-session-section"
            style="<?php echo ($active_subtab === 'license') ? '' : 'display:none;'; ?>">
            <?php include trailingslashit(INTEGRAZO_WZ_PRO_PLUGIN_DIR) . 'includes/page/session.php'; ?>
        </div>
    <?php endif; ?>

</div>