<?php
// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

// Fetch and sanitize options from the database
$error_notification = get_option('integrazo_wz_error_notification', 'no') === 'yes' ? 'yes' : 'no';
$error_notification_email = sanitize_text_field(get_option('integrazo_wz_error_notification_email', ''));
$error_notification_subject = sanitize_text_field(get_option('integrazo_wz_error_notification_subject', ''));
?>

<form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
    <?php wp_nonce_field('integrazo_wz_save_notifications_settings', 'integrazo_wz_save_notifications_settings_nonce'); ?>

    <table class="form-table">
        <!-- Enable Error Notification -->
        <tr>
            <th scope="row">
                <label for="integrazo_wz_error_notification"><?php esc_html_e('Enable Error Notifications', 'integrazo-integration-for-zoho-apps'); ?></label>
                <div class="integrazo-wz-helpicon-help-icon-wrapper">
                    <span class="integrazo-wz-helpicon-help-icon">?</span>
                    <div class="integrazo-wz-helpicon-help-tooltip">
                        <p><?php esc_html_e('Receive email alerts when a data sync fails due to an error. Set recipient emails and customize the subject line.', 'integrazo-integration-for-zoho-apps'); ?></p>
                    </div>
                </div>
            </th>
            <td>
                <input type="checkbox" id="integrazo_wz_error_notification" name="integrazo_wz_error_notification" value="yes" <?php checked($error_notification, 'yes'); ?> />
                <span><?php esc_html_e('Send me email alerts for errors', 'integrazo-integration-for-zoho-apps'); ?></span>
            </td>
        </tr>

        <!-- Notification Email Address -->
        <tr>
            <th scope="row">
                <label for="integrazo_wz_error_notification_email"><?php esc_html_e('Notification Email(s)', 'integrazo-integration-for-zoho-apps'); ?></label>
            </th>
            <td>
                <input type="text" id="integrazo_wz_error_notification_email" name="integrazo_wz_error_notification_email" value="<?php echo esc_attr($error_notification_email); ?>" class="regular-text" />
                <p class="description"><?php esc_html_e('Enter email addresses separated by commas.', 'integrazo-integration-for-zoho-apps'); ?></p>
            </td>
        </tr>

        <!-- Notification Email Subject -->
        <tr>
            <th scope="row">
                <label for="integrazo_wz_error_notification_subject"><?php esc_html_e('Email Subject', 'integrazo-integration-for-zoho-apps'); ?></label>
            </th>
            <td>
                <input type="text" id="integrazo_wz_error_notification_subject" name="integrazo_wz_error_notification_subject" value="<?php echo esc_attr($error_notification_subject); ?>" class="regular-text" />
                <p class="description"><?php esc_html_e('Enter the subject line for error notification emails.', 'integrazo-integration-for-zoho-apps'); ?></p>
            </td>
        </tr>
    </table>

    <input type="hidden" name="action" value="integrazo_wz_save_notifications_settings">
    <?php submit_button(__('Save Settings', 'integrazo-integration-for-zoho-apps')); ?>
</form>