jQuery(document).ready(function () {
    jQuery('#new_account_btn').click(function() {
      jQuery('#integrazo-wz-select_account_section').hide();
      jQuery('#integrazo-wz-new_account_name').show();
      jQuery('#integrazo-wz-new_account_fields').slideDown();
      jQuery('.integrazo-wz-setup-step2-save-btn').hide();
      jQuery('#step2_auth').parent('div').show();
  });
  // -------------------------------------------------------- Common
  var urlParams = new URLSearchParams(window.location.search);
  var step = urlParams.get('step');

  if (step === '2') {
    jQuery('#step2 .integrazo-wz-setup-accordion-content').slideDown();
    jQuery('#step2 .integrazo-wz-setup-toggle-icon').text('−');
  } else if (step === '3') {
    jQuery('#step3 .integrazo-wz-setup-accordion-content').slideDown();
    jQuery('#step3 .integrazo-wz-setup-toggle-icon').text('−');
  } else {
    jQuery('#step1 .integrazo-wz-setup-accordion-content').slideDown();
    jQuery('#step1 .integrazo-wz-setup-toggle-icon').text('−');
  }

  jQuery('.integrazo-wz-setup-accordion-header').on('click', function () {
    var content = jQuery(this).next('.integrazo-wz-setup-accordion-content');
    var icon = jQuery(this).find('.integrazo-wz-setup-toggle-icon');

    if (content.is(':visible')) {
      content.slideUp();
      icon.text('+');
    } else {
      jQuery('.integrazo-wz-setup-accordion-content').slideUp();
      jQuery('.integrazo-wz-setup-toggle-icon').text('+');
      content.slideDown();
      icon.text('−');
    }
  });

  // -------------------------------------------------------- Step 1: tile select (plugin/product)
// Works for BOTH free (.integrazo-wz-setup-step1-plugin-item) and pro (.integrazo-wz-pro-plugin).
// Pro tiles are treated as disabled: no selection action.
jQuery(document).on('click', '[data-group="plugin"], [data-group="product"]', function () {
  var $tile = jQuery(this);

  // ⛔ Do nothing for disabled (pro) tiles
  if ($tile.hasClass('integrazo-wz-pro-plugin')) {
    return; // allow inner links (e.g., "Demo") to work normally
  }

  var group     = String($tile.attr('data-group')  || '');
  var name      = String($tile.attr('data-name')   || '');
  var plugin_id = String($tile.attr('data-id')     || '');
  var source    = String($tile.attr('data-source') || '');

  // Set hidden input values
  if (source === 'from') {
    jQuery('input[name="from_plugin"]').val(plugin_id);
  } else {
    jQuery('input[name="to_product"]').val(plugin_id);
  }

  // Update selection highlight
  jQuery('[data-group="' + group + '"]').removeClass('selected');
  $tile.addClass('selected');

  // Update main selection box (thumb class + title)
  var $box = (group === 'plugin')
    ? jQuery('[data-target="#integrazo-wz-plugin-popup"]')
    : jQuery('[data-target="#integrazo-wz-product-popup"]');

  $box.find('.integrazo-wz-setup-step1-plugin-title').text(name);
  $box.find('.integrazo-wz-setup-step1-label').text('');

  // Switch icon div to the chosen id class
  var $iconDiv = $box.find('div.integrazo-wz-setup-step1-add-icon, div.integrazo-wz-setup-step1-plugin-thumb');
  $iconDiv.removeClass().addClass('integrazo-wz-setup-step1-plugin-thumb ' + plugin_id);

  // Close popup
  jQuery('#integrazo-wz-' + group + '-popup')
    .removeClass('integrazo-wz-setup-step1-fullscreen-popup')
    .hide();
  jQuery('#integrazo-wz-' + group + '-popup-close').hide();

  // Optional (if you use “expand” triggers by id):
  jQuery('#integrazo-wz-' + group + '-popup-expand').hide();
});


  // Validate buttons
  jQuery('#step1_next').on('click', function (e) {
    var integrationName = String(jQuery('#integration_name').val() || '').trim();
    var selectedPlugin  = String(jQuery('[name="from_plugin"]').val() || '').trim();
    var selectedProduct = String(jQuery('[name="to_product"]').val() || '').trim();

    if (!integrationName) {
      alert('Please enter an Integration Name.');
      e.preventDefault();
      return false;
    }

    if (!selectedPlugin || !selectedProduct) {
      alert('Please select both plugin and integration product.');
      e.preventDefault();
      return false;
    }

    return true;
  });

  jQuery('#step1_save_only').on('click', function (e) {
    var integrationName = String(jQuery('#integration_name').val() || '').trim();
    if (!integrationName) {
      alert('Please enter an Integration Name.');
      e.preventDefault();
      return false;
    }
    return true;
  });

  // Open/Close popups
  jQuery('.integrazo-wz-setup-step1-expand-toggle').on('click', function () {
    var targetSelector = jQuery(this).attr('data-target');
    var $container = jQuery(targetSelector);
    var $closeBtn = $container.find('.integrazo-wz-setup-step1-popup-close');

    if ($container.hasClass('integrazo-wz-setup-step1-fullscreen-popup')) {
      $container.removeClass('integrazo-wz-setup-step1-fullscreen-popup').hide();
      $closeBtn.hide();
    } else {
      $container.addClass('integrazo-wz-setup-step1-fullscreen-popup').show();
      $closeBtn.show();
    }

    // Re-run search to ensure empty state visibility on open
    if (targetSelector === '#integrazo-wz-plugin-popup') {
      runSearch(jQuery('#integrazo-wz-plugin-popup-search'), '#integrazo-wz-plugin-popup-list', 'plugin');
    } else if (targetSelector === '#integrazo-wz-product-popup') {
      runSearch(jQuery('#integrazo-wz-product-popup-search'), '#integrazo-wz-product-popup-list', 'product');
    }
  });

  jQuery('.integrazo-wz-setup-step1-popup-close').on('click', function () {
    var $popup = jQuery(this).closest('.integrazo-wz-setup-step1-overlay');
    $popup.removeClass('integrazo-wz-setup-step1-fullscreen-popup').hide();
    jQuery(this).hide();
  });

  // -------------------------------------------------------- Search (both free + pro) with empty-state (no inline styles)
  var REQUEST_LINK = 'https://integrazo.com/pages/request-feature';

  function ensureEmptyState(listSelector, type) {
    var $list  = jQuery(listSelector);
    var cls    = 'integrazo-wz-empty-state';
    var $empty = $list.children('.' + cls);

    if ($empty.length === 0) {
      var text = (type === 'plugin')
        ? 'Your searched plugin is not available at the moment. Kindly raise your requirement at this link and we will try to add it as soon as possible.'
        : 'Your searched product is not available at the moment. Kindly raise your requirement at this link and we will try to add it as soon as possible.';

      $empty = jQuery(
        '<div class="' + cls + '">' +
          '<span class="integrazo-wz-empty-state-text">' + text + '</span>' +
          '<a class="integrazo-wz-empty-state-link" href="' + REQUEST_LINK + '" target="_blank" rel="noopener noreferrer">Raise your requirement</a>' +
        '</div>'
      );
      $list.append($empty);
    }
    return $empty;
  }

  function runSearch($input, listSelector, group) {
    var $list   = jQuery(listSelector);
    var val     = String($input.val() || '').toLowerCase().trim();
    var $cards  = $list.find('[data-group="' + group + '"]');

    var visibleCount = 0;
    $cards.each(function () {
      var $el   = jQuery(this);
      var name  = String($el.attr('data-name') || '').toLowerCase();
      var id    = String($el.attr('data-id')   || '').toLowerCase();
      var title = String($el.find('.integrazo-wz-setup-step1-plugin-title').text() || '').toLowerCase();
      var hay   = (name + ' ' + id + ' ' + title);
      var show  = (val === '' || hay.indexOf(val) !== -1);
      $el.toggle(show);
      if (show) visibleCount++;
    });

    var $empty = ensureEmptyState(listSelector, group);
    if (visibleCount === 0) {
      $empty.show();
    } else {
      $empty.hide();
    }
  }

  // Plugin popup search
  jQuery('#integrazo-wz-plugin-popup-search').on('input', function () {
    runSearch(jQuery(this), '#integrazo-wz-plugin-popup-list', 'plugin');
  });

  // Product popup search
  jQuery('#integrazo-wz-product-popup-search').on('input', function () {
    runSearch(jQuery(this), '#integrazo-wz-product-popup-list', 'product');
  });
});
