jQuery(document).ready(function() {
    jQuery('input[name="filter_criteria"]').on('click', function() {
        var selectedValue = jQuery(this).val();
        if (selectedValue === 'yes') {
            jQuery('.integrazo-wz-setup-filter-content').show();
        } else if (selectedValue === 'no') {
            jQuery('.integrazo-wz-setup-filter-content').hide();
        }
    });

    function getBlockHtml() {
        return `
        <div class="integrazo-wz-setup-filter-block">
            <div class="integrazo-wz-setup-filter-connector">
                <select class="integrazo-wz-setup-filter-logic">
                    <option value="AND">AND</option>
                    <option value="OR">OR</option>
                </select>
            </div>
            <div class="integrazo-wz-setup-filter-group">
                <div class="integrazo-wz-setup-filter-row">
                    <select class="integrazo-wz-setup-filter-field">
                        ${jQuery('.integrazo-wz-setup-filter-field').first().html()}
                    </select>
                    <select class="integrazo-wz-setup-filter-condition">
                        <option value="" disabled selected>Choose Condition</option>
                        <option value="contains">Contains</option>
                        <option value="not_contains">Does Not Contain</option>
                        <option value="equals">Equals</option>
                        <option value="not_equals">Does Not Equal</option>
                        <option value="starts_with">Starts With</option>
                        <option value="ends_with">Ends With</option>
                        <option value="greater_than">Greater Than</option>
                        <option value="less_than">Less Than</option>
                        <option value="is_empty">Is Empty</option>
                        <option value="is_not_empty">Is Not Empty</option>
                    </select>
                    <input type="text" class="integrazo-wz-setup-filter-value" placeholder="Enter value" />
                    <div class="integrazo-wz-setup-filter-actions">
                        <button type="button" class="integrazo-wz-setup-filter-add-icon">+</button>
                        <button type="button" class="integrazo-wz-setup-filter-close-icon">×</button>
                    </div>
                </div>
            </div>
        </div>`;
    }

    jQuery(document).on('click', '.integrazo-wz-setup-filter-add-icon', function() {
        jQuery('#integrazo-wz-setup-filter-group-container').append(getBlockHtml());
        updateConnectorVisibility();
    });

    jQuery(document).on('click', '.integrazo-wz-setup-filter-close-icon', function() {
        var $block = jQuery(this).closest('.integrazo-wz-setup-filter-block');
        if (jQuery('.integrazo-wz-setup-filter-block').length > 1) {
            $block.remove();
        } else {
            $block.find('select, input').val('');
        }
        updateConnectorVisibility();
    });

    window.integrazo_wz_clearAll = function() {
        var $container = jQuery('#integrazo-wz-setup-filter-group-container');
        var $firstBlock = $container.find('.integrazo-wz-setup-filter-block').first().clone();
        $container.html($firstBlock);
        $container.find('select, input').val('');
        $container.find('.integrazo-wz-setup-filter-connector').remove();
        updateConnectorVisibility();
    };

    function updateConnectorVisibility() {
        jQuery('.integrazo-wz-setup-filter-connector').show();
        jQuery('.integrazo-wz-setup-filter-block').first().find('.integrazo-wz-setup-filter-connector').hide();
    }

    updateConnectorVisibility();
    //
   
    
});

function getFilterData() {
    var filters = [];
    var $blocks = jQuery('.integrazo-wz-setup-filter-block');
    var hasPartial = false;
    var allFullyFilled = true;

    // Step 1: Check every row, collect fully filled, detect partials
    $blocks.each(function(index) {
        var $block = jQuery(this);
        var field = $block.find('.integrazo-wz-setup-filter-field').val();
        var condition = $block.find('.integrazo-wz-setup-filter-condition').val();
        var value = $block.find('.integrazo-wz-setup-filter-value').val();

        var isAnyFilled = field || condition || value;
        var isAllFilled = field && condition && value;

        if (isAnyFilled && !isAllFilled) {
            hasPartial = true;
        }

        if (!isAllFilled) {
            allFullyFilled = false;
        }

        if (isAllFilled) {
            filters.push({
                logic: '', // will assign later
                field: field,
                condition: condition,
                value: value,
                index: index
            });
        }
    });

    // Step 2: Check for partial rows → block
    if (hasPartial) {
        return {
            status: false,
            message: 'Please ensure all rows in the conditional logic area are fully completed before proceeding.'
        };
    }

    // Step 3: Check if all rows are fully filled, otherwise block
    if (!allFullyFilled || filters.length !== $blocks.length) {
        return {
            status: false,
            message: 'Please ensure all rows in the conditional logic area are fully completed before proceeding.'
        };
    }

    // Step 4: Assign logic only if next row exists
    for (var i = 0; i < filters.length; i++) {
        if (i < filters.length - 1) {
            var nextIndex = filters[i + 1].index;
            var $nextBlock = $blocks.eq(nextIndex);
            var logic = $nextBlock.find('.integrazo-wz-setup-filter-logic').val();
            filters[i].logic = logic;
        }
        delete filters[i].index; // cleanup index before returning
    }

    // Step 5: Return success
    return { status: true, data: filters };
}
