jQuery(document).ready(function($) {
    // Get the tab parameter from the URL
    var urlParams = new URLSearchParams(window.location.search);
    var currentPage = urlParams.get('page');
    if (currentPage === 'integrazo-integration-for-zoho-apps') {
        var activeTab = urlParams.get('tab') || 'setup'; // Default to 'auth' tab if no tab parameter is set

        // If no 'tab' parameter exists in the URL, update the URL to include 'auth' as the default
        if (!urlParams.has('tab')) {
            // Append the 'auth' tab to the URL without reloading the page
            urlParams.set('tab', 'setup');
            window.history.replaceState(null, null, '?' + urlParams.toString());
        }

        // Hide all tab content and remove active class from all tabs
        $('.integrazo-wz-tab').removeClass('integrazo-wz-tab-active');
        $('.integrazo-wz-tab-content').hide();

        // Show the active tab content and add active class to the active tab
        $('#integrazo-wz-tab-' + activeTab).addClass('integrazo-wz-tab-active');
        $('#integrazo-wz-content-' + activeTab).show();
    }
});
