jQuery(document).ready(function ($) {
  // Listen for CF7 form submit success event
  document.addEventListener(
    "wpcf7mailsent",
    function (event) {
      // Get the form ID that was submitted
      var formId = event.detail.contactFormId;

      // Prepare the form data to send to Mollie
      var formData = {
        action: "cf7_mollie_generate_payment_url",
        nonce: cf7MollieSettings.nonce, // Use the localized nonce for security
        form_id: formId,
        email: $('[name="your-email"]').val(), // Assuming your form has an email field
        amount: $('[name="payment-amount"]').val(), // Replace with your logic to calculate the payment amount
      };

      // Make an AJAX request to generate the Mollie payment URL
      $.ajax({
        url: cf7MollieSettings.ajaxUrl,
        type: "POST",
        dataType: "json",
        data: formData,
        success: function (response) {
          if (response.success && response.data.payment_url) {
            // Redirect the user to the Mollie payment page
            window.location.href = response.data.payment_url;
          } else {
            if (response.data.code !== "not_cf7_mollie")
              alert(response.data.message);
          }
        },
        error: function (xhr, status, error) {
          console.error("AJAX Error: " + error);
          alert("An error occurred. Please try again.");
        },
      });
    },
    false
  );
});
