<?php
/*
	Plugin Name: Integrate Pipedrive and Gravity Forms
	Description: Integrates Gravity Forms with Pipedrive, allowing form submissions to be automatically sent to your Pipedrive account as a person and a lead.
	Version: 1.0.0
	Requires at least: 5.4
	Author: Oyova
	License: GPLv2 or later
	Author URI: https://www.oyova.com
*/
if ( ! defined( 'ABSPATH' ) ) exit;

define('INTEGRATE_PIPEDRIVE_AND_GRAVITY_FORMS', '1.0.4');

add_action('gform_loaded', array('oyoipgf_gf_simple_feed_pipedrive_addon', 'load'), 5);

class oyoipgf_gf_simple_feed_pipedrive_addon {

	public static function load() {

		if ( ! method_exists( 'GFForms', 'include_feed_addon_framework' ) ) {
			return;
		}

		require_once 'class-integrate-pipedrive-and-gravity-forms.php';

		GFAddOn::register( 'OYOIPGF_GFSImpleFeedAddonPipeDrive' );
	}

}

function OYOIPGF_gf_simple_feed_pipedrive_addon() {
	return OYOIPGF_GFSImpleFeedAddonPipeDrive::get_instance();
}