<?php

/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Kiwi
 */

if ( ! defined( 'ABSPATH' ) ) exit;
 get_header();
 
	$post_id = get_the_ID();
	$tps_property = new stdClass();
	$tps_property->property_code = get_post_meta($post_id , 'information_property_code', true);
    // $agent=getAgentObject("OAK");
    $tps_property->agent_name="Admin-center@oaksproperty.co.nz";
    $tps_property->agent_email="Admin-center@oaksproperty.co.nz";
    $tps_property->client_code=5554;
    $tps_property->suburb= get_post_meta($post_id , 'information_suburb', true);
    $tps_property->street_number= get_post_meta($post_id , 'street_number', true);
    $tps_property->street_name = get_post_meta($post_id , 'street_name', true);
    $tps_property->city = get_post_meta($post_id , 'property_city', true);
    //  $tsp_url=get_tps_url($tps_property);
	
	$information_address = get_post_meta($post_id , 'information_address', true);
	$bedroom = get_post_meta($post_id , 'accommodation_bed_room', true);
	$bathroom = get_post_meta($post_id , 'accommodation_bath_room', true);
	$carsno = intval(get_post_meta($post_id, 'accommodation_automobile', true)) + intval(get_post_meta($post_id, 'other_parking', true));
	$property_rent = get_post_meta($post_id , 'information_rent', true);
	$available_date = get_post_meta($post_id , 'information_date' , true);
	$rental_period = get_post_meta($post_id , 'property_rental_period', true);
	$description = get_the_content();
	$description = apply_filters('the_content', $description);
	$integrate_palace_gallery = get_post_meta($post_id , 'integrate_palace_gallery', true);


	$options = get_option( IPPR_SETTINGS, [] );
	$template_type = sanitize_text_field(get_option('ipp_select_template', 'palace-property'));
	$container = $options["single_layout"] ?? 'w-full';


	// Limit property content
	$words = explode(' ', $description);
	$integrate_palace_details_excerpt = implode(' ', array_slice($words, 0, 150));
	$integrate_palace_details_content = implode(' ', array_slice($words, 150));
	if (!empty($integrate_palace_details_content)) {
		$integrate_palace_details_content = wpautop($integrate_palace_details_content);
	}

	
?>


	<div class="<?php echo esc_attr( $container ); ?> integerate_palace-content">
		<?php include( INTEGRATE_PALACE_P_PLUGIN_DIR . 'public/content/single/' . $template_type . '.php'); ?>
	</div>



	<!-- Modal Slider -->
	<div id="ipp-gallery-modal_slider"></div>



<?php get_footer(); ?>